/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataCellsFilterResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetDataCellsFilterResponse.Builder, GetDataCellsFilterResponse> {
    private static final SdkField<DataCellsFilter> DATA_CELLS_FILTER_FIELD = SdkField
            .<DataCellsFilter> builder(MarshallingType.SDK_POJO).memberName("DataCellsFilter")
            .getter(getter(GetDataCellsFilterResponse::dataCellsFilter)).setter(setter(Builder::dataCellsFilter))
            .constructor(DataCellsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCellsFilter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_CELLS_FILTER_FIELD));

    private final DataCellsFilter dataCellsFilter;

    private GetDataCellsFilterResponse(BuilderImpl builder) {
        super(builder);
        this.dataCellsFilter = builder.dataCellsFilter;
    }

    /**
     * <p>
     * A structure that describes certain columns on certain rows.
     * </p>
     * 
     * @return A structure that describes certain columns on certain rows.
     */
    public final DataCellsFilter dataCellsFilter() {
        return dataCellsFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataCellsFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataCellsFilterResponse)) {
            return false;
        }
        GetDataCellsFilterResponse other = (GetDataCellsFilterResponse) obj;
        return Objects.equals(dataCellsFilter(), other.dataCellsFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataCellsFilterResponse").add("DataCellsFilter", dataCellsFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataCellsFilter":
            return Optional.ofNullable(clazz.cast(dataCellsFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDataCellsFilterResponse, T> g) {
        return obj -> g.apply((GetDataCellsFilterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataCellsFilterResponse> {
        /**
         * <p>
         * A structure that describes certain columns on certain rows.
         * </p>
         * 
         * @param dataCellsFilter
         *        A structure that describes certain columns on certain rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataCellsFilter(DataCellsFilter dataCellsFilter);

        /**
         * <p>
         * A structure that describes certain columns on certain rows.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataCellsFilter.Builder} avoiding the
         * need to create one manually via {@link DataCellsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataCellsFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #dataCellsFilter(DataCellsFilter)}.
         * 
         * @param dataCellsFilter
         *        a consumer that will call methods on {@link DataCellsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataCellsFilter(DataCellsFilter)
         */
        default Builder dataCellsFilter(Consumer<DataCellsFilter.Builder> dataCellsFilter) {
            return dataCellsFilter(DataCellsFilter.builder().applyMutation(dataCellsFilter).build());
        }
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private DataCellsFilter dataCellsFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataCellsFilterResponse model) {
            super(model);
            dataCellsFilter(model.dataCellsFilter);
        }

        public final DataCellsFilter.Builder getDataCellsFilter() {
            return dataCellsFilter != null ? dataCellsFilter.toBuilder() : null;
        }

        public final void setDataCellsFilter(DataCellsFilter.BuilderImpl dataCellsFilter) {
            this.dataCellsFilter = dataCellsFilter != null ? dataCellsFilter.build() : null;
        }

        @Override
        public final Builder dataCellsFilter(DataCellsFilter dataCellsFilter) {
            this.dataCellsFilter = dataCellsFilter;
            return this;
        }

        @Override
        public GetDataCellsFilterResponse build() {
            return new GetDataCellsFilterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
