/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for enabling external data filtering for third-party applications to access data managed by Lake
 * Formation .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExternalFilteringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExternalFilteringConfiguration.Builder, ExternalFilteringConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ExternalFilteringConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> AUTHORIZED_TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorizedTargets")
            .getter(getter(ExternalFilteringConfiguration::authorizedTargets))
            .setter(setter(Builder::authorizedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            AUTHORIZED_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final List<String> authorizedTargets;

    private ExternalFilteringConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.authorizedTargets = builder.authorizedTargets;
    }

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     *         Formation.
     * @see EnableStatus
     */
    public final EnableStatus status() {
        return EnableStatus.fromValue(status);
    }

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnableStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     *         Formation.
     * @see EnableStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorizedTargets property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorizedTargets() {
        return authorizedTargets != null && !(authorizedTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorizedTargets} method.
     * </p>
     * 
     * @return List of third-party application <code>ARNs</code> integrated with Lake Formation.
     */
    public final List<String> authorizedTargets() {
        return authorizedTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorizedTargets() ? authorizedTargets() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalFilteringConfiguration)) {
            return false;
        }
        ExternalFilteringConfiguration other = (ExternalFilteringConfiguration) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && hasAuthorizedTargets() == other.hasAuthorizedTargets()
                && Objects.equals(authorizedTargets(), other.authorizedTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExternalFilteringConfiguration").add("Status", statusAsString())
                .add("AuthorizedTargets", hasAuthorizedTargets() ? authorizedTargets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "AuthorizedTargets":
            return Optional.ofNullable(clazz.cast(authorizedTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExternalFilteringConfiguration, T> g) {
        return obj -> g.apply((ExternalFilteringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExternalFilteringConfiguration> {
        /**
         * <p>
         * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
         * Formation.
         * </p>
         * 
         * @param status
         *        Allows to enable or disable the third-party applications that are allowed to access data managed by
         *        Lake Formation.
         * @see EnableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
         * Formation.
         * </p>
         * 
         * @param status
         *        Allows to enable or disable the third-party applications that are allowed to access data managed by
         *        Lake Formation.
         * @see EnableStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnableStatus
         */
        Builder status(EnableStatus status);

        /**
         * <p>
         * List of third-party application <code>ARNs</code> integrated with Lake Formation.
         * </p>
         * 
         * @param authorizedTargets
         *        List of third-party application <code>ARNs</code> integrated with Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTargets(Collection<String> authorizedTargets);

        /**
         * <p>
         * List of third-party application <code>ARNs</code> integrated with Lake Formation.
         * </p>
         * 
         * @param authorizedTargets
         *        List of third-party application <code>ARNs</code> integrated with Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizedTargets(String... authorizedTargets);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private List<String> authorizedTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalFilteringConfiguration model) {
            status(model.status);
            authorizedTargets(model.authorizedTargets);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnableStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getAuthorizedTargets() {
            if (authorizedTargets instanceof SdkAutoConstructList) {
                return null;
            }
            return authorizedTargets;
        }

        public final void setAuthorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
        }

        @Override
        public final Builder authorizedTargets(Collection<String> authorizedTargets) {
            this.authorizedTargets = ScopeTargetsCopier.copy(authorizedTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTargets(String... authorizedTargets) {
            authorizedTargets(Arrays.asList(authorizedTargets));
            return this;
        }

        @Override
        public ExternalFilteringConfiguration build() {
            return new ExternalFilteringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
