/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Lake Formation principal. Supported principals are IAM users or IAM roles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakePrincipal implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakePrincipal.Builder, DataLakePrincipal> {
    private static final SdkField<String> DATA_LAKE_PRINCIPAL_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DataLakePrincipalIdentifier")
            .getter(getter(DataLakePrincipal::dataLakePrincipalIdentifier))
            .setter(setter(Builder::dataLakePrincipalIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataLakePrincipalIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DATA_LAKE_PRINCIPAL_IDENTIFIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataLakePrincipalIdentifier;

    private DataLakePrincipal(BuilderImpl builder) {
        this.dataLakePrincipalIdentifier = builder.dataLakePrincipalIdentifier;
    }

    /**
     * <p>
     * An identifier for the Lake Formation principal.
     * </p>
     * 
     * @return An identifier for the Lake Formation principal.
     */
    public final String dataLakePrincipalIdentifier() {
        return dataLakePrincipalIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataLakePrincipalIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakePrincipal)) {
            return false;
        }
        DataLakePrincipal other = (DataLakePrincipal) obj;
        return Objects.equals(dataLakePrincipalIdentifier(), other.dataLakePrincipalIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakePrincipal").add("DataLakePrincipalIdentifier", dataLakePrincipalIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataLakePrincipalIdentifier":
            return Optional.ofNullable(clazz.cast(dataLakePrincipalIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakePrincipal, T> g) {
        return obj -> g.apply((DataLakePrincipal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakePrincipal> {
        /**
         * <p>
         * An identifier for the Lake Formation principal.
         * </p>
         * 
         * @param dataLakePrincipalIdentifier
         *        An identifier for the Lake Formation principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataLakePrincipalIdentifier(String dataLakePrincipalIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String dataLakePrincipalIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakePrincipal model) {
            dataLakePrincipalIdentifier(model.dataLakePrincipalIdentifier);
        }

        public final String getDataLakePrincipalIdentifier() {
            return dataLakePrincipalIdentifier;
        }

        public final void setDataLakePrincipalIdentifier(String dataLakePrincipalIdentifier) {
            this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
        }

        @Override
        public final Builder dataLakePrincipalIdentifier(String dataLakePrincipalIdentifier) {
            this.dataLakePrincipalIdentifier = dataLakePrincipalIdentifier;
            return this;
        }

        @Override
        public DataLakePrincipal build() {
            return new DataLakePrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
