/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEffectivePermissionsForPathResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetEffectivePermissionsForPathResponse.Builder, GetEffectivePermissionsForPathResponse> {
    private static final SdkField<List<PrincipalResourcePermissions>> PERMISSIONS_FIELD = SdkField
            .<List<PrincipalResourcePermissions>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(GetEffectivePermissionsForPathResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrincipalResourcePermissions> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrincipalResourcePermissions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetEffectivePermissionsForPathResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PrincipalResourcePermissions> permissions;

    private final String nextToken;

    private GetEffectivePermissionsForPathResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the permissions for the specified table or database resource located at the path in Amazon S3.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A list of the permissions for the specified table or database resource located at the path in Amazon S3.
     */
    public final List<PrincipalResourcePermissions> permissions() {
        return permissions;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve this list.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve this list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEffectivePermissionsForPathResponse)) {
            return false;
        }
        GetEffectivePermissionsForPathResponse other = (GetEffectivePermissionsForPathResponse) obj;
        return hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEffectivePermissionsForPathResponse")
                .add("Permissions", hasPermissions() ? permissions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEffectivePermissionsForPathResponse, T> g) {
        return obj -> g.apply((GetEffectivePermissionsForPathResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEffectivePermissionsForPathResponse> {
        /**
         * <p>
         * A list of the permissions for the specified table or database resource located at the path in Amazon S3.
         * </p>
         * 
         * @param permissions
         *        A list of the permissions for the specified table or database resource located at the path in Amazon
         *        S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<PrincipalResourcePermissions> permissions);

        /**
         * <p>
         * A list of the permissions for the specified table or database resource located at the path in Amazon S3.
         * </p>
         * 
         * @param permissions
         *        A list of the permissions for the specified table or database resource located at the path in Amazon
         *        S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(PrincipalResourcePermissions... permissions);

        /**
         * <p>
         * A list of the permissions for the specified table or database resource located at the path in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions.Builder#build()} is
         * called immediately and its result is passed to {@link #permissions(List<PrincipalResourcePermissions>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.PrincipalResourcePermissions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(java.util.Collection<PrincipalResourcePermissions>)
         */
        Builder permissions(Consumer<PrincipalResourcePermissions.Builder>... permissions);

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve this list.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<PrincipalResourcePermissions> permissions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEffectivePermissionsForPathResponse model) {
            super(model);
            permissions(model.permissions);
            nextToken(model.nextToken);
        }

        public final List<PrincipalResourcePermissions.Builder> getPermissions() {
            List<PrincipalResourcePermissions.Builder> result = PrincipalResourcePermissionsListCopier
                    .copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<PrincipalResourcePermissions.BuilderImpl> permissions) {
            this.permissions = PrincipalResourcePermissionsListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<PrincipalResourcePermissions> permissions) {
            this.permissions = PrincipalResourcePermissionsListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(PrincipalResourcePermissions... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<PrincipalResourcePermissions.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> PrincipalResourcePermissions.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetEffectivePermissionsForPathResponse build() {
            return new GetEffectivePermissionsForPathResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
