/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class StorageOptimizerConfigMapCopier {
    static Map<String, Map<String, String>> copy(Map<String, ? extends Map<String, String>> storageOptimizerConfigMapParam) {
        Map<String, Map<String, String>> map;
        if (storageOptimizerConfigMapParam == null || storageOptimizerConfigMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, String>> modifiableMap = new LinkedHashMap<>(storageOptimizerConfigMapParam.size());
            storageOptimizerConfigMapParam.forEach((key, value) -> {
                Map<String, String> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        modifiableMap1.put(key1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(key, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, Map<String, String>> copyEnumToString(
            Map<OptimizerType, ? extends Map<String, String>> storageOptimizerConfigMapParam) {
        Map<String, Map<String, String>> map;
        if (storageOptimizerConfigMapParam == null || storageOptimizerConfigMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, Map<String, String>> modifiableMap = new LinkedHashMap<>(storageOptimizerConfigMapParam.size());
            storageOptimizerConfigMapParam.forEach((key, value) -> {
                String result = key.toString();
                Map<String, String> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        modifiableMap1.put(key1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                modifiableMap.put(result, map1);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<OptimizerType, Map<String, String>> copyStringToEnum(
            Map<String, ? extends Map<String, String>> storageOptimizerConfigMapParam) {
        Map<OptimizerType, Map<String, String>> map;
        if (storageOptimizerConfigMapParam == null || storageOptimizerConfigMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<OptimizerType, Map<String, String>> modifiableMap = new LinkedHashMap<>(storageOptimizerConfigMapParam.size());
            storageOptimizerConfigMapParam.forEach((key, value) -> {
                OptimizerType result = OptimizerType.fromValue(key);
                Map<String, String> map1;
                if (value == null || value instanceof SdkAutoConstructMap) {
                    map1 = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, String> modifiableMap1 = new LinkedHashMap<>(value.size());
                    value.forEach((key1, value1) -> {
                        modifiableMap1.put(key1, value1);
                    });
                    map1 = Collections.unmodifiableMap(modifiableMap1);
                }
                if (result != OptimizerType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, map1);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
