/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemporaryGlueTableCredentialsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<GetTemporaryGlueTableCredentialsRequest.Builder, GetTemporaryGlueTableCredentialsRequest> {
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(GetTemporaryGlueTableCredentialsRequest::tableArn))
            .setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(GetTemporaryGlueTableCredentialsRequest::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationSeconds").getter(getter(GetTemporaryGlueTableCredentialsRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final SdkField<AuditContext> AUDIT_CONTEXT_FIELD = SdkField.<AuditContext> builder(MarshallingType.SDK_POJO)
            .memberName("AuditContext").getter(getter(GetTemporaryGlueTableCredentialsRequest::auditContext))
            .setter(setter(Builder::auditContext)).constructor(AuditContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditContext").build()).build();

    private static final SdkField<List<String>> SUPPORTED_PERMISSION_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedPermissionTypes")
            .getter(getter(GetTemporaryGlueTableCredentialsRequest::supportedPermissionTypesAsStrings))
            .setter(setter(Builder::supportedPermissionTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedPermissionTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Path")
            .getter(getter(GetTemporaryGlueTableCredentialsRequest::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<QuerySessionContext> QUERY_SESSION_CONTEXT_FIELD = SdkField
            .<QuerySessionContext> builder(MarshallingType.SDK_POJO).memberName("QuerySessionContext")
            .getter(getter(GetTemporaryGlueTableCredentialsRequest::querySessionContext))
            .setter(setter(Builder::querySessionContext)).constructor(QuerySessionContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySessionContext").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_ARN_FIELD,
            PERMISSIONS_FIELD, DURATION_SECONDS_FIELD, AUDIT_CONTEXT_FIELD, SUPPORTED_PERMISSION_TYPES_FIELD, S3_PATH_FIELD,
            QUERY_SESSION_CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TableArn", TABLE_ARN_FIELD);
                    put("Permissions", PERMISSIONS_FIELD);
                    put("DurationSeconds", DURATION_SECONDS_FIELD);
                    put("AuditContext", AUDIT_CONTEXT_FIELD);
                    put("SupportedPermissionTypes", SUPPORTED_PERMISSION_TYPES_FIELD);
                    put("S3Path", S3_PATH_FIELD);
                    put("QuerySessionContext", QUERY_SESSION_CONTEXT_FIELD);
                }
            });

    private final String tableArn;

    private final List<String> permissions;

    private final Integer durationSeconds;

    private final AuditContext auditContext;

    private final List<String> supportedPermissionTypes;

    private final String s3Path;

    private final QuerySessionContext querySessionContext;

    private GetTemporaryGlueTableCredentialsRequest(BuilderImpl builder) {
        super(builder);
        this.tableArn = builder.tableArn;
        this.permissions = builder.permissions;
        this.durationSeconds = builder.durationSeconds;
        this.auditContext = builder.auditContext;
        this.supportedPermissionTypes = builder.supportedPermissionTypes;
        this.s3Path = builder.s3Path;
        this.querySessionContext = builder.querySessionContext;
    }

    /**
     * <p>
     * The ARN identifying a table in the Data Catalog for the temporary credentials request.
     * </p>
     * 
     * @return The ARN identifying a table in the Data Catalog for the temporary credentials request.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * <p>
     * Filters the request based on the user having been granted a list of specified permissions on the requested
     * resource(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return Filters the request based on the user having been granted a list of specified permissions on the
     *         requested resource(s).
     */
    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the request based on the user having been granted a list of specified permissions on the requested
     * resource(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return Filters the request based on the user having been granted a list of specified permissions on the
     *         requested resource(s).
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.
     * </p>
     * 
     * @return The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    /**
     * <p>
     * A structure representing context to access a resource (column names, query ID, etc).
     * </p>
     * 
     * @return A structure representing context to access a resource (column names, query ID, etc).
     */
    public final AuditContext auditContext() {
        return auditContext;
    }

    /**
     * <p>
     * A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
     * <code>CELL_FILTER_PERMISSION</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPermissionTypes} method.
     * </p>
     * 
     * @return A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
     *         <code>CELL_FILTER_PERMISSION</code>.
     */
    public final List<PermissionType> supportedPermissionTypes() {
        return PermissionTypeListCopier.copyStringToEnum(supportedPermissionTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedPermissionTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedPermissionTypes() {
        return supportedPermissionTypes != null && !(supportedPermissionTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
     * <code>CELL_FILTER_PERMISSION</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedPermissionTypes} method.
     * </p>
     * 
     * @return A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
     *         <code>CELL_FILTER_PERMISSION</code>.
     */
    public final List<String> supportedPermissionTypesAsStrings() {
        return supportedPermissionTypes;
    }

    /**
     * <p>
     * The Amazon S3 path for the table.
     * </p>
     * 
     * @return The Amazon S3 path for the table.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake Formation
     * generated authorization identifier and information from the request's authorization context.
     * </p>
     * 
     * @return A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
     *         Formation generated authorization identifier and information from the request's authorization context.
     */
    public final QuerySessionContext querySessionContext() {
        return querySessionContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(auditContext());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedPermissionTypes() ? supportedPermissionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(querySessionContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemporaryGlueTableCredentialsRequest)) {
            return false;
        }
        GetTemporaryGlueTableCredentialsRequest other = (GetTemporaryGlueTableCredentialsRequest) obj;
        return Objects.equals(tableArn(), other.tableArn()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && Objects.equals(durationSeconds(), other.durationSeconds())
                && Objects.equals(auditContext(), other.auditContext())
                && hasSupportedPermissionTypes() == other.hasSupportedPermissionTypes()
                && Objects.equals(supportedPermissionTypesAsStrings(), other.supportedPermissionTypesAsStrings())
                && Objects.equals(s3Path(), other.s3Path()) && Objects.equals(querySessionContext(), other.querySessionContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemporaryGlueTableCredentialsRequest").add("TableArn", tableArn())
                .add("Permissions", hasPermissions() ? permissionsAsStrings() : null).add("DurationSeconds", durationSeconds())
                .add("AuditContext", auditContext())
                .add("SupportedPermissionTypes", hasSupportedPermissionTypes() ? supportedPermissionTypesAsStrings() : null)
                .add("S3Path", s3Path()).add("QuerySessionContext", querySessionContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        case "AuditContext":
            return Optional.ofNullable(clazz.cast(auditContext()));
        case "SupportedPermissionTypes":
            return Optional.ofNullable(clazz.cast(supportedPermissionTypesAsStrings()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "QuerySessionContext":
            return Optional.ofNullable(clazz.cast(querySessionContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTemporaryGlueTableCredentialsRequest, T> g) {
        return obj -> g.apply((GetTemporaryGlueTableCredentialsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemporaryGlueTableCredentialsRequest> {
        /**
         * <p>
         * The ARN identifying a table in the Data Catalog for the temporary credentials request.
         * </p>
         * 
         * @param tableArn
         *        The ARN identifying a table in the Data Catalog for the temporary credentials request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * Filters the request based on the user having been granted a list of specified permissions on the requested
         * resource(s).
         * </p>
         * 
         * @param permissions
         *        Filters the request based on the user having been granted a list of specified permissions on the
         *        requested resource(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * Filters the request based on the user having been granted a list of specified permissions on the requested
         * resource(s).
         * </p>
         * 
         * @param permissions
         *        Filters the request based on the user having been granted a list of specified permissions on the
         *        requested resource(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * Filters the request based on the user having been granted a list of specified permissions on the requested
         * resource(s).
         * </p>
         * 
         * @param permissions
         *        Filters the request based on the user having been granted a list of specified permissions on the
         *        requested resource(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * Filters the request based on the user having been granted a list of specified permissions on the requested
         * resource(s).
         * </p>
         * 
         * @param permissions
         *        Filters the request based on the user having been granted a list of specified permissions on the
         *        requested resource(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.
         * </p>
         * 
         * @param durationSeconds
         *        The time period, between 900 and 21,600 seconds, for the timeout of the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        /**
         * <p>
         * A structure representing context to access a resource (column names, query ID, etc).
         * </p>
         * 
         * @param auditContext
         *        A structure representing context to access a resource (column names, query ID, etc).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditContext(AuditContext auditContext);

        /**
         * <p>
         * A structure representing context to access a resource (column names, query ID, etc).
         * </p>
         * This is a convenience method that creates an instance of the {@link AuditContext.Builder} avoiding the need
         * to create one manually via {@link AuditContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuditContext.Builder#build()} is called immediately and its
         * result is passed to {@link #auditContext(AuditContext)}.
         * 
         * @param auditContext
         *        a consumer that will call methods on {@link AuditContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditContext(AuditContext)
         */
        default Builder auditContext(Consumer<AuditContext.Builder> auditContext) {
            return auditContext(AuditContext.builder().applyMutation(auditContext).build());
        }

        /**
         * <p>
         * A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
         * <code>CELL_FILTER_PERMISSION</code>.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code>
         *        and <code>CELL_FILTER_PERMISSION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes);

        /**
         * <p>
         * A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
         * <code>CELL_FILTER_PERMISSION</code>.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code>
         *        and <code>CELL_FILTER_PERMISSION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypesWithStrings(String... supportedPermissionTypes);

        /**
         * <p>
         * A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
         * <code>CELL_FILTER_PERMISSION</code>.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code>
         *        and <code>CELL_FILTER_PERMISSION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes);

        /**
         * <p>
         * A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code> and
         * <code>CELL_FILTER_PERMISSION</code>.
         * </p>
         * 
         * @param supportedPermissionTypes
         *        A list of supported permission types for the table. Valid values are <code>COLUMN_PERMISSION</code>
         *        and <code>CELL_FILTER_PERMISSION</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedPermissionTypes(PermissionType... supportedPermissionTypes);

        /**
         * <p>
         * The Amazon S3 path for the table.
         * </p>
         * 
         * @param s3Path
         *        The Amazon S3 path for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
         * Formation generated authorization identifier and information from the request's authorization context.
         * </p>
         * 
         * @param querySessionContext
         *        A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
         *        Formation generated authorization identifier and information from the request's authorization context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySessionContext(QuerySessionContext querySessionContext);

        /**
         * <p>
         * A structure used as a protocol between query engines and Lake Formation or Glue. Contains both a Lake
         * Formation generated authorization identifier and information from the request's authorization context.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuerySessionContext.Builder} avoiding the
         * need to create one manually via {@link QuerySessionContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuerySessionContext.Builder#build()} is called immediately and
         * its result is passed to {@link #querySessionContext(QuerySessionContext)}.
         * 
         * @param querySessionContext
         *        a consumer that will call methods on {@link QuerySessionContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #querySessionContext(QuerySessionContext)
         */
        default Builder querySessionContext(Consumer<QuerySessionContext.Builder> querySessionContext) {
            return querySessionContext(QuerySessionContext.builder().applyMutation(querySessionContext).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String tableArn;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private Integer durationSeconds;

        private AuditContext auditContext;

        private List<String> supportedPermissionTypes = DefaultSdkAutoConstructList.getInstance();

        private String s3Path;

        private QuerySessionContext querySessionContext;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemporaryGlueTableCredentialsRequest model) {
            super(model);
            tableArn(model.tableArn);
            permissionsWithStrings(model.permissions);
            durationSeconds(model.durationSeconds);
            auditContext(model.auditContext);
            supportedPermissionTypesWithStrings(model.supportedPermissionTypes);
            s3Path(model.s3Path);
            querySessionContext(model.querySessionContext);
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        public final AuditContext.Builder getAuditContext() {
            return auditContext != null ? auditContext.toBuilder() : null;
        }

        public final void setAuditContext(AuditContext.BuilderImpl auditContext) {
            this.auditContext = auditContext != null ? auditContext.build() : null;
        }

        @Override
        public final Builder auditContext(AuditContext auditContext) {
            this.auditContext = auditContext;
            return this;
        }

        public final Collection<String> getSupportedPermissionTypes() {
            if (supportedPermissionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedPermissionTypes;
        }

        public final void setSupportedPermissionTypes(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
        }

        @Override
        public final Builder supportedPermissionTypesWithStrings(Collection<String> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copy(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypesWithStrings(String... supportedPermissionTypes) {
            supportedPermissionTypesWithStrings(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        @Override
        public final Builder supportedPermissionTypes(Collection<PermissionType> supportedPermissionTypes) {
            this.supportedPermissionTypes = PermissionTypeListCopier.copyEnumToString(supportedPermissionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedPermissionTypes(PermissionType... supportedPermissionTypes) {
            supportedPermissionTypes(Arrays.asList(supportedPermissionTypes));
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final QuerySessionContext.Builder getQuerySessionContext() {
            return querySessionContext != null ? querySessionContext.toBuilder() : null;
        }

        public final void setQuerySessionContext(QuerySessionContext.BuilderImpl querySessionContext) {
            this.querySessionContext = querySessionContext != null ? querySessionContext.build() : null;
        }

        @Override
        public final Builder querySessionContext(QuerySessionContext querySessionContext) {
            this.querySessionContext = querySessionContext;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemporaryGlueTableCredentialsRequest build() {
            return new GetTemporaryGlueTableCredentialsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
