/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LFTagErrorsCopier {
    static List<LFTagError> copy(Collection<? extends LFTagError> lfTagErrorsParam) {
        List<LFTagError> list;
        if (lfTagErrorsParam == null || lfTagErrorsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LFTagError> modifiableList = new ArrayList<>(lfTagErrorsParam.size());
            lfTagErrorsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LFTagError> copyFromBuilder(Collection<? extends LFTagError.Builder> lfTagErrorsParam) {
        List<LFTagError> list;
        if (lfTagErrorsParam == null || lfTagErrorsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LFTagError> modifiableList = new ArrayList<>(lfTagErrorsParam.size());
            lfTagErrorsParam.forEach(entry -> {
                LFTagError member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<LFTagError.Builder> copyToBuilder(Collection<? extends LFTagError> lfTagErrorsParam) {
        List<LFTagError.Builder> list;
        if (lfTagErrorsParam == null || lfTagErrorsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<LFTagError.Builder> modifiableList = new ArrayList<>(lfTagErrorsParam.size());
            lfTagErrorsParam.forEach(entry -> {
                LFTagError.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
