/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLakeFormationOptInsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<ListLakeFormationOptInsRequest.Builder, ListLakeFormationOptInsRequest> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(ListLakeFormationOptInsRequest::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(ListLakeFormationOptInsRequest::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLakeFormationOptInsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLakeFormationOptInsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            RESOURCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Principal", PRINCIPAL_FIELD);
                    put("Resource", RESOURCE_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final DataLakePrincipal principal;

    private final Resource resource;

    private final Integer maxResults;

    private final String nextToken;

    private ListLakeFormationOptInsRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns the value of the Principal property for this object.
     * 
     * @return The value of the Principal property for this object.
     */
    public final DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * A structure for the resource.
     * </p>
     * 
     * @return A structure for the resource.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve this list.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve this list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLakeFormationOptInsRequest)) {
            return false;
        }
        ListLakeFormationOptInsRequest other = (ListLakeFormationOptInsRequest) obj;
        return Objects.equals(principal(), other.principal()) && Objects.equals(resource(), other.resource())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLakeFormationOptInsRequest").add("Principal", principal()).add("Resource", resource())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLakeFormationOptInsRequest, T> g) {
        return obj -> g.apply((ListLakeFormationOptInsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLakeFormationOptInsRequest> {
        /**
         * Sets the value of the Principal property for this object.
         *
         * @param principal
         *        The new value for the Principal property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * Sets the value of the Principal property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the
         * need to create one manually via {@link DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * A structure for the resource.
         * </p>
         * 
         * @param resource
         *        A structure for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * A structure for the resource.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve this list.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private DataLakePrincipal principal;

        private Resource resource;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLakeFormationOptInsRequest model) {
            super(model);
            principal(model.principal);
            resource(model.resource);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLakeFormationOptInsRequest build() {
            return new ListLakeFormationOptInsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
