/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPermissionsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<ListPermissionsRequest.Builder, ListPermissionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(ListPermissionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(ListPermissionsRequest::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListPermissionsRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(ListPermissionsRequest::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPermissionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPermissionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> INCLUDE_RELATED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncludeRelated").getter(getter(ListPermissionsRequest::includeRelated))
            .setter(setter(Builder::includeRelated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRelated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            PRINCIPAL_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, INCLUDE_RELATED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CatalogId", CATALOG_ID_FIELD);
                    put("Principal", PRINCIPAL_FIELD);
                    put("ResourceType", RESOURCE_TYPE_FIELD);
                    put("Resource", RESOURCE_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("IncludeRelated", INCLUDE_RELATED_FIELD);
                }
            });

    private final String catalogId;

    private final DataLakePrincipal principal;

    private final String resourceType;

    private final Resource resource;

    private final String nextToken;

    private final Integer maxResults;

    private final String includeRelated;

    private ListPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.principal = builder.principal;
        this.resourceType = builder.resourceType;
        this.resource = builder.resource;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.includeRelated = builder.includeRelated;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * Specifies a principal to filter the permissions returned.
     * </p>
     * 
     * @return Specifies a principal to filter the permissions returned.
     */
    public final DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * Specifies a resource type to filter the permissions returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DataLakeResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies a resource type to filter the permissions returned.
     * @see DataLakeResourceType
     */
    public final DataLakeResourceType resourceType() {
        return DataLakeResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies a resource type to filter the permissions returned.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link DataLakeResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies a resource type to filter the permissions returned.
     * @see DataLakeResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * A resource where you will get a list of the principal permissions.
     * </p>
     * <p>
     * This operation does not support getting privileges on a table with columns. Instead, call this operation on the
     * table, and the operation returns the table and the table w columns.
     * </p>
     * 
     * @return A resource where you will get a list of the principal permissions.</p>
     *         <p>
     *         This operation does not support getting privileges on a table with columns. Instead, call this operation
     *         on the table, and the operation returns the table and the table w columns.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * A continuation token, if this is not the first call to retrieve this list.
     * </p>
     * 
     * @return A continuation token, if this is not the first call to retrieve this list.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Indicates that related permissions should be included in the results.
     * </p>
     * 
     * @return Indicates that related permissions should be included in the results.
     */
    public final String includeRelated() {
        return includeRelated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(includeRelated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPermissionsRequest)) {
            return false;
        }
        ListPermissionsRequest other = (ListPermissionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(principal(), other.principal())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resource(), other.resource()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(includeRelated(), other.includeRelated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPermissionsRequest").add("CatalogId", catalogId()).add("Principal", principal())
                .add("ResourceType", resourceTypeAsString()).add("Resource", resource()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("IncludeRelated", includeRelated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "IncludeRelated":
            return Optional.ofNullable(clazz.cast(includeRelated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPermissionsRequest, T> g) {
        return obj -> g.apply((ListPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPermissionsRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your Lake
         * Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * Specifies a principal to filter the permissions returned.
         * </p>
         * 
         * @param principal
         *        Specifies a principal to filter the permissions returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * <p>
         * Specifies a principal to filter the permissions returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the
         * need to create one manually via {@link DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * Specifies a resource type to filter the permissions returned.
         * </p>
         * 
         * @param resourceType
         *        Specifies a resource type to filter the permissions returned.
         * @see DataLakeResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies a resource type to filter the permissions returned.
         * </p>
         * 
         * @param resourceType
         *        Specifies a resource type to filter the permissions returned.
         * @see DataLakeResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataLakeResourceType
         */
        Builder resourceType(DataLakeResourceType resourceType);

        /**
         * <p>
         * A resource where you will get a list of the principal permissions.
         * </p>
         * <p>
         * This operation does not support getting privileges on a table with columns. Instead, call this operation on
         * the table, and the operation returns the table and the table w columns.
         * </p>
         * 
         * @param resource
         *        A resource where you will get a list of the principal permissions.</p>
         *        <p>
         *        This operation does not support getting privileges on a table with columns. Instead, call this
         *        operation on the table, and the operation returns the table and the table w columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * A resource where you will get a list of the principal permissions.
         * </p>
         * <p>
         * This operation does not support getting privileges on a table with columns. Instead, call this operation on
         * the table, and the operation returns the table and the table w columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * A continuation token, if this is not the first call to retrieve this list.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is not the first call to retrieve this list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Indicates that related permissions should be included in the results.
         * </p>
         * 
         * @param includeRelated
         *        Indicates that related permissions should be included in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRelated(String includeRelated);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private DataLakePrincipal principal;

        private String resourceType;

        private Resource resource;

        private String nextToken;

        private Integer maxResults;

        private String includeRelated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPermissionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            principal(model.principal);
            resourceType(model.resourceType);
            resource(model.resource);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            includeRelated(model.includeRelated);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(DataLakeResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getIncludeRelated() {
            return includeRelated;
        }

        public final void setIncludeRelated(String includeRelated) {
            this.includeRelated = includeRelated;
        }

        @Override
        public final Builder includeRelated(String includeRelated) {
            this.includeRelated = includeRelated;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPermissionsRequest build() {
            return new ListPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
