/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeDecoratedRoleWithSamlRequest extends LakeFormationRequest implements
        ToCopyableBuilder<AssumeDecoratedRoleWithSamlRequest.Builder, AssumeDecoratedRoleWithSamlRequest> {
    private static final SdkField<String> SAML_ASSERTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLAssertion").getter(getter(AssumeDecoratedRoleWithSamlRequest::samlAssertion))
            .setter(setter(Builder::samlAssertion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLAssertion").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AssumeDecoratedRoleWithSamlRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalArn").getter(getter(AssumeDecoratedRoleWithSamlRequest::principalArn))
            .setter(setter(Builder::principalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalArn").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationSeconds").getter(getter(AssumeDecoratedRoleWithSamlRequest::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_ASSERTION_FIELD,
            ROLE_ARN_FIELD, PRINCIPAL_ARN_FIELD, DURATION_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("SAMLAssertion", SAML_ASSERTION_FIELD);
                    put("RoleArn", ROLE_ARN_FIELD);
                    put("PrincipalArn", PRINCIPAL_ARN_FIELD);
                    put("DurationSeconds", DURATION_SECONDS_FIELD);
                }
            });

    private final String samlAssertion;

    private final String roleArn;

    private final String principalArn;

    private final Integer durationSeconds;

    private AssumeDecoratedRoleWithSamlRequest(BuilderImpl builder) {
        super(builder);
        this.samlAssertion = builder.samlAssertion;
        this.roleArn = builder.roleArn;
        this.principalArn = builder.principalArn;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * A SAML assertion consisting of an assertion statement for the user who needs temporary credentials. This must
     * match the SAML assertion that was issued to IAM. This must be Base64 encoded.
     * </p>
     * 
     * @return A SAML assertion consisting of an assertion statement for the user who needs temporary credentials. This
     *         must match the SAML assertion that was issued to IAM. This must be Base64 encoded.
     */
    public final String samlAssertion() {
        return samlAssertion;
    }

    /**
     * <p>
     * The role that represents an IAM principal whose scope down policy allows it to call credential vending APIs such
     * as <code>GetTemporaryTableCredentials</code>. The caller must also have iam:PassRole permission on this role.
     * </p>
     * 
     * @return The role that represents an IAM principal whose scope down policy allows it to call credential vending
     *         APIs such as <code>GetTemporaryTableCredentials</code>. The caller must also have iam:PassRole permission
     *         on this role.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
     */
    public final String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The time period, between 900 and 43,200 seconds, for the timeout of the temporary credentials.
     * </p>
     * 
     * @return The time period, between 900 and 43,200 seconds, for the timeout of the temporary credentials.
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(samlAssertion());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeDecoratedRoleWithSamlRequest)) {
            return false;
        }
        AssumeDecoratedRoleWithSamlRequest other = (AssumeDecoratedRoleWithSamlRequest) obj;
        return Objects.equals(samlAssertion(), other.samlAssertion()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(principalArn(), other.principalArn())
                && Objects.equals(durationSeconds(), other.durationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssumeDecoratedRoleWithSamlRequest").add("SAMLAssertion", samlAssertion())
                .add("RoleArn", roleArn()).add("PrincipalArn", principalArn()).add("DurationSeconds", durationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SAMLAssertion":
            return Optional.ofNullable(clazz.cast(samlAssertion()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "PrincipalArn":
            return Optional.ofNullable(clazz.cast(principalArn()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssumeDecoratedRoleWithSamlRequest, T> g) {
        return obj -> g.apply((AssumeDecoratedRoleWithSamlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssumeDecoratedRoleWithSamlRequest> {
        /**
         * <p>
         * A SAML assertion consisting of an assertion statement for the user who needs temporary credentials. This must
         * match the SAML assertion that was issued to IAM. This must be Base64 encoded.
         * </p>
         * 
         * @param samlAssertion
         *        A SAML assertion consisting of an assertion statement for the user who needs temporary credentials.
         *        This must match the SAML assertion that was issued to IAM. This must be Base64 encoded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlAssertion(String samlAssertion);

        /**
         * <p>
         * The role that represents an IAM principal whose scope down policy allows it to call credential vending APIs
         * such as <code>GetTemporaryTableCredentials</code>. The caller must also have iam:PassRole permission on this
         * role.
         * </p>
         * 
         * @param roleArn
         *        The role that represents an IAM principal whose scope down policy allows it to call credential vending
         *        APIs such as <code>GetTemporaryTableCredentials</code>. The caller must also have iam:PassRole
         *        permission on this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
         * </p>
         * 
         * @param principalArn
         *        The Amazon Resource Name (ARN) of the SAML provider in IAM that describes the IdP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The time period, between 900 and 43,200 seconds, for the timeout of the temporary credentials.
         * </p>
         * 
         * @param durationSeconds
         *        The time period, between 900 and 43,200 seconds, for the timeout of the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String samlAssertion;

        private String roleArn;

        private String principalArn;

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeDecoratedRoleWithSamlRequest model) {
            super(model);
            samlAssertion(model.samlAssertion);
            roleArn(model.roleArn);
            principalArn(model.principalArn);
            durationSeconds(model.durationSeconds);
        }

        public final String getSamlAssertion() {
            return samlAssertion;
        }

        public final void setSamlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
        }

        @Override
        public final Builder samlAssertion(String samlAssertion) {
            this.samlAssertion = samlAssertion;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssumeDecoratedRoleWithSamlRequest build() {
            return new AssumeDecoratedRoleWithSamlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
