/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLakeFormationIdentityCenterConfigurationRequest extends LakeFormationRequest
        implements
        ToCopyableBuilder<CreateLakeFormationIdentityCenterConfigurationRequest.Builder, CreateLakeFormationIdentityCenterConfigurationRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(CreateLakeFormationIdentityCenterConfigurationRequest::catalogId))
            .setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(CreateLakeFormationIdentityCenterConfigurationRequest::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<ExternalFilteringConfiguration> EXTERNAL_FILTERING_FIELD = SdkField
            .<ExternalFilteringConfiguration> builder(MarshallingType.SDK_POJO).memberName("ExternalFiltering")
            .getter(getter(CreateLakeFormationIdentityCenterConfigurationRequest::externalFiltering))
            .setter(setter(Builder::externalFiltering)).constructor(ExternalFilteringConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalFiltering").build()).build();

    private static final SdkField<List<DataLakePrincipal>> SHARE_RECIPIENTS_FIELD = SdkField
            .<List<DataLakePrincipal>> builder(MarshallingType.LIST)
            .memberName("ShareRecipients")
            .getter(getter(CreateLakeFormationIdentityCenterConfigurationRequest::shareRecipients))
            .setter(setter(Builder::shareRecipients))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareRecipients").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataLakePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataLakePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            INSTANCE_ARN_FIELD, EXTERNAL_FILTERING_FIELD, SHARE_RECIPIENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("CatalogId", CATALOG_ID_FIELD);
                    put("InstanceArn", INSTANCE_ARN_FIELD);
                    put("ExternalFiltering", EXTERNAL_FILTERING_FIELD);
                    put("ShareRecipients", SHARE_RECIPIENTS_FIELD);
                }
            });

    private final String catalogId;

    private final String instanceArn;

    private final ExternalFilteringConfiguration externalFiltering;

    private final List<DataLakePrincipal> shareRecipients;

    private CreateLakeFormationIdentityCenterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.instanceArn = builder.instanceArn;
        this.externalFiltering = builder.externalFiltering;
        this.shareRecipients = builder.shareRecipients;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, view definitions, and other control information to
     * manage your Lake Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, view definitions, and other control
     *         information to manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance for which the operation will be executed. For more information about
     * ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web Services
     * General Reference.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance for which the operation will be executed. For more
     *         information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in
     *         the Amazon Web Services General Reference.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to access
     * data managed by Lake Formation.
     * </p>
     * 
     * @return A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to
     *         access data managed by Lake Formation.
     */
    public final ExternalFilteringConfiguration externalFiltering() {
        return externalFiltering;
    }

    /**
     * For responses, this returns true if the service returned a value for the ShareRecipients property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasShareRecipients() {
        return shareRecipients != null && !(shareRecipients instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit ARNs that
     * are allowed to access data managed by Lake Formation.
     * </p>
     * <p>
     * If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the principals
     * you want to have access to the resources.
     * </p>
     * <p>
     * If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShareRecipients} method.
     * </p>
     * 
     * @return A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit
     *         ARNs that are allowed to access data managed by Lake Formation. </p>
     *         <p>
     *         If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the
     *         principals you want to have access to the resources.
     *         </p>
     *         <p>
     *         If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
     */
    public final List<DataLakePrincipal> shareRecipients() {
        return shareRecipients;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(externalFiltering());
        hashCode = 31 * hashCode + Objects.hashCode(hasShareRecipients() ? shareRecipients() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLakeFormationIdentityCenterConfigurationRequest)) {
            return false;
        }
        CreateLakeFormationIdentityCenterConfigurationRequest other = (CreateLakeFormationIdentityCenterConfigurationRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(externalFiltering(), other.externalFiltering())
                && hasShareRecipients() == other.hasShareRecipients()
                && Objects.equals(shareRecipients(), other.shareRecipients());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLakeFormationIdentityCenterConfigurationRequest").add("CatalogId", catalogId())
                .add("InstanceArn", instanceArn()).add("ExternalFiltering", externalFiltering())
                .add("ShareRecipients", hasShareRecipients() ? shareRecipients() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "ExternalFiltering":
            return Optional.ofNullable(clazz.cast(externalFiltering()));
        case "ShareRecipients":
            return Optional.ofNullable(clazz.cast(shareRecipients()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateLakeFormationIdentityCenterConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLakeFormationIdentityCenterConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLakeFormationIdentityCenterConfigurationRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, view definitions, and other control information
         * to manage your Lake Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, view definitions, and other
         *        control information to manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The ARN of the IAM Identity Center instance for which the operation will be executed. For more information
         * about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in the Amazon Web
         * Services General Reference.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the IAM Identity Center instance for which the operation will be executed. For more
         *        information about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces in
         *        the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to
         * access data managed by Lake Formation.
         * </p>
         * 
         * @param externalFiltering
         *        A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed
         *        to access data managed by Lake Formation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalFiltering(ExternalFilteringConfiguration externalFiltering);

        /**
         * <p>
         * A list of the account IDs of Amazon Web Services accounts of third-party applications that are allowed to
         * access data managed by Lake Formation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalFilteringConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExternalFilteringConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalFilteringConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #externalFiltering(ExternalFilteringConfiguration)}.
         * 
         * @param externalFiltering
         *        a consumer that will call methods on {@link ExternalFilteringConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalFiltering(ExternalFilteringConfiguration)
         */
        default Builder externalFiltering(Consumer<ExternalFilteringConfiguration.Builder> externalFiltering) {
            return externalFiltering(ExternalFilteringConfiguration.builder().applyMutation(externalFiltering).build());
        }

        /**
         * <p>
         * A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit ARNs
         * that are allowed to access data managed by Lake Formation.
         * </p>
         * <p>
         * If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the
         * principals you want to have access to the resources.
         * </p>
         * <p>
         * If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
         * </p>
         * 
         * @param shareRecipients
         *        A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit
         *        ARNs that are allowed to access data managed by Lake Formation. </p>
         *        <p>
         *        If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the
         *        principals you want to have access to the resources.
         *        </p>
         *        <p>
         *        If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareRecipients(Collection<DataLakePrincipal> shareRecipients);

        /**
         * <p>
         * A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit ARNs
         * that are allowed to access data managed by Lake Formation.
         * </p>
         * <p>
         * If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the
         * principals you want to have access to the resources.
         * </p>
         * <p>
         * If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
         * </p>
         * 
         * @param shareRecipients
         *        A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit
         *        ARNs that are allowed to access data managed by Lake Formation. </p>
         *        <p>
         *        If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the
         *        principals you want to have access to the resources.
         *        </p>
         *        <p>
         *        If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareRecipients(DataLakePrincipal... shareRecipients);

        /**
         * <p>
         * A list of Amazon Web Services account IDs and/or Amazon Web Services organization/organizational unit ARNs
         * that are allowed to access data managed by Lake Formation.
         * </p>
         * <p>
         * If the <code>ShareRecipients</code> list includes valid values, a resource share is created with the
         * principals you want to have access to the resources.
         * </p>
         * <p>
         * If the <code>ShareRecipients</code> value is null or the list is empty, no resource share is created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #shareRecipients(List<DataLakePrincipal>)}.
         * 
         * @param shareRecipients
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shareRecipients(java.util.Collection<DataLakePrincipal>)
         */
        Builder shareRecipients(Consumer<DataLakePrincipal.Builder>... shareRecipients);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String instanceArn;

        private ExternalFilteringConfiguration externalFiltering;

        private List<DataLakePrincipal> shareRecipients = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLakeFormationIdentityCenterConfigurationRequest model) {
            super(model);
            catalogId(model.catalogId);
            instanceArn(model.instanceArn);
            externalFiltering(model.externalFiltering);
            shareRecipients(model.shareRecipients);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final ExternalFilteringConfiguration.Builder getExternalFiltering() {
            return externalFiltering != null ? externalFiltering.toBuilder() : null;
        }

        public final void setExternalFiltering(ExternalFilteringConfiguration.BuilderImpl externalFiltering) {
            this.externalFiltering = externalFiltering != null ? externalFiltering.build() : null;
        }

        @Override
        public final Builder externalFiltering(ExternalFilteringConfiguration externalFiltering) {
            this.externalFiltering = externalFiltering;
            return this;
        }

        public final List<DataLakePrincipal.Builder> getShareRecipients() {
            List<DataLakePrincipal.Builder> result = DataLakePrincipalListCopier.copyToBuilder(this.shareRecipients);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareRecipients(Collection<DataLakePrincipal.BuilderImpl> shareRecipients) {
            this.shareRecipients = DataLakePrincipalListCopier.copyFromBuilder(shareRecipients);
        }

        @Override
        public final Builder shareRecipients(Collection<DataLakePrincipal> shareRecipients) {
            this.shareRecipients = DataLakePrincipalListCopier.copy(shareRecipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRecipients(DataLakePrincipal... shareRecipients) {
            shareRecipients(Arrays.asList(shareRecipients));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRecipients(Consumer<DataLakePrincipal.Builder>... shareRecipients) {
            shareRecipients(Stream.of(shareRecipients).map(c -> DataLakePrincipal.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLakeFormationIdentityCenterConfigurationRequest build() {
            return new CreateLakeFormationIdentityCenterConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
