/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetQueryStatisticsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetQueryStatisticsResponse.Builder, GetQueryStatisticsResponse> {
    private static final SdkField<ExecutionStatistics> EXECUTION_STATISTICS_FIELD = SdkField
            .<ExecutionStatistics> builder(MarshallingType.SDK_POJO).memberName("ExecutionStatistics")
            .getter(getter(GetQueryStatisticsResponse::executionStatistics)).setter(setter(Builder::executionStatistics))
            .constructor(ExecutionStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatistics").build())
            .build();

    private static final SdkField<PlanningStatistics> PLANNING_STATISTICS_FIELD = SdkField
            .<PlanningStatistics> builder(MarshallingType.SDK_POJO).memberName("PlanningStatistics")
            .getter(getter(GetQueryStatisticsResponse::planningStatistics)).setter(setter(Builder::planningStatistics))
            .constructor(PlanningStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanningStatistics").build())
            .build();

    private static final SdkField<Instant> QUERY_SUBMISSION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("QuerySubmissionTime")
            .getter(getter(GetQueryStatisticsResponse::querySubmissionTime))
            .setter(setter(Builder::querySubmissionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySubmissionTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_STATISTICS_FIELD,
            PLANNING_STATISTICS_FIELD, QUERY_SUBMISSION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ExecutionStatistics", EXECUTION_STATISTICS_FIELD);
                    put("PlanningStatistics", PLANNING_STATISTICS_FIELD);
                    put("QuerySubmissionTime", QUERY_SUBMISSION_TIME_FIELD);
                }
            });

    private final ExecutionStatistics executionStatistics;

    private final PlanningStatistics planningStatistics;

    private final Instant querySubmissionTime;

    private GetQueryStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.executionStatistics = builder.executionStatistics;
        this.planningStatistics = builder.planningStatistics;
        this.querySubmissionTime = builder.querySubmissionTime;
    }

    /**
     * <p>
     * An <code>ExecutionStatistics</code> structure containing execution statistics.
     * </p>
     * 
     * @return An <code>ExecutionStatistics</code> structure containing execution statistics.
     */
    public final ExecutionStatistics executionStatistics() {
        return executionStatistics;
    }

    /**
     * <p>
     * A <code>PlanningStatistics</code> structure containing query planning statistics.
     * </p>
     * 
     * @return A <code>PlanningStatistics</code> structure containing query planning statistics.
     */
    public final PlanningStatistics planningStatistics() {
        return planningStatistics;
    }

    /**
     * <p>
     * The time that the query was submitted.
     * </p>
     * 
     * @return The time that the query was submitted.
     */
    public final Instant querySubmissionTime() {
        return querySubmissionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(planningStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(querySubmissionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryStatisticsResponse)) {
            return false;
        }
        GetQueryStatisticsResponse other = (GetQueryStatisticsResponse) obj;
        return Objects.equals(executionStatistics(), other.executionStatistics())
                && Objects.equals(planningStatistics(), other.planningStatistics())
                && Objects.equals(querySubmissionTime(), other.querySubmissionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetQueryStatisticsResponse").add("ExecutionStatistics", executionStatistics())
                .add("PlanningStatistics", planningStatistics()).add("QuerySubmissionTime", querySubmissionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionStatistics":
            return Optional.ofNullable(clazz.cast(executionStatistics()));
        case "PlanningStatistics":
            return Optional.ofNullable(clazz.cast(planningStatistics()));
        case "QuerySubmissionTime":
            return Optional.ofNullable(clazz.cast(querySubmissionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryStatisticsResponse, T> g) {
        return obj -> g.apply((GetQueryStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetQueryStatisticsResponse> {
        /**
         * <p>
         * An <code>ExecutionStatistics</code> structure containing execution statistics.
         * </p>
         * 
         * @param executionStatistics
         *        An <code>ExecutionStatistics</code> structure containing execution statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatistics(ExecutionStatistics executionStatistics);

        /**
         * <p>
         * An <code>ExecutionStatistics</code> structure containing execution statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStatistics.Builder} avoiding the
         * need to create one manually via {@link ExecutionStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStatistics.Builder#build()} is called immediately and
         * its result is passed to {@link #executionStatistics(ExecutionStatistics)}.
         * 
         * @param executionStatistics
         *        a consumer that will call methods on {@link ExecutionStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStatistics(ExecutionStatistics)
         */
        default Builder executionStatistics(Consumer<ExecutionStatistics.Builder> executionStatistics) {
            return executionStatistics(ExecutionStatistics.builder().applyMutation(executionStatistics).build());
        }

        /**
         * <p>
         * A <code>PlanningStatistics</code> structure containing query planning statistics.
         * </p>
         * 
         * @param planningStatistics
         *        A <code>PlanningStatistics</code> structure containing query planning statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planningStatistics(PlanningStatistics planningStatistics);

        /**
         * <p>
         * A <code>PlanningStatistics</code> structure containing query planning statistics.
         * </p>
         * This is a convenience method that creates an instance of the {@link PlanningStatistics.Builder} avoiding the
         * need to create one manually via {@link PlanningStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PlanningStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #planningStatistics(PlanningStatistics)}.
         * 
         * @param planningStatistics
         *        a consumer that will call methods on {@link PlanningStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #planningStatistics(PlanningStatistics)
         */
        default Builder planningStatistics(Consumer<PlanningStatistics.Builder> planningStatistics) {
            return planningStatistics(PlanningStatistics.builder().applyMutation(planningStatistics).build());
        }

        /**
         * <p>
         * The time that the query was submitted.
         * </p>
         * 
         * @param querySubmissionTime
         *        The time that the query was submitted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySubmissionTime(Instant querySubmissionTime);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private ExecutionStatistics executionStatistics;

        private PlanningStatistics planningStatistics;

        private Instant querySubmissionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryStatisticsResponse model) {
            super(model);
            executionStatistics(model.executionStatistics);
            planningStatistics(model.planningStatistics);
            querySubmissionTime(model.querySubmissionTime);
        }

        public final ExecutionStatistics.Builder getExecutionStatistics() {
            return executionStatistics != null ? executionStatistics.toBuilder() : null;
        }

        public final void setExecutionStatistics(ExecutionStatistics.BuilderImpl executionStatistics) {
            this.executionStatistics = executionStatistics != null ? executionStatistics.build() : null;
        }

        @Override
        public final Builder executionStatistics(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
            return this;
        }

        public final PlanningStatistics.Builder getPlanningStatistics() {
            return planningStatistics != null ? planningStatistics.toBuilder() : null;
        }

        public final void setPlanningStatistics(PlanningStatistics.BuilderImpl planningStatistics) {
            this.planningStatistics = planningStatistics != null ? planningStatistics.build() : null;
        }

        @Override
        public final Builder planningStatistics(PlanningStatistics planningStatistics) {
            this.planningStatistics = planningStatistics;
            return this;
        }

        public final Instant getQuerySubmissionTime() {
            return querySubmissionTime;
        }

        public final void setQuerySubmissionTime(Instant querySubmissionTime) {
            this.querySubmissionTime = querySubmissionTime;
        }

        @Override
        public final Builder querySubmissionTime(Instant querySubmissionTime) {
            this.querySubmissionTime = querySubmissionTime;
            return this;
        }

        @Override
        public GetQueryStatisticsResponse build() {
            return new GetQueryStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
