/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTemporaryGlueTableCredentialsResponse extends LakeFormationResponse implements
        ToCopyableBuilder<GetTemporaryGlueTableCredentialsResponse.Builder, GetTemporaryGlueTableCredentialsResponse> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessKeyId").getter(getter(GetTemporaryGlueTableCredentialsResponse::accessKeyId))
            .setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()).build();

    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretAccessKey").getter(getter(GetTemporaryGlueTableCredentialsResponse::secretAccessKey))
            .setter(setter(Builder::secretAccessKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretAccessKey").build()).build();

    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionToken").getter(getter(GetTemporaryGlueTableCredentialsResponse::sessionToken))
            .setter(setter(Builder::sessionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionToken").build()).build();

    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Expiration").getter(getter(GetTemporaryGlueTableCredentialsResponse::expiration))
            .setter(setter(Builder::expiration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").build()).build();

    private static final SdkField<List<String>> VENDED_S3_PATH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VendedS3Path")
            .getter(getter(GetTemporaryGlueTableCredentialsResponse::vendedS3Path))
            .setter(setter(Builder::vendedS3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendedS3Path").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD,
            SECRET_ACCESS_KEY_FIELD, SESSION_TOKEN_FIELD, EXPIRATION_FIELD, VENDED_S3_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("AccessKeyId", ACCESS_KEY_ID_FIELD);
                    put("SecretAccessKey", SECRET_ACCESS_KEY_FIELD);
                    put("SessionToken", SESSION_TOKEN_FIELD);
                    put("Expiration", EXPIRATION_FIELD);
                    put("VendedS3Path", VENDED_S3_PATH_FIELD);
                }
            });

    private final String accessKeyId;

    private final String secretAccessKey;

    private final String sessionToken;

    private final Instant expiration;

    private final List<String> vendedS3Path;

    private GetTemporaryGlueTableCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
        this.vendedS3Path = builder.vendedS3Path;
    }

    /**
     * <p>
     * The access key ID for the temporary credentials.
     * </p>
     * 
     * @return The access key ID for the temporary credentials.
     */
    public final String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The secret key for the temporary credentials.
     * </p>
     * 
     * @return The secret key for the temporary credentials.
     */
    public final String secretAccessKey() {
        return secretAccessKey;
    }

    /**
     * <p>
     * The session token for the temporary credentials.
     * </p>
     * 
     * @return The session token for the temporary credentials.
     */
    public final String sessionToken() {
        return sessionToken;
    }

    /**
     * <p>
     * The date and time when the temporary credentials expire.
     * </p>
     * 
     * @return The date and time when the temporary credentials expire.
     */
    public final Instant expiration() {
        return expiration;
    }

    /**
     * For responses, this returns true if the service returned a value for the VendedS3Path property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVendedS3Path() {
        return vendedS3Path != null && !(vendedS3Path instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon S3 path for the temporary credentials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVendedS3Path} method.
     * </p>
     * 
     * @return The Amazon S3 path for the temporary credentials.
     */
    public final List<String> vendedS3Path() {
        return vendedS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(expiration());
        hashCode = 31 * hashCode + Objects.hashCode(hasVendedS3Path() ? vendedS3Path() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemporaryGlueTableCredentialsResponse)) {
            return false;
        }
        GetTemporaryGlueTableCredentialsResponse other = (GetTemporaryGlueTableCredentialsResponse) obj;
        return Objects.equals(accessKeyId(), other.accessKeyId()) && Objects.equals(secretAccessKey(), other.secretAccessKey())
                && Objects.equals(sessionToken(), other.sessionToken()) && Objects.equals(expiration(), other.expiration())
                && hasVendedS3Path() == other.hasVendedS3Path() && Objects.equals(vendedS3Path(), other.vendedS3Path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTemporaryGlueTableCredentialsResponse").add("AccessKeyId", accessKeyId())
                .add("SecretAccessKey", secretAccessKey()).add("SessionToken", sessionToken()).add("Expiration", expiration())
                .add("VendedS3Path", hasVendedS3Path() ? vendedS3Path() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "SecretAccessKey":
            return Optional.ofNullable(clazz.cast(secretAccessKey()));
        case "SessionToken":
            return Optional.ofNullable(clazz.cast(sessionToken()));
        case "Expiration":
            return Optional.ofNullable(clazz.cast(expiration()));
        case "VendedS3Path":
            return Optional.ofNullable(clazz.cast(vendedS3Path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTemporaryGlueTableCredentialsResponse, T> g) {
        return obj -> g.apply((GetTemporaryGlueTableCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTemporaryGlueTableCredentialsResponse> {
        /**
         * <p>
         * The access key ID for the temporary credentials.
         * </p>
         * 
         * @param accessKeyId
         *        The access key ID for the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The secret key for the temporary credentials.
         * </p>
         * 
         * @param secretAccessKey
         *        The secret key for the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretAccessKey(String secretAccessKey);

        /**
         * <p>
         * The session token for the temporary credentials.
         * </p>
         * 
         * @param sessionToken
         *        The session token for the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionToken(String sessionToken);

        /**
         * <p>
         * The date and time when the temporary credentials expire.
         * </p>
         * 
         * @param expiration
         *        The date and time when the temporary credentials expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiration(Instant expiration);

        /**
         * <p>
         * The Amazon S3 path for the temporary credentials.
         * </p>
         * 
         * @param vendedS3Path
         *        The Amazon S3 path for the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendedS3Path(Collection<String> vendedS3Path);

        /**
         * <p>
         * The Amazon S3 path for the temporary credentials.
         * </p>
         * 
         * @param vendedS3Path
         *        The Amazon S3 path for the temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendedS3Path(String... vendedS3Path);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private String accessKeyId;

        private String secretAccessKey;

        private String sessionToken;

        private Instant expiration;

        private List<String> vendedS3Path = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemporaryGlueTableCredentialsResponse model) {
            super(model);
            accessKeyId(model.accessKeyId);
            secretAccessKey(model.secretAccessKey);
            sessionToken(model.sessionToken);
            expiration(model.expiration);
            vendedS3Path(model.vendedS3Path);
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final String getSecretAccessKey() {
            return secretAccessKey;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final String getSessionToken() {
            return sessionToken;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final Instant getExpiration() {
            return expiration;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final Collection<String> getVendedS3Path() {
            if (vendedS3Path instanceof SdkAutoConstructList) {
                return null;
            }
            return vendedS3Path;
        }

        public final void setVendedS3Path(Collection<String> vendedS3Path) {
            this.vendedS3Path = PathStringListCopier.copy(vendedS3Path);
        }

        @Override
        public final Builder vendedS3Path(Collection<String> vendedS3Path) {
            this.vendedS3Path = PathStringListCopier.copy(vendedS3Path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vendedS3Path(String... vendedS3Path) {
            vendedS3Path(Arrays.asList(vendedS3Path));
            return this;
        }

        @Override
        public GetTemporaryGlueTableCredentialsResponse build() {
            return new GetTemporaryGlueTableCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
