/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single principal-resource pair that has Lake Formation permissins enforced.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationOptInsInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationOptInsInfo.Builder, LakeFormationOptInsInfo> {
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(LakeFormationOptInsInfo::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(LakeFormationOptInsInfo::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Condition> CONDITION_FIELD = SdkField.<Condition> builder(MarshallingType.SDK_POJO)
            .memberName("Condition").getter(getter(LakeFormationOptInsInfo::condition)).setter(setter(Builder::condition))
            .constructor(Condition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(LakeFormationOptInsInfo::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedBy").getter(getter(LakeFormationOptInsInfo::lastUpdatedBy))
            .setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            PRINCIPAL_FIELD, CONDITION_FIELD, LAST_MODIFIED_FIELD, LAST_UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Resource", RESOURCE_FIELD);
                    put("Principal", PRINCIPAL_FIELD);
                    put("Condition", CONDITION_FIELD);
                    put("LastModified", LAST_MODIFIED_FIELD);
                    put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Resource resource;

    private final DataLakePrincipal principal;

    private final Condition condition;

    private final Instant lastModified;

    private final String lastUpdatedBy;

    private LakeFormationOptInsInfo(BuilderImpl builder) {
        this.resource = builder.resource;
        this.principal = builder.principal;
        this.condition = builder.condition;
        this.lastModified = builder.lastModified;
        this.lastUpdatedBy = builder.lastUpdatedBy;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * Returns the value of the Principal property for this object.
     * 
     * @return The value of the Principal property for this object.
     */
    public final DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
     * </p>
     * 
     * @return A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
     */
    public final Condition condition() {
        return condition;
    }

    /**
     * <p>
     * The last modified date and time of the record.
     * </p>
     * 
     * @return The last modified date and time of the record.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The user who updated the record.
     * </p>
     * 
     * @return The user who updated the record.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationOptInsInfo)) {
            return false;
        }
        LakeFormationOptInsInfo other = (LakeFormationOptInsInfo) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(principal(), other.principal())
                && Objects.equals(condition(), other.condition()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LakeFormationOptInsInfo").add("Resource", resource()).add("Principal", principal())
                .add("Condition", condition()).add("LastModified", lastModified()).add("LastUpdatedBy", lastUpdatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationOptInsInfo, T> g) {
        return obj -> g.apply((LakeFormationOptInsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationOptInsInfo> {
        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * Sets the value of the Principal property for this object.
         *
         * @param principal
         *        The new value for the Principal property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * Sets the value of the Principal property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the
         * need to create one manually via {@link DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         * </p>
         * 
         * @param condition
         *        A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Condition condition);

        /**
         * <p>
         * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link Condition.Builder} avoiding the need to
         * create one manually via {@link Condition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Condition.Builder#build()} is called immediately and its result
         * is passed to {@link #condition(Condition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(Condition)
         */
        default Builder condition(Consumer<Condition.Builder> condition) {
            return condition(Condition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * The last modified date and time of the record.
         * </p>
         * 
         * @param lastModified
         *        The last modified date and time of the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The user who updated the record.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The user who updated the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);
    }

    static final class BuilderImpl implements Builder {
        private Resource resource;

        private DataLakePrincipal principal;

        private Condition condition;

        private Instant lastModified;

        private String lastUpdatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationOptInsInfo model) {
            resource(model.resource);
            principal(model.principal);
            condition(model.condition);
            lastModified(model.lastModified);
            lastUpdatedBy(model.lastUpdatedBy);
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Condition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        @Override
        public LakeFormationOptInsInfo build() {
            return new LakeFormationOptInsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
