/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A PartiQL predicate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowFilter implements SdkPojo, Serializable, ToCopyableBuilder<RowFilter.Builder, RowFilter> {
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilterExpression").getter(getter(RowFilter::filterExpression)).setter(setter(Builder::filterExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()).build();

    private static final SdkField<AllRowsWildcard> ALL_ROWS_WILDCARD_FIELD = SdkField
            .<AllRowsWildcard> builder(MarshallingType.SDK_POJO).memberName("AllRowsWildcard")
            .getter(getter(RowFilter::allRowsWildcard)).setter(setter(Builder::allRowsWildcard))
            .constructor(AllRowsWildcard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllRowsWildcard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_EXPRESSION_FIELD,
            ALL_ROWS_WILDCARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("FilterExpression", FILTER_EXPRESSION_FIELD);
                    put("AllRowsWildcard", ALL_ROWS_WILDCARD_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String filterExpression;

    private final AllRowsWildcard allRowsWildcard;

    private RowFilter(BuilderImpl builder) {
        this.filterExpression = builder.filterExpression;
        this.allRowsWildcard = builder.allRowsWildcard;
    }

    /**
     * <p>
     * A filter expression.
     * </p>
     * 
     * @return A filter expression.
     */
    public final String filterExpression() {
        return filterExpression;
    }

    /**
     * <p>
     * A wildcard for all rows.
     * </p>
     * 
     * @return A wildcard for all rows.
     */
    public final AllRowsWildcard allRowsWildcard() {
        return allRowsWildcard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(allRowsWildcard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowFilter)) {
            return false;
        }
        RowFilter other = (RowFilter) obj;
        return Objects.equals(filterExpression(), other.filterExpression())
                && Objects.equals(allRowsWildcard(), other.allRowsWildcard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowFilter").add("FilterExpression", filterExpression())
                .add("AllRowsWildcard", allRowsWildcard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterExpression":
            return Optional.ofNullable(clazz.cast(filterExpression()));
        case "AllRowsWildcard":
            return Optional.ofNullable(clazz.cast(allRowsWildcard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RowFilter, T> g) {
        return obj -> g.apply((RowFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowFilter> {
        /**
         * <p>
         * A filter expression.
         * </p>
         * 
         * @param filterExpression
         *        A filter expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpression(String filterExpression);

        /**
         * <p>
         * A wildcard for all rows.
         * </p>
         * 
         * @param allRowsWildcard
         *        A wildcard for all rows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allRowsWildcard(AllRowsWildcard allRowsWildcard);

        /**
         * <p>
         * A wildcard for all rows.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllRowsWildcard.Builder} avoiding the
         * need to create one manually via {@link AllRowsWildcard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllRowsWildcard.Builder#build()} is called immediately and its
         * result is passed to {@link #allRowsWildcard(AllRowsWildcard)}.
         * 
         * @param allRowsWildcard
         *        a consumer that will call methods on {@link AllRowsWildcard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allRowsWildcard(AllRowsWildcard)
         */
        default Builder allRowsWildcard(Consumer<AllRowsWildcard.Builder> allRowsWildcard) {
            return allRowsWildcard(AllRowsWildcard.builder().applyMutation(allRowsWildcard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String filterExpression;

        private AllRowsWildcard allRowsWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(RowFilter model) {
            filterExpression(model.filterExpression);
            allRowsWildcard(model.allRowsWildcard);
        }

        public final String getFilterExpression() {
            return filterExpression;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final AllRowsWildcard.Builder getAllRowsWildcard() {
            return allRowsWildcard != null ? allRowsWildcard.toBuilder() : null;
        }

        public final void setAllRowsWildcard(AllRowsWildcard.BuilderImpl allRowsWildcard) {
            this.allRowsWildcard = allRowsWildcard != null ? allRowsWildcard.build() : null;
        }

        @Override
        public final Builder allRowsWildcard(AllRowsWildcard allRowsWildcard) {
            this.allRowsWildcard = allRowsWildcard;
            return this;
        }

        @Override
        public RowFilter build() {
            return new RowFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
