/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTableObjectsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<GetTableObjectsRequest.Builder, GetTableObjectsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(GetTableObjectsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(GetTableObjectsRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(GetTableObjectsRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(GetTableObjectsRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<Instant> QUERY_AS_OF_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("QueryAsOfTime").getter(getter(GetTableObjectsRequest::queryAsOfTime))
            .setter(setter(Builder::queryAsOfTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryAsOfTime").build()).build();

    private static final SdkField<String> PARTITION_PREDICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartitionPredicate").getter(getter(GetTableObjectsRequest::partitionPredicate))
            .setter(setter(Builder::partitionPredicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionPredicate").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetTableObjectsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetTableObjectsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TRANSACTION_ID_FIELD, QUERY_AS_OF_TIME_FIELD, PARTITION_PREDICATE_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String transactionId;

    private final Instant queryAsOfTime;

    private final String partitionPredicate;

    private final Integer maxResults;

    private final String nextToken;

    private GetTableObjectsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.transactionId = builder.transactionId;
        this.queryAsOfTime = builder.queryAsOfTime;
        this.partitionPredicate = builder.partitionPredicate;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The catalog containing the governed table. Defaults to the caller’s account.
     * </p>
     * 
     * @return The catalog containing the governed table. Defaults to the caller’s account.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The database containing the governed table.
     * </p>
     * 
     * @return The database containing the governed table.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The governed table for which to retrieve objects.
     * </p>
     * 
     * @return The governed table for which to retrieve objects.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is
     * returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with
     * <code>QueryAsOfTime</code>.
     * </p>
     * 
     * @return The transaction ID at which to read the governed table contents. If this transaction has aborted, an
     *         error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified
     *         along with <code>QueryAsOfTime</code>.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The time as of when to read the governed table contents. If not set, the most recent transaction commit time is
     * used. Cannot be specified along with <code>TransactionId</code>.
     * </p>
     * 
     * @return The time as of when to read the governed table contents. If not set, the most recent transaction commit
     *         time is used. Cannot be specified along with <code>TransactionId</code>.
     */
    public final Instant queryAsOfTime() {
        return queryAsOfTime;
    }

    /**
     * <p>
     * A predicate to filter the objects returned based on the partition keys defined in the governed table.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=
     * </p>
     * </li>
     * <li>
     * <p>
     * The logical operators supported are: AND
     * </p>
     * </li>
     * <li>
     * <p>
     * The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd
     * HH:mm:ss"), string and decimal.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A predicate to filter the objects returned based on the partition keys defined in the governed table.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The logical operators supported are: AND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or
     *         yyyy-MM-dd HH:mm:ss"), string and decimal.
     *         </p>
     *         </li>
     */
    public final String partitionPredicate() {
        return partitionPredicate;
    }

    /**
     * <p>
     * Specifies how many values to return in a page.
     * </p>
     * 
     * @return Specifies how many values to return in a page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A continuation token if this is not the first call to retrieve these objects.
     * </p>
     * 
     * @return A continuation token if this is not the first call to retrieve these objects.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(queryAsOfTime());
        hashCode = 31 * hashCode + Objects.hashCode(partitionPredicate());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableObjectsRequest)) {
            return false;
        }
        GetTableObjectsRequest other = (GetTableObjectsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(queryAsOfTime(), other.queryAsOfTime())
                && Objects.equals(partitionPredicate(), other.partitionPredicate())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTableObjectsRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("TransactionId", transactionId()).add("QueryAsOfTime", queryAsOfTime())
                .add("PartitionPredicate", partitionPredicate()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "QueryAsOfTime":
            return Optional.ofNullable(clazz.cast(queryAsOfTime()));
        case "PartitionPredicate":
            return Optional.ofNullable(clazz.cast(partitionPredicate()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("QueryAsOfTime", QUERY_AS_OF_TIME_FIELD);
        map.put("PartitionPredicate", PARTITION_PREDICATE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTableObjectsRequest, T> g) {
        return obj -> g.apply((GetTableObjectsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTableObjectsRequest> {
        /**
         * <p>
         * The catalog containing the governed table. Defaults to the caller’s account.
         * </p>
         * 
         * @param catalogId
         *        The catalog containing the governed table. Defaults to the caller’s account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The database containing the governed table.
         * </p>
         * 
         * @param databaseName
         *        The database containing the governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The governed table for which to retrieve objects.
         * </p>
         * 
         * @param tableName
         *        The governed table for which to retrieve objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The transaction ID at which to read the governed table contents. If this transaction has aborted, an error is
         * returned. If not set, defaults to the most recent committed transaction. Cannot be specified along with
         * <code>QueryAsOfTime</code>.
         * </p>
         * 
         * @param transactionId
         *        The transaction ID at which to read the governed table contents. If this transaction has aborted, an
         *        error is returned. If not set, defaults to the most recent committed transaction. Cannot be specified
         *        along with <code>QueryAsOfTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The time as of when to read the governed table contents. If not set, the most recent transaction commit time
         * is used. Cannot be specified along with <code>TransactionId</code>.
         * </p>
         * 
         * @param queryAsOfTime
         *        The time as of when to read the governed table contents. If not set, the most recent transaction
         *        commit time is used. Cannot be specified along with <code>TransactionId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryAsOfTime(Instant queryAsOfTime);

        /**
         * <p>
         * A predicate to filter the objects returned based on the partition keys defined in the governed table.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=
         * </p>
         * </li>
         * <li>
         * <p>
         * The logical operators supported are: AND
         * </p>
         * </li>
         * <li>
         * <p>
         * The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or yyyy-MM-dd
         * HH:mm:ss"), string and decimal.
         * </p>
         * </li>
         * </ul>
         * 
         * @param partitionPredicate
         *        A predicate to filter the objects returned based on the partition keys defined in the governed
         *        table.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The comparison operators supported are: =, &gt;, &lt;, &gt;=, &lt;=
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The logical operators supported are: AND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The data types supported are integer, long, date(yyyy-MM-dd), timestamp(yyyy-MM-dd HH:mm:ssXXX or
         *        yyyy-MM-dd HH:mm:ss"), string and decimal.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionPredicate(String partitionPredicate);

        /**
         * <p>
         * Specifies how many values to return in a page.
         * </p>
         * 
         * @param maxResults
         *        Specifies how many values to return in a page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A continuation token if this is not the first call to retrieve these objects.
         * </p>
         * 
         * @param nextToken
         *        A continuation token if this is not the first call to retrieve these objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private String transactionId;

        private Instant queryAsOfTime;

        private String partitionPredicate;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableObjectsRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            transactionId(model.transactionId);
            queryAsOfTime(model.queryAsOfTime);
            partitionPredicate(model.partitionPredicate);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Instant getQueryAsOfTime() {
            return queryAsOfTime;
        }

        public final void setQueryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
        }

        @Override
        public final Builder queryAsOfTime(Instant queryAsOfTime) {
            this.queryAsOfTime = queryAsOfTime;
            return this;
        }

        public final String getPartitionPredicate() {
            return partitionPredicate;
        }

        public final void setPartitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
        }

        @Override
        public final Builder partitionPredicate(String partitionPredicate) {
            this.partitionPredicate = partitionPredicate;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableObjectsRequest build() {
            return new GetTableObjectsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
