/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the valid range of work unit IDs for querying the execution service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkUnitRange implements SdkPojo, Serializable, ToCopyableBuilder<WorkUnitRange.Builder, WorkUnitRange> {
    private static final SdkField<Long> WORK_UNIT_ID_MAX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkUnitIdMax").getter(getter(WorkUnitRange::workUnitIdMax)).setter(setter(Builder::workUnitIdMax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitIdMax").build()).build();

    private static final SdkField<Long> WORK_UNIT_ID_MIN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkUnitIdMin").getter(getter(WorkUnitRange::workUnitIdMin)).setter(setter(Builder::workUnitIdMin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitIdMin").build()).build();

    private static final SdkField<String> WORK_UNIT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkUnitToken").getter(getter(WorkUnitRange::workUnitToken)).setter(setter(Builder::workUnitToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_UNIT_ID_MAX_FIELD,
            WORK_UNIT_ID_MIN_FIELD, WORK_UNIT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long workUnitIdMax;

    private final Long workUnitIdMin;

    private final String workUnitToken;

    private WorkUnitRange(BuilderImpl builder) {
        this.workUnitIdMax = builder.workUnitIdMax;
        this.workUnitIdMin = builder.workUnitIdMin;
        this.workUnitToken = builder.workUnitToken;
    }

    /**
     * <p>
     * Defines the maximum work unit ID in the range. The maximum value is inclusive.
     * </p>
     * 
     * @return Defines the maximum work unit ID in the range. The maximum value is inclusive.
     */
    public final Long workUnitIdMax() {
        return workUnitIdMax;
    }

    /**
     * <p>
     * Defines the minimum work unit ID in the range.
     * </p>
     * 
     * @return Defines the minimum work unit ID in the range.
     */
    public final Long workUnitIdMin() {
        return workUnitIdMin;
    }

    /**
     * <p>
     * A work token used to query the execution service.
     * </p>
     * 
     * @return A work token used to query the execution service.
     */
    public final String workUnitToken() {
        return workUnitToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(workUnitIdMax());
        hashCode = 31 * hashCode + Objects.hashCode(workUnitIdMin());
        hashCode = 31 * hashCode + Objects.hashCode(workUnitToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkUnitRange)) {
            return false;
        }
        WorkUnitRange other = (WorkUnitRange) obj;
        return Objects.equals(workUnitIdMax(), other.workUnitIdMax()) && Objects.equals(workUnitIdMin(), other.workUnitIdMin())
                && Objects.equals(workUnitToken(), other.workUnitToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkUnitRange").add("WorkUnitIdMax", workUnitIdMax()).add("WorkUnitIdMin", workUnitIdMin())
                .add("WorkUnitToken", workUnitToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkUnitIdMax":
            return Optional.ofNullable(clazz.cast(workUnitIdMax()));
        case "WorkUnitIdMin":
            return Optional.ofNullable(clazz.cast(workUnitIdMin()));
        case "WorkUnitToken":
            return Optional.ofNullable(clazz.cast(workUnitToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkUnitIdMax", WORK_UNIT_ID_MAX_FIELD);
        map.put("WorkUnitIdMin", WORK_UNIT_ID_MIN_FIELD);
        map.put("WorkUnitToken", WORK_UNIT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkUnitRange, T> g) {
        return obj -> g.apply((WorkUnitRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkUnitRange> {
        /**
         * <p>
         * Defines the maximum work unit ID in the range. The maximum value is inclusive.
         * </p>
         * 
         * @param workUnitIdMax
         *        Defines the maximum work unit ID in the range. The maximum value is inclusive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitIdMax(Long workUnitIdMax);

        /**
         * <p>
         * Defines the minimum work unit ID in the range.
         * </p>
         * 
         * @param workUnitIdMin
         *        Defines the minimum work unit ID in the range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitIdMin(Long workUnitIdMin);

        /**
         * <p>
         * A work token used to query the execution service.
         * </p>
         * 
         * @param workUnitToken
         *        A work token used to query the execution service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitToken(String workUnitToken);
    }

    static final class BuilderImpl implements Builder {
        private Long workUnitIdMax;

        private Long workUnitIdMin;

        private String workUnitToken;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkUnitRange model) {
            workUnitIdMax(model.workUnitIdMax);
            workUnitIdMin(model.workUnitIdMin);
            workUnitToken(model.workUnitToken);
        }

        public final Long getWorkUnitIdMax() {
            return workUnitIdMax;
        }

        public final void setWorkUnitIdMax(Long workUnitIdMax) {
            this.workUnitIdMax = workUnitIdMax;
        }

        @Override
        public final Builder workUnitIdMax(Long workUnitIdMax) {
            this.workUnitIdMax = workUnitIdMax;
            return this;
        }

        public final Long getWorkUnitIdMin() {
            return workUnitIdMin;
        }

        public final void setWorkUnitIdMin(Long workUnitIdMin) {
            this.workUnitIdMin = workUnitIdMin;
        }

        @Override
        public final Builder workUnitIdMin(Long workUnitIdMin) {
            this.workUnitIdMin = workUnitIdMin;
            return this;
        }

        public final String getWorkUnitToken() {
            return workUnitToken;
        }

        public final void setWorkUnitToken(String workUnitToken) {
            this.workUnitToken = workUnitToken;
        }

        @Override
        public final Builder workUnitToken(String workUnitToken) {
            this.workUnitToken = workUnitToken;
            return this;
        }

        @Override
        public WorkUnitRange build() {
            return new WorkUnitRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
