/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartQueryPlanningRequest extends LakeFormationRequest implements
        ToCopyableBuilder<StartQueryPlanningRequest.Builder, StartQueryPlanningRequest> {
    private static final SdkField<QueryPlanningContext> QUERY_PLANNING_CONTEXT_FIELD = SdkField
            .<QueryPlanningContext> builder(MarshallingType.SDK_POJO).memberName("QueryPlanningContext")
            .getter(getter(StartQueryPlanningRequest::queryPlanningContext)).setter(setter(Builder::queryPlanningContext))
            .constructor(QueryPlanningContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryPlanningContext").build())
            .build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(StartQueryPlanningRequest::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_PLANNING_CONTEXT_FIELD,
            QUERY_STRING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final QueryPlanningContext queryPlanningContext;

    private final String queryString;

    private StartQueryPlanningRequest(BuilderImpl builder) {
        super(builder);
        this.queryPlanningContext = builder.queryPlanningContext;
        this.queryString = builder.queryString;
    }

    /**
     * <p>
     * A structure containing information about the query plan.
     * </p>
     * 
     * @return A structure containing information about the query plan.
     */
    public final QueryPlanningContext queryPlanningContext() {
        return queryPlanningContext;
    }

    /**
     * <p>
     * A PartiQL query statement used as an input to the planner service.
     * </p>
     * 
     * @return A PartiQL query statement used as an input to the planner service.
     */
    public final String queryString() {
        return queryString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryPlanningContext());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryPlanningRequest)) {
            return false;
        }
        StartQueryPlanningRequest other = (StartQueryPlanningRequest) obj;
        return Objects.equals(queryPlanningContext(), other.queryPlanningContext())
                && Objects.equals(queryString(), other.queryString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartQueryPlanningRequest").add("QueryPlanningContext", queryPlanningContext())
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryPlanningContext":
            return Optional.ofNullable(clazz.cast(queryPlanningContext()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryPlanningContext", QUERY_PLANNING_CONTEXT_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartQueryPlanningRequest, T> g) {
        return obj -> g.apply((StartQueryPlanningRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartQueryPlanningRequest> {
        /**
         * <p>
         * A structure containing information about the query plan.
         * </p>
         * 
         * @param queryPlanningContext
         *        A structure containing information about the query plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryPlanningContext(QueryPlanningContext queryPlanningContext);

        /**
         * <p>
         * A structure containing information about the query plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryPlanningContext.Builder} avoiding
         * the need to create one manually via {@link QueryPlanningContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryPlanningContext.Builder#build()} is called immediately and
         * its result is passed to {@link #queryPlanningContext(QueryPlanningContext)}.
         * 
         * @param queryPlanningContext
         *        a consumer that will call methods on {@link QueryPlanningContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryPlanningContext(QueryPlanningContext)
         */
        default Builder queryPlanningContext(Consumer<QueryPlanningContext.Builder> queryPlanningContext) {
            return queryPlanningContext(QueryPlanningContext.builder().applyMutation(queryPlanningContext).build());
        }

        /**
         * <p>
         * A PartiQL query statement used as an input to the planner service.
         * </p>
         * 
         * @param queryString
         *        A PartiQL query statement used as an input to the planner service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private QueryPlanningContext queryPlanningContext;

        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryPlanningRequest model) {
            super(model);
            queryPlanningContext(model.queryPlanningContext);
            queryString(model.queryString);
        }

        public final QueryPlanningContext.Builder getQueryPlanningContext() {
            return queryPlanningContext != null ? queryPlanningContext.toBuilder() : null;
        }

        public final void setQueryPlanningContext(QueryPlanningContext.BuilderImpl queryPlanningContext) {
            this.queryPlanningContext = queryPlanningContext != null ? queryPlanningContext.build() : null;
        }

        @Override
        public final Builder queryPlanningContext(QueryPlanningContext queryPlanningContext) {
            this.queryPlanningContext = queryPlanningContext;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartQueryPlanningRequest build() {
            return new StartQueryPlanningRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
