/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTransactionRequest extends LakeFormationRequest implements
        ToCopyableBuilder<StartTransactionRequest.Builder, StartTransactionRequest> {
    private static final SdkField<String> TRANSACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionType").getter(getter(StartTransactionRequest::transactionTypeAsString))
            .setter(setter(Builder::transactionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transactionType;

    private StartTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.transactionType = builder.transactionType;
    }

    /**
     * <p>
     * Indicates whether this transaction should be read only or read and write. Writes made using a read-only
     * transaction ID will be rejected. Read-only transactions do not need to be committed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionType}
     * will return {@link TransactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionTypeAsString}.
     * </p>
     * 
     * @return Indicates whether this transaction should be read only or read and write. Writes made using a read-only
     *         transaction ID will be rejected. Read-only transactions do not need to be committed.
     * @see TransactionType
     */
    public final TransactionType transactionType() {
        return TransactionType.fromValue(transactionType);
    }

    /**
     * <p>
     * Indicates whether this transaction should be read only or read and write. Writes made using a read-only
     * transaction ID will be rejected. Read-only transactions do not need to be committed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionType}
     * will return {@link TransactionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionTypeAsString}.
     * </p>
     * 
     * @return Indicates whether this transaction should be read only or read and write. Writes made using a read-only
     *         transaction ID will be rejected. Read-only transactions do not need to be committed.
     * @see TransactionType
     */
    public final String transactionTypeAsString() {
        return transactionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTransactionRequest)) {
            return false;
        }
        StartTransactionRequest other = (StartTransactionRequest) obj;
        return Objects.equals(transactionTypeAsString(), other.transactionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTransactionRequest").add("TransactionType", transactionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactionType":
            return Optional.ofNullable(clazz.cast(transactionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransactionType", TRANSACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTransactionRequest, T> g) {
        return obj -> g.apply((StartTransactionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTransactionRequest> {
        /**
         * <p>
         * Indicates whether this transaction should be read only or read and write. Writes made using a read-only
         * transaction ID will be rejected. Read-only transactions do not need to be committed.
         * </p>
         * 
         * @param transactionType
         *        Indicates whether this transaction should be read only or read and write. Writes made using a
         *        read-only transaction ID will be rejected. Read-only transactions do not need to be committed.
         * @see TransactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionType
         */
        Builder transactionType(String transactionType);

        /**
         * <p>
         * Indicates whether this transaction should be read only or read and write. Writes made using a read-only
         * transaction ID will be rejected. Read-only transactions do not need to be committed.
         * </p>
         * 
         * @param transactionType
         *        Indicates whether this transaction should be read only or read and write. Writes made using a
         *        read-only transaction ID will be rejected. Read-only transactions do not need to be committed.
         * @see TransactionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionType
         */
        Builder transactionType(TransactionType transactionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String transactionType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTransactionRequest model) {
            super(model);
            transactionType(model.transactionType);
        }

        public final String getTransactionType() {
            return transactionType;
        }

        public final void setTransactionType(String transactionType) {
            this.transactionType = transactionType;
        }

        @Override
        public final Builder transactionType(String transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        @Override
        public final Builder transactionType(TransactionType transactionType) {
            this.transactionType(transactionType == null ? null : transactionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTransactionRequest build() {
            return new StartTransactionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
