/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TransactionDescription.Builder, TransactionDescription> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(TransactionDescription::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<String> TRANSACTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionStatus").getter(getter(TransactionDescription::transactionStatusAsString))
            .setter(setter(Builder::transactionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionStatus").build()).build();

    private static final SdkField<Instant> TRANSACTION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TransactionStartTime").getter(getter(TransactionDescription::transactionStartTime))
            .setter(setter(Builder::transactionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionStartTime").build())
            .build();

    private static final SdkField<Instant> TRANSACTION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TransactionEndTime").getter(getter(TransactionDescription::transactionEndTime))
            .setter(setter(Builder::transactionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionEndTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD,
            TRANSACTION_STATUS_FIELD, TRANSACTION_START_TIME_FIELD, TRANSACTION_END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String transactionId;

    private final String transactionStatus;

    private final Instant transactionStartTime;

    private final Instant transactionEndTime;

    private TransactionDescription(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.transactionStatus = builder.transactionStatus;
        this.transactionStartTime = builder.transactionStartTime;
        this.transactionEndTime = builder.transactionEndTime;
    }

    /**
     * <p>
     * The ID of the transaction.
     * </p>
     * 
     * @return The ID of the transaction.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * A status of ACTIVE, COMMITTED, or ABORTED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionStatus}
     * will return {@link TransactionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionStatusAsString}.
     * </p>
     * 
     * @return A status of ACTIVE, COMMITTED, or ABORTED.
     * @see TransactionStatus
     */
    public final TransactionStatus transactionStatus() {
        return TransactionStatus.fromValue(transactionStatus);
    }

    /**
     * <p>
     * A status of ACTIVE, COMMITTED, or ABORTED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #transactionStatus}
     * will return {@link TransactionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #transactionStatusAsString}.
     * </p>
     * 
     * @return A status of ACTIVE, COMMITTED, or ABORTED.
     * @see TransactionStatus
     */
    public final String transactionStatusAsString() {
        return transactionStatus;
    }

    /**
     * <p>
     * The time when the transaction started.
     * </p>
     * 
     * @return The time when the transaction started.
     */
    public final Instant transactionStartTime() {
        return transactionStartTime;
    }

    /**
     * <p>
     * The time when the transaction committed or aborted, if it is not currently active.
     * </p>
     * 
     * @return The time when the transaction committed or aborted, if it is not currently active.
     */
    public final Instant transactionEndTime() {
        return transactionEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transactionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(transactionEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionDescription)) {
            return false;
        }
        TransactionDescription other = (TransactionDescription) obj;
        return Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(transactionStatusAsString(), other.transactionStatusAsString())
                && Objects.equals(transactionStartTime(), other.transactionStartTime())
                && Objects.equals(transactionEndTime(), other.transactionEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransactionDescription").add("TransactionId", transactionId())
                .add("TransactionStatus", transactionStatusAsString()).add("TransactionStartTime", transactionStartTime())
                .add("TransactionEndTime", transactionEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "TransactionStatus":
            return Optional.ofNullable(clazz.cast(transactionStatusAsString()));
        case "TransactionStartTime":
            return Optional.ofNullable(clazz.cast(transactionStartTime()));
        case "TransactionEndTime":
            return Optional.ofNullable(clazz.cast(transactionEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("TransactionStatus", TRANSACTION_STATUS_FIELD);
        map.put("TransactionStartTime", TRANSACTION_START_TIME_FIELD);
        map.put("TransactionEndTime", TRANSACTION_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransactionDescription, T> g) {
        return obj -> g.apply((TransactionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactionDescription> {
        /**
         * <p>
         * The ID of the transaction.
         * </p>
         * 
         * @param transactionId
         *        The ID of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * A status of ACTIVE, COMMITTED, or ABORTED.
         * </p>
         * 
         * @param transactionStatus
         *        A status of ACTIVE, COMMITTED, or ABORTED.
         * @see TransactionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionStatus
         */
        Builder transactionStatus(String transactionStatus);

        /**
         * <p>
         * A status of ACTIVE, COMMITTED, or ABORTED.
         * </p>
         * 
         * @param transactionStatus
         *        A status of ACTIVE, COMMITTED, or ABORTED.
         * @see TransactionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TransactionStatus
         */
        Builder transactionStatus(TransactionStatus transactionStatus);

        /**
         * <p>
         * The time when the transaction started.
         * </p>
         * 
         * @param transactionStartTime
         *        The time when the transaction started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionStartTime(Instant transactionStartTime);

        /**
         * <p>
         * The time when the transaction committed or aborted, if it is not currently active.
         * </p>
         * 
         * @param transactionEndTime
         *        The time when the transaction committed or aborted, if it is not currently active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionEndTime(Instant transactionEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String transactionId;

        private String transactionStatus;

        private Instant transactionStartTime;

        private Instant transactionEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionDescription model) {
            transactionId(model.transactionId);
            transactionStatus(model.transactionStatus);
            transactionStartTime(model.transactionStartTime);
            transactionEndTime(model.transactionEndTime);
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getTransactionStatus() {
            return transactionStatus;
        }

        public final void setTransactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        public final Builder transactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
            return this;
        }

        @Override
        public final Builder transactionStatus(TransactionStatus transactionStatus) {
            this.transactionStatus(transactionStatus == null ? null : transactionStatus.toString());
            return this;
        }

        public final Instant getTransactionStartTime() {
            return transactionStartTime;
        }

        public final void setTransactionStartTime(Instant transactionStartTime) {
            this.transactionStartTime = transactionStartTime;
        }

        @Override
        public final Builder transactionStartTime(Instant transactionStartTime) {
            this.transactionStartTime = transactionStartTime;
            return this;
        }

        public final Instant getTransactionEndTime() {
            return transactionEndTime;
        }

        public final void setTransactionEndTime(Instant transactionEndTime) {
            this.transactionEndTime = transactionEndTime;
        }

        @Override
        public final Builder transactionEndTime(Instant transactionEndTime) {
            this.transactionEndTime = transactionEndTime;
            return this;
        }

        @Override
        public TransactionDescription build() {
            return new TransactionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
