/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLakeFormationOptInRequest extends LakeFormationRequest implements
        ToCopyableBuilder<CreateLakeFormationOptInRequest.Builder, CreateLakeFormationOptInRequest> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(CreateLakeFormationOptInRequest::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(CreateLakeFormationOptInRequest::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            RESOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataLakePrincipal principal;

    private final Resource resource;

    private CreateLakeFormationOptInRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.resource = builder.resource;
    }

    /**
     * Returns the value of the Principal property for this object.
     * 
     * @return The value of the Principal property for this object.
     */
    public final DataLakePrincipal principal() {
        return principal;
    }

    /**
     * Returns the value of the Resource property for this object.
     * 
     * @return The value of the Resource property for this object.
     */
    public final Resource resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLakeFormationOptInRequest)) {
            return false;
        }
        CreateLakeFormationOptInRequest other = (CreateLakeFormationOptInRequest) obj;
        return Objects.equals(principal(), other.principal()) && Objects.equals(resource(), other.resource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLakeFormationOptInRequest").add("Principal", principal()).add("Resource", resource())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLakeFormationOptInRequest, T> g) {
        return obj -> g.apply((CreateLakeFormationOptInRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLakeFormationOptInRequest> {
        /**
         * Sets the value of the Principal property for this object.
         *
         * @param principal
         *        The new value for the Principal property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * Sets the value of the Principal property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the
         * need to create one manually via {@link DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * Sets the value of the Resource property for this object.
         *
         * @param resource
         *        The new value for the Resource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * Sets the value of the Resource property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private DataLakePrincipal principal;

        private Resource resource;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLakeFormationOptInRequest model) {
            super(model);
            principal(model.principal);
            resource(model.resource);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLakeFormationOptInRequest build() {
            return new CreateLakeFormationOptInRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
