/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for a data cells filter resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCellsFilterResource implements SdkPojo, Serializable,
        ToCopyableBuilder<DataCellsFilterResource.Builder, DataCellsFilterResource> {
    private static final SdkField<String> TABLE_CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableCatalogId").getter(getter(DataCellsFilterResource::tableCatalogId))
            .setter(setter(Builder::tableCatalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DataCellsFilterResource::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DataCellsFilterResource::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataCellsFilterResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tableCatalogId;

    private final String databaseName;

    private final String tableName;

    private final String name;

    private DataCellsFilterResource(BuilderImpl builder) {
        this.tableCatalogId = builder.tableCatalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the catalog to which the table belongs.
     * </p>
     * 
     * @return The ID of the catalog to which the table belongs.
     */
    public final String tableCatalogId() {
        return tableCatalogId;
    }

    /**
     * <p>
     * A database in the Glue Data Catalog.
     * </p>
     * 
     * @return A database in the Glue Data Catalog.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name of the data cells filter.
     * </p>
     * 
     * @return The name of the data cells filter.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableCatalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCellsFilterResource)) {
            return false;
        }
        DataCellsFilterResource other = (DataCellsFilterResource) obj;
        return Objects.equals(tableCatalogId(), other.tableCatalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCellsFilterResource").add("TableCatalogId", tableCatalogId())
                .add("DatabaseName", databaseName()).add("TableName", tableName()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableCatalogId":
            return Optional.ofNullable(clazz.cast(tableCatalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TableCatalogId", TABLE_CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataCellsFilterResource, T> g) {
        return obj -> g.apply((DataCellsFilterResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCellsFilterResource> {
        /**
         * <p>
         * The ID of the catalog to which the table belongs.
         * </p>
         * 
         * @param tableCatalogId
         *        The ID of the catalog to which the table belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableCatalogId(String tableCatalogId);

        /**
         * <p>
         * A database in the Glue Data Catalog.
         * </p>
         * 
         * @param databaseName
         *        A database in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name of the data cells filter.
         * </p>
         * 
         * @param name
         *        The name of the data cells filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String tableCatalogId;

        private String databaseName;

        private String tableName;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCellsFilterResource model) {
            tableCatalogId(model.tableCatalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            name(model.name);
        }

        public final String getTableCatalogId() {
            return tableCatalogId;
        }

        public final void setTableCatalogId(String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
        }

        @Override
        public final Builder tableCatalogId(String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public DataCellsFilterResource build() {
            return new DataCellsFilterResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
