/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The permissions granted or revoked on a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrincipalResourcePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<PrincipalResourcePermissions.Builder, PrincipalResourcePermissions> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(PrincipalResourcePermissions::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(PrincipalResourcePermissions::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<Condition> CONDITION_FIELD = SdkField.<Condition> builder(MarshallingType.SDK_POJO)
            .memberName("Condition").getter(getter(PrincipalResourcePermissions::condition)).setter(setter(Builder::condition))
            .constructor(Condition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(PrincipalResourcePermissions::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PermissionsWithGrantOption")
            .getter(getter(PrincipalResourcePermissions::permissionsWithGrantOptionAsStrings))
            .setter(setter(Builder::permissionsWithGrantOptionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DetailsMap> ADDITIONAL_DETAILS_FIELD = SdkField.<DetailsMap> builder(MarshallingType.SDK_POJO)
            .memberName("AdditionalDetails").getter(getter(PrincipalResourcePermissions::additionalDetails))
            .setter(setter(Builder::additionalDetails)).constructor(DetailsMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetails").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(PrincipalResourcePermissions::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdatedBy").getter(getter(PrincipalResourcePermissions::lastUpdatedBy))
            .setter(setter(Builder::lastUpdatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            RESOURCE_FIELD, CONDITION_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD, ADDITIONAL_DETAILS_FIELD,
            LAST_UPDATED_FIELD, LAST_UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DataLakePrincipal principal;

    private final Resource resource;

    private final Condition condition;

    private final List<String> permissions;

    private final List<String> permissionsWithGrantOption;

    private final DetailsMap additionalDetails;

    private final Instant lastUpdated;

    private final String lastUpdatedBy;

    private PrincipalResourcePermissions(BuilderImpl builder) {
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.condition = builder.condition;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
        this.additionalDetails = builder.additionalDetails;
        this.lastUpdated = builder.lastUpdated;
        this.lastUpdatedBy = builder.lastUpdatedBy;
    }

    /**
     * <p>
     * The Data Lake principal to be granted or revoked permissions.
     * </p>
     * 
     * @return The Data Lake principal to be granted or revoked permissions.
     */
    public final DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * The resource where permissions are to be granted or revoked.
     * </p>
     * 
     * @return The resource where permissions are to be granted or revoked.
     */
    public final Resource resource() {
        return resource;
    }

    /**
     * <p>
     * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
     * </p>
     * 
     * @return A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
     */
    public final Condition condition() {
        return condition;
    }

    /**
     * <p>
     * The permissions to be granted or revoked on the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions to be granted or revoked on the resource.
     */
    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions to be granted or revoked on the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return The permissions to be granted or revoked on the resource.
     */
    public final List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionsWithGrantOption} method.
     * </p>
     * 
     * @return Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     */
    public final List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(permissionsWithGrantOption);
    }

    /**
     * For responses, this returns true if the service returned a value for the PermissionsWithGrantOption property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPermissionsWithGrantOption() {
        return permissionsWithGrantOption != null && !(permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionsWithGrantOption} method.
     * </p>
     * 
     * @return Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     */
    public final List<String> permissionsWithGrantOptionAsStrings() {
        return permissionsWithGrantOption;
    }

    /**
     * <p>
     * This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
     * Currently returns only as a RAM resource share ARN.
     * </p>
     * 
     * @return This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
     *         Currently returns only as a RAM resource share ARN.
     */
    public final DetailsMap additionalDetails() {
        return additionalDetails;
    }

    /**
     * <p>
     * The date and time when the resource was last updated.
     * </p>
     * 
     * @return The date and time when the resource was last updated.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The user who updated the record.
     * </p>
     * 
     * @return The user who updated the record.
     */
    public final String lastUpdatedBy() {
        return lastUpdatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissionsAsStrings() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPermissionsWithGrantOption() ? permissionsWithGrantOptionAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(additionalDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalResourcePermissions)) {
            return false;
        }
        PrincipalResourcePermissions other = (PrincipalResourcePermissions) obj;
        return Objects.equals(principal(), other.principal()) && Objects.equals(resource(), other.resource())
                && Objects.equals(condition(), other.condition()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && hasPermissionsWithGrantOption() == other.hasPermissionsWithGrantOption()
                && Objects.equals(permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings())
                && Objects.equals(additionalDetails(), other.additionalDetails())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(lastUpdatedBy(), other.lastUpdatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PrincipalResourcePermissions")
                .add("Principal", principal())
                .add("Resource", resource())
                .add("Condition", condition())
                .add("Permissions", hasPermissions() ? permissionsAsStrings() : null)
                .add("PermissionsWithGrantOption", hasPermissionsWithGrantOption() ? permissionsWithGrantOptionAsStrings() : null)
                .add("AdditionalDetails", additionalDetails()).add("LastUpdated", lastUpdated())
                .add("LastUpdatedBy", lastUpdatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "PermissionsWithGrantOption":
            return Optional.ofNullable(clazz.cast(permissionsWithGrantOptionAsStrings()));
        case "AdditionalDetails":
            return Optional.ofNullable(clazz.cast(additionalDetails()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "LastUpdatedBy":
            return Optional.ofNullable(clazz.cast(lastUpdatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("PermissionsWithGrantOption", PERMISSIONS_WITH_GRANT_OPTION_FIELD);
        map.put("AdditionalDetails", ADDITIONAL_DETAILS_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrincipalResourcePermissions, T> g) {
        return obj -> g.apply((PrincipalResourcePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrincipalResourcePermissions> {
        /**
         * <p>
         * The Data Lake principal to be granted or revoked permissions.
         * </p>
         * 
         * @param principal
         *        The Data Lake principal to be granted or revoked permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * <p>
         * The Data Lake principal to be granted or revoked permissions.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the
         * need to create one manually via {@link DataLakePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The resource where permissions are to be granted or revoked.
         * </p>
         * 
         * @param resource
         *        The resource where permissions are to be granted or revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The resource where permissions are to be granted or revoked.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         * </p>
         * 
         * @param condition
         *        A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Condition condition);

        /**
         * <p>
         * A Lake Formation condition, which applies to permissions and opt-ins that contain an expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link Condition.Builder} avoiding the need to
         * create one manually via {@link Condition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Condition.Builder#build()} is called immediately and its result
         * is passed to {@link #condition(Condition)}.
         * 
         * @param condition
         *        a consumer that will call methods on {@link Condition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #condition(Condition)
         */
        default Builder condition(Consumer<Condition.Builder> condition) {
            return condition(Condition.builder().applyMutation(condition).build());
        }

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption);

        /**
         * <p>
         * This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
         * Currently returns only as a RAM resource share ARN.
         * </p>
         * 
         * @param additionalDetails
         *        This attribute can be used to return any additional details of
         *        <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM resource share ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetails(DetailsMap additionalDetails);

        /**
         * <p>
         * This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
         * Currently returns only as a RAM resource share ARN.
         * </p>
         * This is a convenience method that creates an instance of the {@link DetailsMap.Builder} avoiding the need to
         * create one manually via {@link DetailsMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetailsMap.Builder#build()} is called immediately and its result
         * is passed to {@link #additionalDetails(DetailsMap)}.
         * 
         * @param additionalDetails
         *        a consumer that will call methods on {@link DetailsMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalDetails(DetailsMap)
         */
        default Builder additionalDetails(Consumer<DetailsMap.Builder> additionalDetails) {
            return additionalDetails(DetailsMap.builder().applyMutation(additionalDetails).build());
        }

        /**
         * <p>
         * The date and time when the resource was last updated.
         * </p>
         * 
         * @param lastUpdated
         *        The date and time when the resource was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The user who updated the record.
         * </p>
         * 
         * @param lastUpdatedBy
         *        The user who updated the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBy(String lastUpdatedBy);
    }

    static final class BuilderImpl implements Builder {
        private DataLakePrincipal principal;

        private Resource resource;

        private Condition condition;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();

        private DetailsMap additionalDetails;

        private Instant lastUpdated;

        private String lastUpdatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalResourcePermissions model) {
            principal(model.principal);
            resource(model.resource);
            condition(model.condition);
            permissionsWithStrings(model.permissions);
            permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
            additionalDetails(model.additionalDetails);
            lastUpdated(model.lastUpdated);
            lastUpdatedBy(model.lastUpdatedBy);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Condition.Builder getCondition() {
            return condition != null ? condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            if (permissionsWithGrantOption instanceof SdkAutoConstructList) {
                return null;
            }
            return permissionsWithGrantOption;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption) {
            permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption) {
            permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        public final DetailsMap.Builder getAdditionalDetails() {
            return additionalDetails != null ? additionalDetails.toBuilder() : null;
        }

        public final void setAdditionalDetails(DetailsMap.BuilderImpl additionalDetails) {
            this.additionalDetails = additionalDetails != null ? additionalDetails.build() : null;
        }

        @Override
        public final Builder additionalDetails(DetailsMap additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getLastUpdatedBy() {
            return lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        @Override
        public PrincipalResourcePermissions build() {
            return new PrincipalResourcePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
