/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure for a table with columns object. This object is only used when granting a SELECT permission.
 * </p>
 * <p>
 * This object must take a value for at least one of <code>ColumnsNames</code>, <code>ColumnsIndexes</code>, or
 * <code>ColumnsWildcard</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableWithColumnsResource implements SdkPojo, Serializable,
        ToCopyableBuilder<TableWithColumnsResource.Builder, TableWithColumnsResource> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(TableWithColumnsResource::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(TableWithColumnsResource::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TableWithColumnsResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnNames")
            .getter(getter(TableWithColumnsResource::columnNames))
            .setter(setter(Builder::columnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ColumnWildcard> COLUMN_WILDCARD_FIELD = SdkField
            .<ColumnWildcard> builder(MarshallingType.SDK_POJO).memberName("ColumnWildcard")
            .getter(getter(TableWithColumnsResource::columnWildcard)).setter(setter(Builder::columnWildcard))
            .constructor(ColumnWildcard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnWildcard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, NAME_FIELD, COLUMN_NAMES_FIELD, COLUMN_WILDCARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String catalogId;

    private final String databaseName;

    private final String name;

    private final List<String> columnNames;

    private final ColumnWildcard columnWildcard;

    private TableWithColumnsResource(BuilderImpl builder) {
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.name = builder.name;
        this.columnNames = builder.columnNames;
        this.columnWildcard = builder.columnWildcard;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, it is the account ID of the caller.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, it is the account ID of the caller.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set of
     * associated table definitions organized into a logical group. You can Grant and Revoke database privileges to a
     * principal.
     * </p>
     * 
     * @return The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a
     *         set of associated table definitions organized into a logical group. You can Grant and Revoke database
     *         privileges to a principal.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the table resource. A table is a metadata definition that represents your data. You can Grant and
     * Revoke table privileges to a principal.
     * </p>
     * 
     * @return The name of the table resource. A table is a metadata definition that represents your data. You can Grant
     *         and Revoke table privileges to a principal.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNames() {
        return columnNames != null && !(columnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of column names for the table. At least one of <code>ColumnNames</code> or <code>ColumnWildcard</code>
     * is required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNames} method.
     * </p>
     * 
     * @return The list of column names for the table. At least one of <code>ColumnNames</code> or
     *         <code>ColumnWildcard</code> is required.
     */
    public final List<String> columnNames() {
        return columnNames;
    }

    /**
     * <p>
     * A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or
     * <code>ColumnWildcard</code> is required.
     * </p>
     * 
     * @return A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or
     *         <code>ColumnWildcard</code> is required.
     */
    public final ColumnWildcard columnWildcard() {
        return columnWildcard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNames() ? columnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(columnWildcard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableWithColumnsResource)) {
            return false;
        }
        TableWithColumnsResource other = (TableWithColumnsResource) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(name(), other.name()) && hasColumnNames() == other.hasColumnNames()
                && Objects.equals(columnNames(), other.columnNames()) && Objects.equals(columnWildcard(), other.columnWildcard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableWithColumnsResource").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("Name", name()).add("ColumnNames", hasColumnNames() ? columnNames() : null)
                .add("ColumnWildcard", columnWildcard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ColumnNames":
            return Optional.ofNullable(clazz.cast(columnNames()));
        case "ColumnWildcard":
            return Optional.ofNullable(clazz.cast(columnWildcard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ColumnNames", COLUMN_NAMES_FIELD);
        map.put("ColumnWildcard", COLUMN_WILDCARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableWithColumnsResource, T> g) {
        return obj -> g.apply((TableWithColumnsResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableWithColumnsResource> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, it is the account ID of the caller.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, it is the account ID of the caller.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The name of the database for the table with columns resource. Unique to the Data Catalog. A database is a set
         * of associated table definitions organized into a logical group. You can Grant and Revoke database privileges
         * to a principal.
         * </p>
         * 
         * @param databaseName
         *        The name of the database for the table with columns resource. Unique to the Data Catalog. A database
         *        is a set of associated table definitions organized into a logical group. You can Grant and Revoke
         *        database privileges to a principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the table resource. A table is a metadata definition that represents your data. You can Grant and
         * Revoke table privileges to a principal.
         * </p>
         * 
         * @param name
         *        The name of the table resource. A table is a metadata definition that represents your data. You can
         *        Grant and Revoke table privileges to a principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The list of column names for the table. At least one of <code>ColumnNames</code> or
         * <code>ColumnWildcard</code> is required.
         * </p>
         * 
         * @param columnNames
         *        The list of column names for the table. At least one of <code>ColumnNames</code> or
         *        <code>ColumnWildcard</code> is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(Collection<String> columnNames);

        /**
         * <p>
         * The list of column names for the table. At least one of <code>ColumnNames</code> or
         * <code>ColumnWildcard</code> is required.
         * </p>
         * 
         * @param columnNames
         *        The list of column names for the table. At least one of <code>ColumnNames</code> or
         *        <code>ColumnWildcard</code> is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(String... columnNames);

        /**
         * <p>
         * A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or
         * <code>ColumnWildcard</code> is required.
         * </p>
         * 
         * @param columnWildcard
         *        A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code>
         *        or <code>ColumnWildcard</code> is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnWildcard(ColumnWildcard columnWildcard);

        /**
         * <p>
         * A wildcard specified by a <code>ColumnWildcard</code> object. At least one of <code>ColumnNames</code> or
         * <code>ColumnWildcard</code> is required.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnWildcard.Builder} avoiding the need
         * to create one manually via {@link ColumnWildcard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnWildcard.Builder#build()} is called immediately and its
         * result is passed to {@link #columnWildcard(ColumnWildcard)}.
         * 
         * @param columnWildcard
         *        a consumer that will call methods on {@link ColumnWildcard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnWildcard(ColumnWildcard)
         */
        default Builder columnWildcard(Consumer<ColumnWildcard.Builder> columnWildcard) {
            return columnWildcard(ColumnWildcard.builder().applyMutation(columnWildcard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String name;

        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();

        private ColumnWildcard columnWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(TableWithColumnsResource model) {
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            name(model.name);
            columnNames(model.columnNames);
            columnWildcard(model.columnWildcard);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getColumnNames() {
            if (columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        @Override
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(String... columnNames) {
            columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final ColumnWildcard.Builder getColumnWildcard() {
            return columnWildcard != null ? columnWildcard.toBuilder() : null;
        }

        public final void setColumnWildcard(ColumnWildcard.BuilderImpl columnWildcard) {
            this.columnWildcard = columnWildcard != null ? columnWildcard.build() : null;
        }

        @Override
        public final Builder columnWildcard(ColumnWildcard columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        @Override
        public TableWithColumnsResource build() {
            return new TableWithColumnsResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
