/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipalListCopier;
import software.amazon.awssdk.services.lakeformation.model.ExternalFilteringConfiguration;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLakeFormationIdentityCenterConfigurationRequest
extends LakeFormationRequest
implements ToCopyableBuilder<Builder, CreateLakeFormationIdentityCenterConfigurationRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(CreateLakeFormationIdentityCenterConfigurationRequest.getter(CreateLakeFormationIdentityCenterConfigurationRequest::catalogId)).setter(CreateLakeFormationIdentityCenterConfigurationRequest.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(CreateLakeFormationIdentityCenterConfigurationRequest.getter(CreateLakeFormationIdentityCenterConfigurationRequest::instanceArn)).setter(CreateLakeFormationIdentityCenterConfigurationRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<ExternalFilteringConfiguration> EXTERNAL_FILTERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExternalFiltering").getter(CreateLakeFormationIdentityCenterConfigurationRequest.getter(CreateLakeFormationIdentityCenterConfigurationRequest::externalFiltering)).setter(CreateLakeFormationIdentityCenterConfigurationRequest.setter(Builder::externalFiltering)).constructor(ExternalFilteringConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalFiltering").build()}).build();
    private static final SdkField<List<DataLakePrincipal>> SHARE_RECIPIENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ShareRecipients").getter(CreateLakeFormationIdentityCenterConfigurationRequest.getter(CreateLakeFormationIdentityCenterConfigurationRequest::shareRecipients)).setter(CreateLakeFormationIdentityCenterConfigurationRequest.setter(Builder::shareRecipients)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareRecipients").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataLakePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, INSTANCE_ARN_FIELD, EXTERNAL_FILTERING_FIELD, SHARE_RECIPIENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLakeFormationIdentityCenterConfigurationRequest.memberNameToFieldInitializer();
    private final String catalogId;
    private final String instanceArn;
    private final ExternalFilteringConfiguration externalFiltering;
    private final List<DataLakePrincipal> shareRecipients;

    private CreateLakeFormationIdentityCenterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.instanceArn = builder.instanceArn;
        this.externalFiltering = builder.externalFiltering;
        this.shareRecipients = builder.shareRecipients;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final ExternalFilteringConfiguration externalFiltering() {
        return this.externalFiltering;
    }

    public final boolean hasShareRecipients() {
        return this.shareRecipients != null && !(this.shareRecipients instanceof SdkAutoConstructList);
    }

    public final List<DataLakePrincipal> shareRecipients() {
        return this.shareRecipients;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalFiltering());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShareRecipients() ? this.shareRecipients() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLakeFormationIdentityCenterConfigurationRequest)) {
            return false;
        }
        CreateLakeFormationIdentityCenterConfigurationRequest other = (CreateLakeFormationIdentityCenterConfigurationRequest)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.externalFiltering(), other.externalFiltering()) && this.hasShareRecipients() == other.hasShareRecipients() && Objects.equals(this.shareRecipients(), other.shareRecipients());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLakeFormationIdentityCenterConfigurationRequest").add("CatalogId", (Object)this.catalogId()).add("InstanceArn", (Object)this.instanceArn()).add("ExternalFiltering", (Object)this.externalFiltering()).add("ShareRecipients", this.hasShareRecipients() ? this.shareRecipients() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "ExternalFiltering": {
                return Optional.ofNullable(clazz.cast(this.externalFiltering()));
            }
            case "ShareRecipients": {
                return Optional.ofNullable(clazz.cast(this.shareRecipients()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("ExternalFiltering", EXTERNAL_FILTERING_FIELD);
        map.put("ShareRecipients", SHARE_RECIPIENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLakeFormationIdentityCenterConfigurationRequest, T> g) {
        return obj -> g.apply((CreateLakeFormationIdentityCenterConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationRequest.BuilderImpl
    implements Builder {
        private String catalogId;
        private String instanceArn;
        private ExternalFilteringConfiguration externalFiltering;
        private List<DataLakePrincipal> shareRecipients = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLakeFormationIdentityCenterConfigurationRequest model) {
            super(model);
            this.catalogId(model.catalogId);
            this.instanceArn(model.instanceArn);
            this.externalFiltering(model.externalFiltering);
            this.shareRecipients(model.shareRecipients);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final ExternalFilteringConfiguration.Builder getExternalFiltering() {
            return this.externalFiltering != null ? this.externalFiltering.toBuilder() : null;
        }

        public final void setExternalFiltering(ExternalFilteringConfiguration.BuilderImpl externalFiltering) {
            this.externalFiltering = externalFiltering != null ? externalFiltering.build() : null;
        }

        @Override
        public final Builder externalFiltering(ExternalFilteringConfiguration externalFiltering) {
            this.externalFiltering = externalFiltering;
            return this;
        }

        public final List<DataLakePrincipal.Builder> getShareRecipients() {
            List<DataLakePrincipal.Builder> result = DataLakePrincipalListCopier.copyToBuilder(this.shareRecipients);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShareRecipients(Collection<DataLakePrincipal.BuilderImpl> shareRecipients) {
            this.shareRecipients = DataLakePrincipalListCopier.copyFromBuilder(shareRecipients);
        }

        @Override
        public final Builder shareRecipients(Collection<DataLakePrincipal> shareRecipients) {
            this.shareRecipients = DataLakePrincipalListCopier.copy(shareRecipients);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRecipients(DataLakePrincipal ... shareRecipients) {
            this.shareRecipients(Arrays.asList(shareRecipients));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shareRecipients(Consumer<DataLakePrincipal.Builder> ... shareRecipients) {
            this.shareRecipients(Stream.of(shareRecipients).map(c -> (DataLakePrincipal)((DataLakePrincipal.Builder)DataLakePrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLakeFormationIdentityCenterConfigurationRequest build() {
            return new CreateLakeFormationIdentityCenterConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LakeFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLakeFormationIdentityCenterConfigurationRequest> {
        public Builder catalogId(String var1);

        public Builder instanceArn(String var1);

        public Builder externalFiltering(ExternalFilteringConfiguration var1);

        default public Builder externalFiltering(Consumer<ExternalFilteringConfiguration.Builder> externalFiltering) {
            return this.externalFiltering((ExternalFilteringConfiguration)((ExternalFilteringConfiguration.Builder)ExternalFilteringConfiguration.builder().applyMutation(externalFiltering)).build());
        }

        public Builder shareRecipients(Collection<DataLakePrincipal> var1);

        public Builder shareRecipients(DataLakePrincipal ... var1);

        public Builder shareRecipients(Consumer<DataLakePrincipal.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

