/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.Condition;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal;
import software.amazon.awssdk.services.lakeformation.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeFormationOptInsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeFormationOptInsInfo> {
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resource").getter(LakeFormationOptInsInfo.getter(LakeFormationOptInsInfo::resource)).setter(LakeFormationOptInsInfo.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Principal").getter(LakeFormationOptInsInfo.getter(LakeFormationOptInsInfo::principal)).setter(LakeFormationOptInsInfo.setter(Builder::principal)).constructor(DataLakePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<Condition> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Condition").getter(LakeFormationOptInsInfo.getter(LakeFormationOptInsInfo::condition)).setter(LakeFormationOptInsInfo.setter(Builder::condition)).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(LakeFormationOptInsInfo.getter(LakeFormationOptInsInfo::lastModified)).setter(LakeFormationOptInsInfo.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedBy").getter(LakeFormationOptInsInfo.getter(LakeFormationOptInsInfo::lastUpdatedBy)).setter(LakeFormationOptInsInfo.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD, PRINCIPAL_FIELD, CONDITION_FIELD, LAST_MODIFIED_FIELD, LAST_UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LakeFormationOptInsInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Resource resource;
    private final DataLakePrincipal principal;
    private final Condition condition;
    private final Instant lastModified;
    private final String lastUpdatedBy;

    private LakeFormationOptInsInfo(BuilderImpl builder) {
        this.resource = builder.resource;
        this.principal = builder.principal;
        this.condition = builder.condition;
        this.lastModified = builder.lastModified;
        this.lastUpdatedBy = builder.lastUpdatedBy;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final DataLakePrincipal principal() {
        return this.principal;
    }

    public final Condition condition() {
        return this.condition;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationOptInsInfo)) {
            return false;
        }
        LakeFormationOptInsInfo other = (LakeFormationOptInsInfo)obj;
        return Objects.equals(this.resource(), other.resource()) && Objects.equals(this.principal(), other.principal()) && Objects.equals(this.condition(), other.condition()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"LakeFormationOptInsInfo").add("Resource", (Object)this.resource()).add("Principal", (Object)this.principal()).add("Condition", (Object)this.condition()).add("LastModified", (Object)this.lastModified()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Resource", RESOURCE_FIELD);
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationOptInsInfo, T> g) {
        return obj -> g.apply((LakeFormationOptInsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Resource resource;
        private DataLakePrincipal principal;
        private Condition condition;
        private Instant lastModified;
        private String lastUpdatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationOptInsInfo model) {
            this.resource(model.resource);
            this.principal(model.principal);
            this.condition(model.condition);
            this.lastModified(model.lastModified);
            this.lastUpdatedBy(model.lastUpdatedBy);
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Condition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public LakeFormationOptInsInfo build() {
            return new LakeFormationOptInsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeFormationOptInsInfo> {
        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder principal(DataLakePrincipal var1);

        default public Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return this.principal((DataLakePrincipal)((DataLakePrincipal.Builder)DataLakePrincipal.builder().applyMutation(principal)).build());
        }

        public Builder condition(Condition var1);

        default public Builder condition(Consumer<Condition.Builder> condition) {
            return this.condition((Condition)((Condition.Builder)Condition.builder().applyMutation(condition)).build());
        }

        public Builder lastModified(Instant var1);

        public Builder lastUpdatedBy(String var1);
    }
}

