/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.Condition;
import software.amazon.awssdk.services.lakeformation.model.DataLakePrincipal;
import software.amazon.awssdk.services.lakeformation.model.DetailsMap;
import software.amazon.awssdk.services.lakeformation.model.Permission;
import software.amazon.awssdk.services.lakeformation.model.PermissionListCopier;
import software.amazon.awssdk.services.lakeformation.model.Resource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalResourcePermissions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrincipalResourcePermissions> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Principal").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::principal)).setter(PrincipalResourcePermissions.setter(Builder::principal)).constructor(DataLakePrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()}).build();
    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resource").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::resource)).setter(PrincipalResourcePermissions.setter(Builder::resource)).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()}).build();
    private static final SdkField<Condition> CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Condition").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::condition)).setter(PrincipalResourcePermissions.setter(Builder::condition)).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::permissionsAsStrings)).setter(PrincipalResourcePermissions.setter(Builder::permissionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PermissionsWithGrantOption").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::permissionsWithGrantOptionAsStrings)).setter(PrincipalResourcePermissions.setter(Builder::permissionsWithGrantOptionWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DetailsMap> ADDITIONAL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdditionalDetails").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::additionalDetails)).setter(PrincipalResourcePermissions.setter(Builder::additionalDetails)).constructor(DetailsMap::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetails").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::lastUpdated)).setter(PrincipalResourcePermissions.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()}).build();
    private static final SdkField<String> LAST_UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedBy").getter(PrincipalResourcePermissions.getter(PrincipalResourcePermissions::lastUpdatedBy)).setter(PrincipalResourcePermissions.setter(Builder::lastUpdatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD, RESOURCE_FIELD, CONDITION_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD, ADDITIONAL_DETAILS_FIELD, LAST_UPDATED_FIELD, LAST_UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrincipalResourcePermissions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DataLakePrincipal principal;
    private final Resource resource;
    private final Condition condition;
    private final List<String> permissions;
    private final List<String> permissionsWithGrantOption;
    private final DetailsMap additionalDetails;
    private final Instant lastUpdated;
    private final String lastUpdatedBy;

    private PrincipalResourcePermissions(BuilderImpl builder) {
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.condition = builder.condition;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
        this.additionalDetails = builder.additionalDetails;
        this.lastUpdated = builder.lastUpdated;
        this.lastUpdatedBy = builder.lastUpdatedBy;
    }

    public final DataLakePrincipal principal() {
        return this.principal;
    }

    public final Resource resource() {
        return this.resource;
    }

    public final Condition condition() {
        return this.condition;
    }

    public final List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(this.permissions);
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsAsStrings() {
        return this.permissions;
    }

    public final List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(this.permissionsWithGrantOption);
    }

    public final boolean hasPermissionsWithGrantOption() {
        return this.permissionsWithGrantOption != null && !(this.permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    public final List<String> permissionsWithGrantOptionAsStrings() {
        return this.permissionsWithGrantOption;
    }

    public final DetailsMap additionalDetails() {
        return this.additionalDetails;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String lastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principal());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        hashCode = 31 * hashCode + Objects.hashCode(this.condition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissionsWithGrantOption() ? this.permissionsWithGrantOptionAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalResourcePermissions)) {
            return false;
        }
        PrincipalResourcePermissions other = (PrincipalResourcePermissions)obj;
        return Objects.equals(this.principal(), other.principal()) && Objects.equals(this.resource(), other.resource()) && Objects.equals(this.condition(), other.condition()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissionsAsStrings(), other.permissionsAsStrings()) && this.hasPermissionsWithGrantOption() == other.hasPermissionsWithGrantOption() && Objects.equals(this.permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings()) && Objects.equals(this.additionalDetails(), other.additionalDetails()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.lastUpdatedBy(), other.lastUpdatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"PrincipalResourcePermissions").add("Principal", (Object)this.principal()).add("Resource", (Object)this.resource()).add("Condition", (Object)this.condition()).add("Permissions", this.hasPermissions() ? this.permissionsAsStrings() : null).add("PermissionsWithGrantOption", this.hasPermissionsWithGrantOption() ? this.permissionsWithGrantOptionAsStrings() : null).add("AdditionalDetails", (Object)this.additionalDetails()).add("LastUpdated", (Object)this.lastUpdated()).add("LastUpdatedBy", (Object)this.lastUpdatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principal": {
                return Optional.ofNullable(clazz.cast(this.principal()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
            case "Condition": {
                return Optional.ofNullable(clazz.cast(this.condition()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissionsAsStrings()));
            }
            case "PermissionsWithGrantOption": {
                return Optional.ofNullable(clazz.cast(this.permissionsWithGrantOptionAsStrings()));
            }
            case "AdditionalDetails": {
                return Optional.ofNullable(clazz.cast(this.additionalDetails()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "LastUpdatedBy": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Principal", PRINCIPAL_FIELD);
        map.put("Resource", RESOURCE_FIELD);
        map.put("Condition", CONDITION_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        map.put("PermissionsWithGrantOption", PERMISSIONS_WITH_GRANT_OPTION_FIELD);
        map.put("AdditionalDetails", ADDITIONAL_DETAILS_FIELD);
        map.put("LastUpdated", LAST_UPDATED_FIELD);
        map.put("LastUpdatedBy", LAST_UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrincipalResourcePermissions, T> g) {
        return obj -> g.apply((PrincipalResourcePermissions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataLakePrincipal principal;
        private Resource resource;
        private Condition condition;
        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();
        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();
        private DetailsMap additionalDetails;
        private Instant lastUpdated;
        private String lastUpdatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalResourcePermissions model) {
            this.principal(model.principal);
            this.resource(model.resource);
            this.condition(model.condition);
            this.permissionsWithStrings(model.permissions);
            this.permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
            this.additionalDetails(model.additionalDetails);
            this.lastUpdated(model.lastUpdated);
            this.lastUpdatedBy(model.lastUpdatedBy);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return this.principal != null ? this.principal.toBuilder() : null;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final Resource.Builder getResource() {
            return this.resource != null ? this.resource.toBuilder() : null;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final Condition.Builder getCondition() {
            return this.condition != null ? this.condition.toBuilder() : null;
        }

        public final void setCondition(Condition.BuilderImpl condition) {
            this.condition = condition != null ? condition.build() : null;
        }

        @Override
        public final Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        public final Collection<String> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String ... permissions) {
            this.permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            if (this.permissionsWithGrantOption instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissionsWithGrantOption;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String ... permissionsWithGrantOption) {
            this.permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission ... permissionsWithGrantOption) {
            this.permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        public final DetailsMap.Builder getAdditionalDetails() {
            return this.additionalDetails != null ? this.additionalDetails.toBuilder() : null;
        }

        public final void setAdditionalDetails(DetailsMap.BuilderImpl additionalDetails) {
            this.additionalDetails = additionalDetails != null ? additionalDetails.build() : null;
        }

        @Override
        public final Builder additionalDetails(DetailsMap additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getLastUpdatedBy() {
            return this.lastUpdatedBy;
        }

        public final void setLastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
        }

        @Override
        public final Builder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public PrincipalResourcePermissions build() {
            return new PrincipalResourcePermissions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrincipalResourcePermissions> {
        public Builder principal(DataLakePrincipal var1);

        default public Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return this.principal((DataLakePrincipal)((DataLakePrincipal.Builder)DataLakePrincipal.builder().applyMutation(principal)).build());
        }

        public Builder resource(Resource var1);

        default public Builder resource(Consumer<Resource.Builder> resource) {
            return this.resource((Resource)((Resource.Builder)Resource.builder().applyMutation(resource)).build());
        }

        public Builder condition(Condition var1);

        default public Builder condition(Consumer<Condition.Builder> condition) {
            return this.condition((Condition)((Condition.Builder)Condition.builder().applyMutation(condition)).build());
        }

        public Builder permissionsWithStrings(Collection<String> var1);

        public Builder permissionsWithStrings(String ... var1);

        public Builder permissions(Collection<Permission> var1);

        public Builder permissions(Permission ... var1);

        public Builder permissionsWithGrantOptionWithStrings(Collection<String> var1);

        public Builder permissionsWithGrantOptionWithStrings(String ... var1);

        public Builder permissionsWithGrantOption(Collection<Permission> var1);

        public Builder permissionsWithGrantOption(Permission ... var1);

        public Builder additionalDetails(DetailsMap var1);

        default public Builder additionalDetails(Consumer<DetailsMap.Builder> additionalDetails) {
            return this.additionalDetails((DetailsMap)((DetailsMap.Builder)DetailsMap.builder().applyMutation(additionalDetails)).build());
        }

        public Builder lastUpdated(Instant var1);

        public Builder lastUpdatedBy(String var1);
    }
}

