/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchRevokePermissionsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<BatchRevokePermissionsRequest.Builder, BatchRevokePermissionsRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(BatchRevokePermissionsRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<List<BatchPermissionsRequestEntry>> ENTRIES_FIELD = SdkField
            .<List<BatchPermissionsRequestEntry>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(BatchRevokePermissionsRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPermissionsRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPermissionsRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            ENTRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogId;

    private final List<BatchPermissionsRequestEntry> entries;

    private BatchRevokePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.entries = builder.entries;
    }

    /**
     * <p>
     * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
     * store. It contains database definitions, table definitions, and other control information to manage your Lake
     * Formation environment.
     * </p>
     * 
     * @return The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
     *         metadata store. It contains database definitions, table definitions, and other control information to
     *         manage your Lake Formation environment.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
     */
    public final List<BatchPermissionsRequestEntry> entries() {
        return entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchRevokePermissionsRequest)) {
            return false;
        }
        BatchRevokePermissionsRequest other = (BatchRevokePermissionsRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && hasEntries() == other.hasEntries()
                && Objects.equals(entries(), other.entries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchRevokePermissionsRequest").add("CatalogId", catalogId())
                .add("Entries", hasEntries() ? entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogId", CATALOG_ID_FIELD);
        map.put("Entries", ENTRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchRevokePermissionsRequest, T> g) {
        return obj -> g.apply((BatchRevokePermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchRevokePermissionsRequest> {
        /**
         * <p>
         * The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent metadata
         * store. It contains database definitions, table definitions, and other control information to manage your Lake
         * Formation environment.
         * </p>
         * 
         * @param catalogId
         *        The identifier for the Data Catalog. By default, the account ID. The Data Catalog is the persistent
         *        metadata store. It contains database definitions, table definitions, and other control information to
         *        manage your Lake Formation environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
         * </p>
         * 
         * @param entries
         *        A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<BatchPermissionsRequestEntry> entries);

        /**
         * <p>
         * A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
         * </p>
         * 
         * @param entries
         *        A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(BatchPermissionsRequestEntry... entries);

        /**
         * <p>
         * A list of up to 20 entries for resource permissions to be revoked by batch operation to the principal.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry.Builder#build()} is
         * called immediately and its result is passed to {@link #entries(List<BatchPermissionsRequestEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.BatchPermissionsRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<BatchPermissionsRequestEntry>)
         */
        Builder entries(Consumer<BatchPermissionsRequestEntry.Builder>... entries);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private List<BatchPermissionsRequestEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchRevokePermissionsRequest model) {
            super(model);
            catalogId(model.catalogId);
            entries(model.entries);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final List<BatchPermissionsRequestEntry.Builder> getEntries() {
            List<BatchPermissionsRequestEntry.Builder> result = BatchPermissionsRequestEntryListCopier
                    .copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<BatchPermissionsRequestEntry.BuilderImpl> entries) {
            this.entries = BatchPermissionsRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<BatchPermissionsRequestEntry> entries) {
            this.entries = BatchPermissionsRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(BatchPermissionsRequestEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<BatchPermissionsRequestEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> BatchPermissionsRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchRevokePermissionsRequest build() {
            return new BatchRevokePermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
