/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTransactionResponse extends LakeFormationResponse implements
        ToCopyableBuilder<DescribeTransactionResponse.Builder, DescribeTransactionResponse> {
    private static final SdkField<TransactionDescription> TRANSACTION_DESCRIPTION_FIELD = SdkField
            .<TransactionDescription> builder(MarshallingType.SDK_POJO).memberName("TransactionDescription")
            .getter(getter(DescribeTransactionResponse::transactionDescription)).setter(setter(Builder::transactionDescription))
            .constructor(TransactionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TRANSACTION_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TransactionDescription transactionDescription;

    private DescribeTransactionResponse(BuilderImpl builder) {
        super(builder);
        this.transactionDescription = builder.transactionDescription;
    }

    /**
     * <p>
     * Returns a <code>TransactionDescription</code> object containing information about the transaction.
     * </p>
     * 
     * @return Returns a <code>TransactionDescription</code> object containing information about the transaction.
     */
    public final TransactionDescription transactionDescription() {
        return transactionDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactionDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTransactionResponse)) {
            return false;
        }
        DescribeTransactionResponse other = (DescribeTransactionResponse) obj;
        return Objects.equals(transactionDescription(), other.transactionDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTransactionResponse").add("TransactionDescription", transactionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TransactionDescription":
            return Optional.ofNullable(clazz.cast(transactionDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TransactionDescription", TRANSACTION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTransactionResponse, T> g) {
        return obj -> g.apply((DescribeTransactionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTransactionResponse> {
        /**
         * <p>
         * Returns a <code>TransactionDescription</code> object containing information about the transaction.
         * </p>
         * 
         * @param transactionDescription
         *        Returns a <code>TransactionDescription</code> object containing information about the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionDescription(TransactionDescription transactionDescription);

        /**
         * <p>
         * Returns a <code>TransactionDescription</code> object containing information about the transaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransactionDescription.Builder} avoiding
         * the need to create one manually via {@link TransactionDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransactionDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #transactionDescription(TransactionDescription)}.
         * 
         * @param transactionDescription
         *        a consumer that will call methods on {@link TransactionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transactionDescription(TransactionDescription)
         */
        default Builder transactionDescription(Consumer<TransactionDescription.Builder> transactionDescription) {
            return transactionDescription(TransactionDescription.builder().applyMutation(transactionDescription).build());
        }
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private TransactionDescription transactionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTransactionResponse model) {
            super(model);
            transactionDescription(model.transactionDescription);
        }

        public final TransactionDescription.Builder getTransactionDescription() {
            return transactionDescription != null ? transactionDescription.toBuilder() : null;
        }

        public final void setTransactionDescription(TransactionDescription.BuilderImpl transactionDescription) {
            this.transactionDescription = transactionDescription != null ? transactionDescription.build() : null;
        }

        @Override
        public final Builder transactionDescription(TransactionDescription transactionDescription) {
            this.transactionDescription = transactionDescription;
            return this;
        }

        @Override
        public DescribeTransactionResponse build() {
            return new DescribeTransactionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
