/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkUnitResultsRequest extends LakeFormationRequest implements
        ToCopyableBuilder<GetWorkUnitResultsRequest.Builder, GetWorkUnitResultsRequest> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(GetWorkUnitResultsRequest::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<Long> WORK_UNIT_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkUnitId").getter(getter(GetWorkUnitResultsRequest::workUnitId)).setter(setter(Builder::workUnitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitId").build()).build();

    private static final SdkField<String> WORK_UNIT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkUnitToken").getter(getter(GetWorkUnitResultsRequest::workUnitToken))
            .setter(setter(Builder::workUnitToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            WORK_UNIT_ID_FIELD, WORK_UNIT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryId;

    private final Long workUnitId;

    private final String workUnitToken;

    private GetWorkUnitResultsRequest(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.workUnitId = builder.workUnitId;
        this.workUnitToken = builder.workUnitToken;
    }

    /**
     * <p>
     * The ID of the plan query operation for which to get results.
     * </p>
     * 
     * @return The ID of the plan query operation for which to get results.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     * <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     * <code>GetWorkUnits</code>.
     * </p>
     * 
     * @return The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
     *         <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
     *         <code>GetWorkUnits</code>.
     */
    public final Long workUnitId() {
        return workUnitId;
    }

    /**
     * <p>
     * A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     * </p>
     * 
     * @return A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
     */
    public final String workUnitToken() {
        return workUnitToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(workUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(workUnitToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkUnitResultsRequest)) {
            return false;
        }
        GetWorkUnitResultsRequest other = (GetWorkUnitResultsRequest) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(workUnitId(), other.workUnitId())
                && Objects.equals(workUnitToken(), other.workUnitToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkUnitResultsRequest").add("QueryId", queryId()).add("WorkUnitId", workUnitId())
                .add("WorkUnitToken", workUnitToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "WorkUnitId":
            return Optional.ofNullable(clazz.cast(workUnitId()));
        case "WorkUnitToken":
            return Optional.ofNullable(clazz.cast(workUnitToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("WorkUnitId", WORK_UNIT_ID_FIELD);
        map.put("WorkUnitToken", WORK_UNIT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkUnitResultsRequest, T> g) {
        return obj -> g.apply((GetWorkUnitResultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LakeFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkUnitResultsRequest> {
        /**
         * <p>
         * The ID of the plan query operation for which to get results.
         * </p>
         * 
         * @param queryId
         *        The ID of the plan query operation for which to get results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code> to
         * <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
         * <code>GetWorkUnits</code>.
         * </p>
         * 
         * @param workUnitId
         *        The work unit ID for which to get results. Value generated by enumerating <code>WorkUnitIdMin</code>
         *        to <code>WorkUnitIdMax</code> (inclusive) from the <code>WorkUnitRange</code> in the output of
         *        <code>GetWorkUnits</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitId(Long workUnitId);

        /**
         * <p>
         * A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
         * </p>
         * 
         * @param workUnitToken
         *        A work token used to query the execution service. Token output from <code>GetWorkUnits</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitToken(String workUnitToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String queryId;

        private Long workUnitId;

        private String workUnitToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkUnitResultsRequest model) {
            super(model);
            queryId(model.queryId);
            workUnitId(model.workUnitId);
            workUnitToken(model.workUnitToken);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final Long getWorkUnitId() {
            return workUnitId;
        }

        public final void setWorkUnitId(Long workUnitId) {
            this.workUnitId = workUnitId;
        }

        @Override
        public final Builder workUnitId(Long workUnitId) {
            this.workUnitId = workUnitId;
            return this;
        }

        public final String getWorkUnitToken() {
            return workUnitToken;
        }

        public final void setWorkUnitToken(String workUnitToken) {
            this.workUnitToken = workUnitToken;
        }

        @Override
        public final Builder workUnitToken(String workUnitToken) {
            this.workUnitToken = workUnitToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWorkUnitResultsRequest build() {
            return new GetWorkUnitResultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
