/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics related to the processing of a query statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PlanningStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<PlanningStatistics.Builder, PlanningStatistics> {
    private static final SdkField<Long> ESTIMATED_DATA_TO_SCAN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedDataToScanBytes").getter(getter(PlanningStatistics::estimatedDataToScanBytes))
            .setter(setter(Builder::estimatedDataToScanBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedDataToScanBytes").build())
            .build();

    private static final SdkField<Long> PLANNING_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PlanningTimeMillis").getter(getter(PlanningStatistics::planningTimeMillis))
            .setter(setter(Builder::planningTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanningTimeMillis").build())
            .build();

    private static final SdkField<Long> QUEUE_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueueTimeMillis").getter(getter(PlanningStatistics::queueTimeMillis))
            .setter(setter(Builder::queueTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueTimeMillis").build()).build();

    private static final SdkField<Long> WORK_UNITS_GENERATED_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("WorkUnitsGeneratedCount").getter(getter(PlanningStatistics::workUnitsGeneratedCount))
            .setter(setter(Builder::workUnitsGeneratedCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitsGeneratedCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ESTIMATED_DATA_TO_SCAN_BYTES_FIELD, PLANNING_TIME_MILLIS_FIELD, QUEUE_TIME_MILLIS_FIELD,
            WORK_UNITS_GENERATED_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long estimatedDataToScanBytes;

    private final Long planningTimeMillis;

    private final Long queueTimeMillis;

    private final Long workUnitsGeneratedCount;

    private PlanningStatistics(BuilderImpl builder) {
        this.estimatedDataToScanBytes = builder.estimatedDataToScanBytes;
        this.planningTimeMillis = builder.planningTimeMillis;
        this.queueTimeMillis = builder.queueTimeMillis;
        this.workUnitsGeneratedCount = builder.workUnitsGeneratedCount;
    }

    /**
     * <p>
     * An estimate of the data that was scanned in bytes.
     * </p>
     * 
     * @return An estimate of the data that was scanned in bytes.
     */
    public final Long estimatedDataToScanBytes() {
        return estimatedDataToScanBytes;
    }

    /**
     * <p>
     * The time that it took to process the request.
     * </p>
     * 
     * @return The time that it took to process the request.
     */
    public final Long planningTimeMillis() {
        return planningTimeMillis;
    }

    /**
     * <p>
     * The time the request was in queue to be processed.
     * </p>
     * 
     * @return The time the request was in queue to be processed.
     */
    public final Long queueTimeMillis() {
        return queueTimeMillis;
    }

    /**
     * <p>
     * The number of work units generated.
     * </p>
     * 
     * @return The number of work units generated.
     */
    public final Long workUnitsGeneratedCount() {
        return workUnitsGeneratedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(estimatedDataToScanBytes());
        hashCode = 31 * hashCode + Objects.hashCode(planningTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(queueTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(workUnitsGeneratedCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlanningStatistics)) {
            return false;
        }
        PlanningStatistics other = (PlanningStatistics) obj;
        return Objects.equals(estimatedDataToScanBytes(), other.estimatedDataToScanBytes())
                && Objects.equals(planningTimeMillis(), other.planningTimeMillis())
                && Objects.equals(queueTimeMillis(), other.queueTimeMillis())
                && Objects.equals(workUnitsGeneratedCount(), other.workUnitsGeneratedCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PlanningStatistics").add("EstimatedDataToScanBytes", estimatedDataToScanBytes())
                .add("PlanningTimeMillis", planningTimeMillis()).add("QueueTimeMillis", queueTimeMillis())
                .add("WorkUnitsGeneratedCount", workUnitsGeneratedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EstimatedDataToScanBytes":
            return Optional.ofNullable(clazz.cast(estimatedDataToScanBytes()));
        case "PlanningTimeMillis":
            return Optional.ofNullable(clazz.cast(planningTimeMillis()));
        case "QueueTimeMillis":
            return Optional.ofNullable(clazz.cast(queueTimeMillis()));
        case "WorkUnitsGeneratedCount":
            return Optional.ofNullable(clazz.cast(workUnitsGeneratedCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EstimatedDataToScanBytes", ESTIMATED_DATA_TO_SCAN_BYTES_FIELD);
        map.put("PlanningTimeMillis", PLANNING_TIME_MILLIS_FIELD);
        map.put("QueueTimeMillis", QUEUE_TIME_MILLIS_FIELD);
        map.put("WorkUnitsGeneratedCount", WORK_UNITS_GENERATED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PlanningStatistics, T> g) {
        return obj -> g.apply((PlanningStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PlanningStatistics> {
        /**
         * <p>
         * An estimate of the data that was scanned in bytes.
         * </p>
         * 
         * @param estimatedDataToScanBytes
         *        An estimate of the data that was scanned in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedDataToScanBytes(Long estimatedDataToScanBytes);

        /**
         * <p>
         * The time that it took to process the request.
         * </p>
         * 
         * @param planningTimeMillis
         *        The time that it took to process the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planningTimeMillis(Long planningTimeMillis);

        /**
         * <p>
         * The time the request was in queue to be processed.
         * </p>
         * 
         * @param queueTimeMillis
         *        The time the request was in queue to be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueTimeMillis(Long queueTimeMillis);

        /**
         * <p>
         * The number of work units generated.
         * </p>
         * 
         * @param workUnitsGeneratedCount
         *        The number of work units generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workUnitsGeneratedCount(Long workUnitsGeneratedCount);
    }

    static final class BuilderImpl implements Builder {
        private Long estimatedDataToScanBytes;

        private Long planningTimeMillis;

        private Long queueTimeMillis;

        private Long workUnitsGeneratedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PlanningStatistics model) {
            estimatedDataToScanBytes(model.estimatedDataToScanBytes);
            planningTimeMillis(model.planningTimeMillis);
            queueTimeMillis(model.queueTimeMillis);
            workUnitsGeneratedCount(model.workUnitsGeneratedCount);
        }

        public final Long getEstimatedDataToScanBytes() {
            return estimatedDataToScanBytes;
        }

        public final void setEstimatedDataToScanBytes(Long estimatedDataToScanBytes) {
            this.estimatedDataToScanBytes = estimatedDataToScanBytes;
        }

        @Override
        public final Builder estimatedDataToScanBytes(Long estimatedDataToScanBytes) {
            this.estimatedDataToScanBytes = estimatedDataToScanBytes;
            return this;
        }

        public final Long getPlanningTimeMillis() {
            return planningTimeMillis;
        }

        public final void setPlanningTimeMillis(Long planningTimeMillis) {
            this.planningTimeMillis = planningTimeMillis;
        }

        @Override
        public final Builder planningTimeMillis(Long planningTimeMillis) {
            this.planningTimeMillis = planningTimeMillis;
            return this;
        }

        public final Long getQueueTimeMillis() {
            return queueTimeMillis;
        }

        public final void setQueueTimeMillis(Long queueTimeMillis) {
            this.queueTimeMillis = queueTimeMillis;
        }

        @Override
        public final Builder queueTimeMillis(Long queueTimeMillis) {
            this.queueTimeMillis = queueTimeMillis;
            return this;
        }

        public final Long getWorkUnitsGeneratedCount() {
            return workUnitsGeneratedCount;
        }

        public final void setWorkUnitsGeneratedCount(Long workUnitsGeneratedCount) {
            this.workUnitsGeneratedCount = workUnitsGeneratedCount;
        }

        @Override
        public final Builder workUnitsGeneratedCount(Long workUnitsGeneratedCount) {
            this.workUnitsGeneratedCount = workUnitsGeneratedCount;
            return this;
        }

        @Override
        public PlanningStatistics build() {
            return new PlanningStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
