/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.LFTagExpression;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLfTagExpressionsResponse;

public class ListLFTagExpressionsPublisher
implements SdkPublisher<ListLfTagExpressionsResponse> {
    private final LakeFormationAsyncClient client;
    private final ListLfTagExpressionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLFTagExpressionsPublisher(LakeFormationAsyncClient client, ListLfTagExpressionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLFTagExpressionsPublisher(LakeFormationAsyncClient client, ListLfTagExpressionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLfTagExpressionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLfTagExpressionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LFTagExpression> lfTagExpressions() {
        Function<ListLfTagExpressionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.lfTagExpressions() != null) {
                return response.lfTagExpressions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLfTagExpressionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLfTagExpressionsResponseFetcher
    implements AsyncPageFetcher<ListLfTagExpressionsResponse> {
        private ListLfTagExpressionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLfTagExpressionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLfTagExpressionsResponse> nextPage(ListLfTagExpressionsResponse previousPage) {
            if (previousPage == null) {
                return ListLFTagExpressionsPublisher.this.client.listLFTagExpressions(ListLFTagExpressionsPublisher.this.firstRequest);
            }
            return ListLFTagExpressionsPublisher.this.client.listLFTagExpressions((ListLfTagExpressionsRequest)((Object)ListLFTagExpressionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

