/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAliasesRequest extends LambdaRequest implements
        ToCopyableBuilder<ListAliasesRequest.Builder, ListAliasesRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAliasesRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAliasesRequest::functionVersion)).setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FunctionVersion").build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAliasesRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListAliasesRequest::maxItems)).setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            FUNCTION_VERSION_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));

    private final String functionName;

    private final String functionVersion;

    private final String marker;

    private final Integer maxItems;

    private ListAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.functionVersion = builder.functionVersion;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Specify a function version to only list aliases that invoke that version.
     * </p>
     * 
     * @return Specify a function version to only list aliases that invoke that version.
     */
    public String functionVersion() {
        return functionVersion;
    }

    /**
     * <p>
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * Limit the number of aliases returned.
     * </p>
     * 
     * @return Limit the number of aliases returned.
     */
    public Integer maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesRequest)) {
            return false;
        }
        ListAliasesRequest other = (ListAliasesRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(functionVersion(), other.functionVersion())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAliasesRequest").add("FunctionName", functionName())
                .add("FunctionVersion", functionVersion()).add("Marker", marker()).add("MaxItems", maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "FunctionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAliasesRequest, T> g) {
        return obj -> g.apply((ListAliasesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAliasesRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:MyFunction</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Specify a function version to only list aliases that invoke that version.
         * </p>
         * 
         * @param functionVersion
         *        Specify a function version to only list aliases that invoke that version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);

        /**
         * <p>
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param marker
         *        Specify the pagination token that's returned by a previous request to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Limit the number of aliases returned.
         * </p>
         * 
         * @param maxItems
         *        Limit the number of aliases returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String functionVersion;

        private String marker;

        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesRequest model) {
            super(model);
            functionName(model.functionName);
            functionVersion(model.functionVersion);
            marker(model.marker);
            maxItems(model.maxItems);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAliasesRequest build() {
            return new ListAliasesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
