/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.AddPermissionRequest;
import software.amazon.awssdk.services.lambda.model.AddPermissionResponse;
import software.amazon.awssdk.services.lambda.model.CodeStorageExceededException;
import software.amazon.awssdk.services.lambda.model.CreateAliasRequest;
import software.amazon.awssdk.services.lambda.model.CreateAliasResponse;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.CreateFunctionRequest;
import software.amazon.awssdk.services.lambda.model.CreateFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteAliasRequest;
import software.amazon.awssdk.services.lambda.model.DeleteAliasResponse;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.DeleteEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.DeleteLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.DeleteProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.Ec2AccessDeniedException;
import software.amazon.awssdk.services.lambda.model.Ec2ThrottledException;
import software.amazon.awssdk.services.lambda.model.Ec2UnexpectedException;
import software.amazon.awssdk.services.lambda.model.EniLimitReachedException;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.lambda.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.GetEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionRequest;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionByArnResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.GetLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.GetPolicyRequest;
import software.amazon.awssdk.services.lambda.model.GetPolicyResponse;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.GetProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.InvalidRequestContentException;
import software.amazon.awssdk.services.lambda.model.InvalidRuntimeException;
import software.amazon.awssdk.services.lambda.model.InvalidSecurityGroupIdException;
import software.amazon.awssdk.services.lambda.model.InvalidSubnetIdException;
import software.amazon.awssdk.services.lambda.model.InvalidZipFileException;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.lambda.model.KmsDisabledException;
import software.amazon.awssdk.services.lambda.model.KmsInvalidStateException;
import software.amazon.awssdk.services.lambda.model.KmsNotFoundException;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest;
import software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse;
import software.amazon.awssdk.services.lambda.model.ListLayersRequest;
import software.amazon.awssdk.services.lambda.model.ListLayersResponse;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsRequest;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.PolicyLengthExceededException;
import software.amazon.awssdk.services.lambda.model.PreconditionFailedException;
import software.amazon.awssdk.services.lambda.model.ProvisionedConcurrencyConfigNotFoundException;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishLayerVersionResponse;
import software.amazon.awssdk.services.lambda.model.PublishVersionRequest;
import software.amazon.awssdk.services.lambda.model.PublishVersionResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionConcurrencyResponse;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigRequest;
import software.amazon.awssdk.services.lambda.model.PutProvisionedConcurrencyConfigResponse;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemoveLayerVersionPermissionResponse;
import software.amazon.awssdk.services.lambda.model.RemovePermissionRequest;
import software.amazon.awssdk.services.lambda.model.RemovePermissionResponse;
import software.amazon.awssdk.services.lambda.model.RequestTooLargeException;
import software.amazon.awssdk.services.lambda.model.ResourceConflictException;
import software.amazon.awssdk.services.lambda.model.ResourceInUseException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lambda.model.ResourceNotReadyException;
import software.amazon.awssdk.services.lambda.model.ServiceException;
import software.amazon.awssdk.services.lambda.model.SubnetIpAddressLimitReachedException;
import software.amazon.awssdk.services.lambda.model.TagResourceRequest;
import software.amazon.awssdk.services.lambda.model.TagResourceResponse;
import software.amazon.awssdk.services.lambda.model.TooManyRequestsException;
import software.amazon.awssdk.services.lambda.model.UnsupportedMediaTypeException;
import software.amazon.awssdk.services.lambda.model.UntagResourceRequest;
import software.amazon.awssdk.services.lambda.model.UntagResourceResponse;
import software.amazon.awssdk.services.lambda.model.UpdateAliasRequest;
import software.amazon.awssdk.services.lambda.model.UpdateAliasResponse;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingRequest;
import software.amazon.awssdk.services.lambda.model.UpdateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionConfigurationResponse;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionEventInvokeConfigResponse;
import software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable;
import software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListLayersIterable;
import software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable;
import software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable;
import software.amazon.awssdk.services.lambda.transform.AddLayerVersionPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.DeleteProvisionedConcurrencyConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionByArnRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.GetProvisionedConcurrencyConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.InvokeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListEventSourceMappingsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionEventInvokeConfigsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListLayerVersionsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListLayersRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListProvisionedConcurrencyConfigsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.ListVersionsByFunctionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishLayerVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PublishVersionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutFunctionConcurrencyRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutFunctionEventInvokeConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.PutProvisionedConcurrencyConfigRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemoveLayerVersionPermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateAliasRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateEventSourceMappingRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionCodeRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.lambda.transform.UpdateFunctionEventInvokeConfigRequestMarshaller;

/**
 * Internal implementation of {@link LambdaClient}.
 *
 * @see LambdaClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultLambdaClient implements LambdaClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLambdaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds permissions to the resource-based policy of a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. Use this
     * action to grant layer usage permission to other accounts. You can grant permission to a single account, all AWS
     * accounts, or all accounts in an organization.
     * </p>
     * <p>
     * To revoke permission, call <a>RemoveLayerVersionPermission</a> with the statement ID that you specified when you
     * added it.
     * </p>
     *
     * @param addLayerVersionPermissionRequest
     * @return Result of the AddLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddLayerVersionPermissionResponse addLayerVersionPermission(
            AddLayerVersionPermissionRequest addLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, InvalidParameterValueException,
            PolicyLengthExceededException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddLayerVersionPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddLayerVersionPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<AddLayerVersionPermissionRequest, AddLayerVersionPermissionResponse>()
                        .withOperationName("AddLayerVersionPermission").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(addLayerVersionPermissionRequest)
                        .withMarshaller(new AddLayerVersionPermissionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Grants an AWS service or another account permission to use a function. You can apply the policy at the function
     * level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the
     * invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function.
     * </p>
     * <p>
     * To grant permission to another account, specify the account ID as the <code>Principal</code>. For AWS services,
     * the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or
     * <code>sns.amazonaws.com</code>. For AWS services, you can also specify the ARN or owning account of the
     * associated resource as the <code>SourceArn</code> or <code>SourceAccount</code>. If you grant permission to a
     * service principal without specifying the source, other accounts could potentially configure resources in their
     * account to invoke your Lambda function.
     * </p>
     * <p>
     * This action adds a statement to a resource-based permissions policy for the function. For more information about
     * function policies, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function
     * Policies</a>.
     * </p>
     *
     * @param addPermissionRequest
     * @return Result of the AddPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws PolicyLengthExceededException
     *         The permissions policy for the resource is too large. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a>
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.AddPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, PolicyLengthExceededException,
            TooManyRequestsException, PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddPermissionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<AddPermissionRequest, AddPermissionResponse>()
                .withOperationName("AddPermission").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(addPermissionRequest)
                .withMarshaller(new AddPermissionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a> for a Lambda
     * function version. Use aliases to provide clients with a function identifier that you can update to invoke a
     * different version.
     * </p>
     * <p>
     * You can also map an alias to split invocation requests between two versions. Use the <code>RoutingConfig</code>
     * parameter to specify a second version and the percentage of invocation requests that it receives.
     * </p>
     *
     * @param createAliasRequest
     * @return Result of the CreateAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws ServiceException,
            ResourceNotFoundException, ResourceConflictException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                .withOperationName("CreateAlias").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createAliasRequest)
                .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a mapping between an event source and an AWS Lambda function. Lambda reads items from the event source
     * and triggers the function.
     * </p>
     * <p>
     * For details about each event source type, see the following topics.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-ddb.html">Using AWS Lambda with Amazon DynamoDB</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-kinesis.html">Using AWS Lambda with Amazon Kinesis</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html">Using AWS Lambda with Amazon SQS</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * The following error handling options are only available for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> - If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> - Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> - Discard records older than the specified age.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> - Discard records after the specified number of retries.
     * </p>
     * </li>
     * </ul>
     *
     * @param createEventSourceMappingRequest
     * @return Result of the CreateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEventSourceMappingResponse createEventSourceMapping(
            CreateEventSourceMappingRequest createEventSourceMappingRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<CreateEventSourceMappingRequest, CreateEventSourceMappingResponse>()
                        .withOperationName("CreateEventSourceMapping").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(createEventSourceMappingRequest)
                        .withMarshaller(new CreateEventSourceMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a Lambda function. To create a function, you need a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/deployment-package-v2.html">deployment package</a> and an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role">
     * execution role</a>. The deployment package contains your function code. The execution role grants the function
     * permission to use AWS services, such as Amazon CloudWatch Logs for log streaming and AWS X-Ray for request
     * tracing.
     * </p>
     * <p>
     * When you create a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute or so. During this time, you can't invoke or modify
     * the function. The <code>State</code>, <code>StateReason</code>, and <code>StateReasonCode</code> fields in the
     * response from <a>GetFunctionConfiguration</a> indicate when the function is ready to invoke. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Function
     * States</a>.
     * </p>
     * <p>
     * A function has an unpublished version, and can have published versions and aliases. The unpublished version
     * changes when you update your function's code and configuration. A published version is a snapshot of your
     * function code and configuration that can't be changed. An alias is a named resource that maps to a version, and
     * can be changed to map to a different version. Use the <code>Publish</code> parameter to create version
     * <code>1</code> of your function from its initial configuration.
     * </p>
     * <p>
     * The other parameters let you configure version-specific and function-level settings. You can modify
     * version-specific settings later with <a>UpdateFunctionConfiguration</a>. Function-level settings apply to both
     * the unpublished and published versions of the function, and include tags (<a>TagResource</a>) and per-function
     * concurrency limits (<a>PutFunctionConcurrency</a>).
     * </p>
     * <p>
     * If another account or an AWS service invokes your function, use <a>AddPermission</a> to grant permission by
     * creating a resource-based IAM policy. You can grant permissions at the function level, on a version, or on an
     * alias.
     * </p>
     * <p>
     * To invoke your function directly, use <a>Invoke</a>. To invoke your function in response to events in other AWS
     * services, create an event source mapping (<a>CreateEventSourceMapping</a>), or configure a function trigger in
     * the other service. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-invocation.html">Invoking Functions</a>.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws ServiceException,
            InvalidParameterValueException, ResourceNotFoundException, ResourceConflictException, TooManyRequestsException,
            CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                .withOperationName("CreateFunction").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(createFunctionRequest)
                .withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param deleteAliasRequest
     * @return Result of the DeleteAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAliasResponse deleteAlias(DeleteAliasRequest deleteAliasRequest) throws ServiceException,
            InvalidParameterValueException, ResourceConflictException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                .withOperationName("DeleteAlias").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteAliasRequest)
                .withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes an <a href="https://docs.aws.amazon.com/lambda/latest/dg/intro-invocation-modes.html">event source
     * mapping</a>. You can get the identifier of a mapping from the output of <a>ListEventSourceMappings</a>.
     * </p>
     * <p>
     * When you delete an event source mapping, it enters a <code>Deleting</code> state and might not be completely
     * deleted for several seconds.
     * </p>
     *
     * @param deleteEventSourceMappingRequest
     * @return Result of the DeleteEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to update an
     *         EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteEventSourceMappingResponse deleteEventSourceMapping(
            DeleteEventSourceMappingRequest deleteEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceInUseException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteEventSourceMappingRequest, DeleteEventSourceMappingResponse>()
                        .withOperationName("DeleteEventSourceMapping").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteEventSourceMappingRequest)
                        .withMarshaller(new DeleteEventSourceMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a Lambda function. To delete a specific function version, use the <code>Qualifier</code> parameter.
     * Otherwise, all versions and aliases are deleted.
     * </p>
     * <p>
     * To delete Lambda event source mappings that invoke a function, use <a>DeleteEventSourceMapping</a>. For AWS
     * services and resources that invoke your function directly, delete the trigger in the service where you originally
     * configured it.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                .withOperationName("DeleteFunction").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionRequest)
                .withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a concurrent execution limit from a function.
     * </p>
     *
     * @param deleteFunctionConcurrencyRequest
     * @return Result of the DeleteFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionConcurrency"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionConcurrencyResponse deleteFunctionConcurrency(
            DeleteFunctionConcurrencyRequest deleteFunctionConcurrencyRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, ResourceConflictException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionConcurrencyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteFunctionConcurrencyRequest, DeleteFunctionConcurrencyResponse>()
                        .withOperationName("DeleteFunctionConcurrency").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionConcurrencyRequest)
                        .withMarshaller(new DeleteFunctionConcurrencyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param deleteFunctionEventInvokeConfigRequest
     * @return Result of the DeleteFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteFunctionEventInvokeConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFunctionEventInvokeConfigResponse deleteFunctionEventInvokeConfig(
            DeleteFunctionEventInvokeConfigRequest deleteFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteFunctionEventInvokeConfigRequest, DeleteFunctionEventInvokeConfigResponse>()
                        .withOperationName("DeleteFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionEventInvokeConfigRequest)
                        .withMarshaller(new DeleteFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Deleted versions can no longer be viewed or added to functions. To avoid breaking functions, a
     * copy of the version remains in Lambda until no functions refer to it.
     * </p>
     *
     * @param deleteLayerVersionRequest
     * @return Result of the DeleteLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLayerVersionResponse deleteLayerVersion(DeleteLayerVersionRequest deleteLayerVersionRequest)
            throws ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLayerVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<DeleteLayerVersionRequest, DeleteLayerVersionResponse>()
                .withOperationName("DeleteLayerVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(deleteLayerVersionRequest)
                .withMarshaller(new DeleteLayerVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Deletes the provisioned concurrency configuration for a function.
     * </p>
     *
     * @param deleteProvisionedConcurrencyConfigRequest
     * @return Result of the DeleteProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.DeleteProvisionedConcurrencyConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/DeleteProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteProvisionedConcurrencyConfigResponse deleteProvisionedConcurrencyConfig(
            DeleteProvisionedConcurrencyConfigRequest deleteProvisionedConcurrencyConfigRequest)
            throws InvalidParameterValueException, ResourceConflictException, ResourceNotFoundException,
            TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisionedConcurrencyConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisionedConcurrencyConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<DeleteProvisionedConcurrencyConfigRequest, DeleteProvisionedConcurrencyConfigResponse>()
                        .withOperationName("DeleteProvisionedConcurrencyConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(deleteProvisionedConcurrencyConfigRequest)
                        .withMarshaller(new DeleteProvisionedConcurrencyConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves details about your account's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limits</a> and usage in an AWS Region.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAccountSettings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAccountSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAccountSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAccountSettingsRequest, GetAccountSettingsResponse>()
                .withOperationName("GetAccountSettings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getAccountSettingsRequest)
                .withMarshaller(new GetAccountSettingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns details about a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param getAliasRequest
     * @return Result of the GetAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAliasResponse getAlias(GetAliasRequest getAliasRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetAliasRequest, GetAliasResponse>().withOperationName("GetAlias")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(getAliasRequest)
                .withMarshaller(new GetAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns details about an event source mapping. You can get the identifier of a mapping from the output of
     * <a>ListEventSourceMappings</a>.
     * </p>
     *
     * @param getEventSourceMappingRequest
     * @return Result of the GetEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetEventSourceMapping" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEventSourceMappingResponse getEventSourceMapping(GetEventSourceMappingRequest getEventSourceMappingRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetEventSourceMappingRequest, GetEventSourceMappingResponse>()
                .withOperationName("GetEventSourceMapping").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getEventSourceMappingRequest)
                .withMarshaller(new GetEventSourceMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about the function or function version, with a link to download the deployment package that's
     * valid for 10 minutes. If you specify a function version, only details that are specific to that version are
     * returned.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ServiceException,
            ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                .withOperationName("GetFunction").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionRequest)
                .withMarshaller(new GetFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns details about the concurrency configuration for a function. To set a concurrency limit for a function,
     * use <a>PutFunctionConcurrency</a>.
     * </p>
     *
     * @param getFunctionConcurrencyRequest
     * @return Result of the GetFunctionConcurrency operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetFunctionConcurrencyResponse getFunctionConcurrency(GetFunctionConcurrencyRequest getFunctionConcurrencyRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionConcurrencyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetFunctionConcurrencyRequest, GetFunctionConcurrencyResponse>()
                .withOperationName("GetFunctionConcurrency").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionConcurrencyRequest)
                .withMarshaller(new GetFunctionConcurrencyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the version-specific settings of a Lambda function or version. The output includes only options that can
     * vary between versions of a function. To modify these settings, use <a>UpdateFunctionConfiguration</a>.
     * </p>
     * <p>
     * To get all of a function's details, including function-level settings, use <a>GetFunction</a>.
     * </p>
     *
     * @param getFunctionConfigurationRequest
     * @return Result of the GetFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionConfigurationResponse getFunctionConfiguration(
            GetFunctionConfigurationRequest getFunctionConfigurationRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetFunctionConfigurationRequest, GetFunctionConfigurationResponse>()
                        .withOperationName("GetFunctionConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionConfigurationRequest)
                        .withMarshaller(new GetFunctionConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param getFunctionEventInvokeConfigRequest
     * @return Result of the GetFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetFunctionEventInvokeConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFunctionEventInvokeConfigResponse getFunctionEventInvokeConfig(
            GetFunctionEventInvokeConfigRequest getFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetFunctionEventInvokeConfigRequest, GetFunctionEventInvokeConfigResponse>()
                        .withOperationName("GetFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionEventInvokeConfigRequest)
                        .withMarshaller(new GetFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>, with a link
     * to download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionRequest
     * @return Result of the GetLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLayerVersionResponse getLayerVersion(GetLayerVersionRequest getLayerVersionRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLayerVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetLayerVersionRequest, GetLayerVersionResponse>()
                .withOperationName("GetLayerVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getLayerVersionRequest)
                .withMarshaller(new GetLayerVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns information about a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>, with a link
     * to download the layer archive that's valid for 10 minutes.
     * </p>
     *
     * @param getLayerVersionByArnRequest
     * @return Result of the GetLayerVersionByArn operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionByArn
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionByArn" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLayerVersionByArnResponse getLayerVersionByArn(GetLayerVersionByArnRequest getLayerVersionByArnRequest)
            throws ServiceException, InvalidParameterValueException, TooManyRequestsException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLayerVersionByArnResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLayerVersionByArnResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetLayerVersionByArnRequest, GetLayerVersionByArnResponse>()
                .withOperationName("GetLayerVersionByArn").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getLayerVersionByArnRequest)
                .withMarshaller(new GetLayerVersionByArnRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the permission policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param getLayerVersionPolicyRequest
     * @return Result of the GetLayerVersionPolicy operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetLayerVersionPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetLayerVersionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLayerVersionPolicyResponse getLayerVersionPolicy(GetLayerVersionPolicyRequest getLayerVersionPolicyRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLayerVersionPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLayerVersionPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetLayerVersionPolicyRequest, GetLayerVersionPolicyResponse>()
                .withOperationName("GetLayerVersionPolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getLayerVersionPolicyRequest)
                .withMarshaller(new GetLayerVersionPolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">resource-based IAM
     * policy</a> for a function, version, or alias.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ServiceException, ResourceNotFoundException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                .withOperationName("GetPolicy").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyRequest)
                .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves the provisioned concurrency configuration for a function's alias or version.
     * </p>
     *
     * @param getProvisionedConcurrencyConfigRequest
     * @return Result of the GetProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ProvisionedConcurrencyConfigNotFoundException
     *         The specified configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.GetProvisionedConcurrencyConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/GetProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetProvisionedConcurrencyConfigResponse getProvisionedConcurrencyConfig(
            GetProvisionedConcurrencyConfigRequest getProvisionedConcurrencyConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, ProvisionedConcurrencyConfigNotFoundException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetProvisionedConcurrencyConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetProvisionedConcurrencyConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<GetProvisionedConcurrencyConfigRequest, GetProvisionedConcurrencyConfigResponse>()
                        .withOperationName("GetProvisionedConcurrencyConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(getProvisionedConcurrencyConfigRequest)
                        .withMarshaller(new GetProvisionedConcurrencyConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Invokes a Lambda function. You can invoke a function synchronously (and wait for the response), or
     * asynchronously. To invoke a function asynchronously, set <code>InvocationType</code> to <code>Event</code>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-sync.html">synchronous invocation</a>,
     * details about the function response, including errors, are included in the response body and headers. For either
     * invocation type, you can find more information in the <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/monitoring-functions.html">execution log</a> and <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-x-ray.html">trace</a>.
     * </p>
     * <p>
     * When an error occurs, your function may be invoked multiple times. Retry behavior varies by error type, client,
     * event source, and invocation type. For example, if you invoke a function asynchronously and it returns an error,
     * Lambda executes the function up to two more times. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/retries-on-errors.html">Retry Behavior</a>.
     * </p>
     * <p>
     * For <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous invocation</a>,
     * Lambda adds events to a queue before sending them to your function. If your function does not have enough
     * capacity to keep up with the queue, events may be lost. Occasionally, your function may receive the same event
     * multiple times, even if no error occurs. To retain events that were not processed, configure your function with a
     * <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">dead-letter queue</a>.
     * </p>
     * <p>
     * The status code in the API response doesn't reflect function errors. Error codes are reserved for errors that
     * prevent your function from executing, such as permissions errors, <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">limit errors</a>, or issues with your function's
     * code and configuration. For example, Lambda returns <code>TooManyRequestsException</code> if executing the
     * function would cause you to exceed a concurrency limit at either the account level (
     * <code>ConcurrentInvocationLimitExceeded</code>) or function level (
     * <code>ReservedFunctionConcurrentInvocationLimitExceeded</code>).
     * </p>
     * <p>
     * For functions with a long timeout, your client might be disconnected during synchronous invocation while it waits
     * for a response. Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
     * connections with timeout or keep-alive settings.
     * </p>
     * <p>
     * This operation requires permission for the <code>lambda:InvokeFunction</code> action.
     * </p>
     *
     * @param invokeRequest
     * @return Result of the Invoke operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidRequestContentException
     *         The request body could not be parsed as JSON.
     * @throws RequestTooLargeException
     *         The request payload exceeded the <code>Invoke</code> request body JSON input limit. For more information,
     *         see <a href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Limits</a>.
     * @throws UnsupportedMediaTypeException
     *         The content type of the <code>Invoke</code> request body is not JSON.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws Ec2UnexpectedException
     *         AWS Lambda received an unexpected EC2 client exception while setting up for the Lambda function.
     * @throws SubnetIpAddressLimitReachedException
     *         AWS Lambda was not able to set up VPC access for the Lambda function because one or more configured
     *         subnets has no available IP addresses.
     * @throws EniLimitReachedException
     *         AWS Lambda was not able to create an elastic network interface in the VPC, specified as part of Lambda
     *         function configuration, because the limit for network interfaces has been reached.
     * @throws Ec2ThrottledException
     *         AWS Lambda was throttled by Amazon EC2 during Lambda function initialization using the execution role
     *         provided for the Lambda function.
     * @throws Ec2AccessDeniedException
     *         Need additional permissions to configure VPC settings.
     * @throws InvalidSubnetIdException
     *         The Subnet ID provided in the Lambda function VPC configuration is invalid.
     * @throws InvalidSecurityGroupIdException
     *         The Security Group ID provided in the Lambda function VPC configuration is invalid.
     * @throws InvalidZipFileException
     *         AWS Lambda could not unzip the deployment package.
     * @throws KmsDisabledException
     *         Lambda was unable to decrypt the environment variables because the KMS key used is disabled. Check the
     *         Lambda function's KMS key settings.
     * @throws KmsInvalidStateException
     *         Lambda was unable to decrypt the environment variables because the KMS key used is in an invalid state
     *         for Decrypt. Check the function's KMS key settings.
     * @throws KmsAccessDeniedException
     *         Lambda was unable to decrypt the environment variables because KMS access was denied. Check the Lambda
     *         function's KMS permissions.
     * @throws KmsNotFoundException
     *         Lambda was unable to decrypt the environment variables because the KMS key was not found. Check the
     *         function's KMS key settings.
     * @throws InvalidRuntimeException
     *         The runtime or runtime version specified is not supported.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotReadyException
     *         The function is inactive and its VPC connection is no longer available. Wait for the VPC connection to
     *         reestablish and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.Invoke
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/Invoke" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public InvokeResponse invoke(InvokeRequest invokeRequest) throws ServiceException, ResourceNotFoundException,
            InvalidRequestContentException, RequestTooLargeException, UnsupportedMediaTypeException, TooManyRequestsException,
            InvalidParameterValueException, Ec2UnexpectedException, SubnetIpAddressLimitReachedException,
            EniLimitReachedException, Ec2ThrottledException, Ec2AccessDeniedException, InvalidSubnetIdException,
            InvalidSecurityGroupIdException, InvalidZipFileException, KmsDisabledException, KmsInvalidStateException,
            KmsAccessDeniedException, KmsNotFoundException, InvalidRuntimeException, ResourceConflictException,
            ResourceNotReadyException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<InvokeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                InvokeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<InvokeRequest, InvokeResponse>().withOperationName("Invoke")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(invokeRequest)
                .withMarshaller(new InvokeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for
     * a Lambda function.
     * </p>
     *
     * @param listAliasesRequest
     * @return Result of the ListAliases operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAliasesResponse listAliases(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                .withOperationName("ListAliases").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listAliasesRequest)
                .withMarshaller(new ListAliasesRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">aliases</a> for
     * a Lambda function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListAliasesIterable responses = client.listAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.lambda.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAliasesIterable listAliasesPaginator(ListAliasesRequest listAliasesRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        return new ListAliasesIterable(this, applyPaginatorUserAgent(listAliasesRequest));
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return Result of the ListEventSourceMappings operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListEventSourceMappingsResponse listEventSourceMappings(ListEventSourceMappingsRequest listEventSourceMappingsRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEventSourceMappingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEventSourceMappingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListEventSourceMappingsRequest, ListEventSourceMappingsResponse>()
                .withOperationName("ListEventSourceMappings").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listEventSourceMappingsRequest)
                .withMarshaller(new ListEventSourceMappingsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists event source mappings. Specify an <code>EventSourceArn</code> to only show event source mappings for a
     * single event source.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client
     *             .listEventSourceMappingsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListEventSourceMappingsIterable responses = client.listEventSourceMappingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventSourceMappings(software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventSourceMappingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListEventSourceMappings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListEventSourceMappings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListEventSourceMappingsIterable listEventSourceMappingsPaginator(
            ListEventSourceMappingsRequest listEventSourceMappingsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListEventSourceMappingsIterable(this, applyPaginatorUserAgent(listEventSourceMappingsRequest));
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return Result of the ListFunctionEventInvokeConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionEventInvokeConfigsResponse listFunctionEventInvokeConfigs(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionEventInvokeConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFunctionEventInvokeConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListFunctionEventInvokeConfigsRequest, ListFunctionEventInvokeConfigsResponse>()
                        .withOperationName("ListFunctionEventInvokeConfigs").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionEventInvokeConfigsRequest)
                        .withMarshaller(new ListFunctionEventInvokeConfigsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of configurations for asynchronous invocation for a function.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client
     *             .listFunctionEventInvokeConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionEventInvokeConfigsIterable responses = client.listFunctionEventInvokeConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctionEventInvokeConfigs(software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFunctionEventInvokeConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctionEventInvokeConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctionEventInvokeConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFunctionEventInvokeConfigsIterable listFunctionEventInvokeConfigsPaginator(
            ListFunctionEventInvokeConfigsRequest listFunctionEventInvokeConfigsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, TooManyRequestsException, ServiceException, AwsServiceException, SdkClientException,
            LambdaException {
        return new ListFunctionEventInvokeConfigsIterable(this, applyPaginatorUserAgent(listFunctionEventInvokeConfigsRequest));
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFunctionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                .withOperationName("ListFunctions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionsRequest)
                .withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of Lambda functions, with the version-specific configuration of each.
     * </p>
     * <p>
     * Set <code>FunctionVersion</code> to <code>ALL</code> to include all published versions of each function in
     * addition to the unpublished version. To get more information about a function or version, use <a>GetFunction</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.lambda.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsIterable listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) throws ServiceException,
            TooManyRequestsException, InvalidParameterValueException, AwsServiceException, SdkClientException, LambdaException {
        return new ListFunctionsIterable(this, applyPaginatorUserAgent(listFunctionsRequest));
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return Result of the ListLayerVersions operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayerVersionsResponse listLayerVersions(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLayerVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLayerVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListLayerVersionsRequest, ListLayerVersionsResponse>()
                .withOperationName("ListLayerVersions").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listLayerVersionsRequest)
                .withMarshaller(new ListLayerVersionsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists the versions of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
     * Lambda layer</a>. Versions that have been deleted aren't listed. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * versions that indicate that they're compatible with that runtime.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client
     *             .listLayerVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayerVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayerVersionsIterable responses = client.listLayerVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayerVersions(software.amazon.awssdk.services.lambda.model.ListLayerVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listLayerVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayerVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayerVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayerVersionsIterable listLayerVersionsPaginator(ListLayerVersionsRequest listLayerVersionsRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListLayerVersionsIterable(this, applyPaginatorUserAgent(listLayerVersionsRequest));
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layers</a> and
     * shows information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     *
     * @param listLayersRequest
     * @return Result of the ListLayers operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayersResponse listLayers(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLayersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListLayersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListLayersRequest, ListLayersResponse>()
                .withOperationName("ListLayers").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listLayersRequest)
                .withMarshaller(new ListLayersRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Lists <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layers</a> and
     * shows information about the latest version of each. Specify a <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime identifier</a> to list only
     * layers that indicate that they're compatible with that runtime.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListLayersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListLayersIterable responses = client.listLayersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayers(software.amazon.awssdk.services.lambda.model.ListLayersRequest)} operation.</b>
     * </p>
     *
     * @param listLayersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListLayers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLayersIterable listLayersPaginator(ListLayersRequest listLayersRequest) throws ServiceException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListLayersIterable(this, applyPaginatorUserAgent(listLayersRequest));
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return Result of the ListProvisionedConcurrencyConfigs operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisionedConcurrencyConfigsResponse listProvisionedConcurrencyConfigs(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisionedConcurrencyConfigsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisionedConcurrencyConfigsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<ListProvisionedConcurrencyConfigsRequest, ListProvisionedConcurrencyConfigsResponse>()
                        .withOperationName("ListProvisionedConcurrencyConfigs").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(listProvisionedConcurrencyConfigsRequest)
                        .withMarshaller(new ListProvisionedConcurrencyConfigsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Retrieves a list of provisioned concurrency configurations for a function.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client
     *             .listProvisionedConcurrencyConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListProvisionedConcurrencyConfigsIterable responses = client.listProvisionedConcurrencyConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProvisionedConcurrencyConfigs(software.amazon.awssdk.services.lambda.model.ListProvisionedConcurrencyConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProvisionedConcurrencyConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListProvisionedConcurrencyConfigs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListProvisionedConcurrencyConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListProvisionedConcurrencyConfigsIterable listProvisionedConcurrencyConfigsPaginator(
            ListProvisionedConcurrencyConfigsRequest listProvisionedConcurrencyConfigsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        return new ListProvisionedConcurrencyConfigsIterable(this,
                applyPaginatorUserAgent(listProvisionedConcurrencyConfigsRequest));
    }

    /**
     * <p>
     * Returns a function's <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a>. You can also
     * view tags with <a>GetFunction</a>.
     * </p>
     *
     * @param listTagsRequest
     * @return Result of the ListTags operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsResponse listTags(ListTagsRequest listTagsRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListTagsRequest, ListTagsResponse>().withOperationName("ListTags")
                .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput(listTagsRequest)
                .withMarshaller(new ListTagsRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each.
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return Result of the ListVersionsByFunction operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListVersionsByFunctionResponse listVersionsByFunction(ListVersionsByFunctionRequest listVersionsByFunctionRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVersionsByFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVersionsByFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<ListVersionsByFunctionRequest, ListVersionsByFunctionResponse>()
                .withOperationName("ListVersionsByFunction").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(listVersionsByFunctionRequest)
                .withMarshaller(new ListVersionsByFunctionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Returns a list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">versions</a>,
     * with the version-specific configuration of each.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client
     *             .listVersionsByFunctionPaginator(request);
     *     for (software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.lambda.paginators.ListVersionsByFunctionIterable responses = client.listVersionsByFunctionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVersionsByFunction(software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVersionsByFunctionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.ListVersionsByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListVersionsByFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListVersionsByFunctionIterable listVersionsByFunctionPaginator(
            ListVersionsByFunctionRequest listVersionsByFunctionRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, AwsServiceException, SdkClientException, LambdaException {
        return new ListVersionsByFunctionIterable(this, applyPaginatorUserAgent(listVersionsByFunctionRequest));
    }

    /**
     * <p>
     * Creates an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>
     * from a ZIP archive. Each time you call <code>PublishLayerVersion</code> with the same layer name, a new version
     * is created.
     * </p>
     * <p>
     * Add layers to your function with <a>CreateFunction</a> or <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param publishLayerVersionRequest
     * @return Result of the PublishLayerVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishLayerVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishLayerVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PublishLayerVersionResponse publishLayerVersion(PublishLayerVersionRequest publishLayerVersionRequest)
            throws ServiceException, ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException,
            CodeStorageExceededException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PublishLayerVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PublishLayerVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PublishLayerVersionRequest, PublishLayerVersionResponse>()
                .withOperationName("PublishLayerVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(publishLayerVersionRequest)
                .withMarshaller(new PublishLayerVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Creates a <a href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">version</a> from the
     * current code and configuration of a function. Use versions to create a snapshot of your function code and
     * configuration that doesn't change.
     * </p>
     * <p>
     * AWS Lambda doesn't publish a version if the function's configuration and code haven't changed since the last
     * version. Use <a>UpdateFunctionCode</a> or <a>UpdateFunctionConfiguration</a> to update the function before
     * publishing a version.
     * </p>
     * <p>
     * Clients can invoke versions directly or with an alias. To create an alias, use <a>CreateAlias</a>.
     * </p>
     *
     * @param publishVersionRequest
     * @return Result of the PublishVersion operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PublishVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PublishVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PublishVersionResponse publishVersion(PublishVersionRequest publishVersionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, CodeStorageExceededException,
            PreconditionFailedException, ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PublishVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PublishVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PublishVersionRequest, PublishVersionResponse>()
                .withOperationName("PublishVersion").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(publishVersionRequest)
                .withMarshaller(new PublishVersionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Sets the maximum number of simultaneous executions for a function, and reserves capacity for that concurrency
     * level.
     * </p>
     * <p>
     * Concurrency settings apply to the function as a whole, including all published versions and the unpublished
     * version. Reserving concurrency both ensures that your function has capacity to process the specified number of
     * events simultaneously, and prevents it from scaling beyond that level. Use <a>GetFunction</a> to see the current
     * setting for a function.
     * </p>
     * <p>
     * Use <a>GetAccountSettings</a> to see your Regional concurrency limit. You can reserve concurrency for as many
     * functions as you like, as long as you leave at least 100 simultaneous executions unreserved for functions that
     * aren't configured with a per-function limit. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html">Managing Concurrency</a>.
     * </p>
     *
     * @param putFunctionConcurrencyRequest
     * @return Result of the PutFunctionConcurrency operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionConcurrency
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionConcurrency" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutFunctionConcurrencyResponse putFunctionConcurrency(PutFunctionConcurrencyRequest putFunctionConcurrencyRequest)
            throws ServiceException, InvalidParameterValueException, ResourceNotFoundException, TooManyRequestsException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFunctionConcurrencyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutFunctionConcurrencyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<PutFunctionConcurrencyRequest, PutFunctionConcurrencyResponse>()
                .withOperationName("PutFunctionConcurrency").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(putFunctionConcurrencyRequest)
                .withMarshaller(new PutFunctionConcurrencyRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Configures options for <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html">asynchronous
     * invocation</a> on a function, version, or alias.
     * </p>
     * <p>
     * By default, Lambda retries an asynchronous invocation twice if the function returns an error. It retains events
     * in a queue for up to six hours. When an event fails all processing attempts or stays in the asynchronous
     * invocation queue for too long, Lambda discards it. To retain discarded events, configure a dead-letter queue with
     * <a>UpdateFunctionConfiguration</a>.
     * </p>
     *
     * @param putFunctionEventInvokeConfigRequest
     * @return Result of the PutFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutFunctionEventInvokeConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutFunctionEventInvokeConfigResponse putFunctionEventInvokeConfig(
            PutFunctionEventInvokeConfigRequest putFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PutFunctionEventInvokeConfigRequest, PutFunctionEventInvokeConfigResponse>()
                        .withOperationName("PutFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(putFunctionEventInvokeConfigRequest)
                        .withMarshaller(new PutFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds a provisioned concurrency configuration to a function's alias or version.
     * </p>
     *
     * @param putProvisionedConcurrencyConfigRequest
     * @return Result of the PutProvisionedConcurrencyConfig operation returned by the service.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.PutProvisionedConcurrencyConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/PutProvisionedConcurrencyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutProvisionedConcurrencyConfigResponse putProvisionedConcurrencyConfig(
            PutProvisionedConcurrencyConfigRequest putProvisionedConcurrencyConfigRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ResourceConflictException, TooManyRequestsException, ServiceException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutProvisionedConcurrencyConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutProvisionedConcurrencyConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<PutProvisionedConcurrencyConfigRequest, PutProvisionedConcurrencyConfigResponse>()
                        .withOperationName("PutProvisionedConcurrencyConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(putProvisionedConcurrencyConfigRequest)
                        .withMarshaller(new PutProvisionedConcurrencyConfigRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes a statement from the permissions policy for a version of an <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS Lambda layer</a>. For more
     * information, see <a>AddLayerVersionPermission</a>.
     * </p>
     *
     * @param removeLayerVersionPermissionRequest
     * @return Result of the RemoveLayerVersionPermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemoveLayerVersionPermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemoveLayerVersionPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveLayerVersionPermissionResponse removeLayerVersionPermission(
            RemoveLayerVersionPermissionRequest removeLayerVersionPermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveLayerVersionPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveLayerVersionPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<RemoveLayerVersionPermissionRequest, RemoveLayerVersionPermissionResponse>()
                        .withOperationName("RemoveLayerVersionPermission").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(removeLayerVersionPermissionRequest)
                        .withMarshaller(new RemoveLayerVersionPermissionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Revokes function-use permission from an AWS service or another account. You can get the ID of the statement from
     * the output of <a>GetPolicy</a>.
     * </p>
     *
     * @param removePermissionRequest
     * @return Result of the RemovePermission operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.RemovePermission
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemovePermissionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemovePermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<RemovePermissionRequest, RemovePermissionResponse>()
                .withOperationName("RemovePermission").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(removePermissionRequest)
                .withMarshaller(new RemovePermissionRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Adds <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to a function.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                .withOperationName("TagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Removes <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> from a function.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                .withOperationName("UntagResource").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the configuration of a Lambda function <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html">alias</a>.
     * </p>
     *
     * @param updateAliasRequest
     * @return Result of the UpdateAlias operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAliasResponse updateAlias(UpdateAliasRequest updateAliasRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, PreconditionFailedException,
            ResourceConflictException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateAliasRequest, UpdateAliasResponse>()
                .withOperationName("UpdateAlias").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateAliasRequest)
                .withMarshaller(new UpdateAliasRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates an event source mapping. You can change the function that AWS Lambda invokes, or pause invocation and
     * resume later from the same location.
     * </p>
     * <p>
     * The following error handling options are only available for stream sources (DynamoDB and Kinesis):
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BisectBatchOnFunctionError</code> - If the function returns an error, split the batch in two and retry.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DestinationConfig</code> - Send discarded records to an Amazon SQS queue or Amazon SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRecordAgeInSeconds</code> - Discard records older than the specified age.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaximumRetryAttempts</code> - Discard records after the specified number of retries.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateEventSourceMappingRequest
     * @return Result of the UpdateEventSourceMapping operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceInUseException
     *         The operation conflicts with the resource's availability. For example, you attempted to update an
     *         EventSource Mapping in CREATING, or tried to delete a EventSource mapping currently in the UPDATING
     *         state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateEventSourceMapping
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateEventSourceMapping"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateEventSourceMappingResponse updateEventSourceMapping(
            UpdateEventSourceMappingRequest updateEventSourceMappingRequest) throws ServiceException, ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, ResourceConflictException, ResourceInUseException,
            AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventSourceMappingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventSourceMappingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateEventSourceMappingRequest, UpdateEventSourceMappingResponse>()
                        .withOperationName("UpdateEventSourceMapping").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateEventSourceMappingRequest)
                        .withMarshaller(new UpdateEventSourceMappingRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates a Lambda function's code.
     * </p>
     * <p>
     * The function's code is locked when you publish a version. You can't modify the code of a published version, only
     * the unpublished version.
     * </p>
     *
     * @param updateFunctionCodeRequest
     * @return Result of the UpdateFunctionCode operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws CodeStorageExceededException
     *         You have exceeded your maximum total code size per account. <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/limits.html">Learn more</a>
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionCode
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionCode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFunctionCodeResponse updateFunctionCode(UpdateFunctionCodeRequest updateFunctionCodeRequest)
            throws ServiceException, ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException,
            CodeStorageExceededException, PreconditionFailedException, ResourceConflictException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionCodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler.execute(new ClientExecutionParams<UpdateFunctionCodeRequest, UpdateFunctionCodeResponse>()
                .withOperationName("UpdateFunctionCode").withResponseHandler(responseHandler)
                .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionCodeRequest)
                .withMarshaller(new UpdateFunctionCodeRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Modify the version-specific settings of a Lambda function.
     * </p>
     * <p>
     * When you update a function, Lambda provisions an instance of the function and its supporting resources. If your
     * function connects to a VPC, this process can take a minute. During this time, you can't modify the function, but
     * you can still invoke it. The <code>LastUpdateStatus</code>, <code>LastUpdateStatusReason</code>, and
     * <code>LastUpdateStatusReasonCode</code> fields in the response from <a>GetFunctionConfiguration</a> indicate when
     * the update is complete and the function is processing events with the new configuration. For more information,
     * see <a href="https://docs.aws.amazon.com/lambda/latest/dg/functions-states.html">Function States</a>.
     * </p>
     * <p>
     * These settings can vary between versions of a function and are locked when you publish a version. You can't
     * modify the configuration of a published version, only the unpublished version.
     * </p>
     * <p>
     * To configure function concurrency, use <a>PutFunctionConcurrency</a>. To grant invoke permissions to an account
     * or AWS service, use <a>AddPermission</a>.
     * </p>
     *
     * @param updateFunctionConfigurationRequest
     * @return Result of the UpdateFunctionConfiguration operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws ResourceConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws PreconditionFailedException
     *         The RevisionId provided does not match the latest RevisionId for the Lambda function or alias. Call the
     *         <code>GetFunction</code> or the <code>GetAlias</code> API to retrieve the latest RevisionId for your
     *         resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFunctionConfigurationResponse updateFunctionConfiguration(
            UpdateFunctionConfigurationRequest updateFunctionConfigurationRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, ResourceConflictException,
            PreconditionFailedException, AwsServiceException, SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateFunctionConfigurationRequest, UpdateFunctionConfigurationResponse>()
                        .withOperationName("UpdateFunctionConfiguration").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionConfigurationRequest)
                        .withMarshaller(new UpdateFunctionConfigurationRequestMarshaller(protocolFactory)));
    }

    /**
     * <p>
     * Updates the configuration for asynchronous invocation for a function, version, or alias.
     * </p>
     * <p>
     * To configure options for asynchronous invocation, use <a>PutFunctionEventInvokeConfig</a>.
     * </p>
     *
     * @param updateFunctionEventInvokeConfigRequest
     * @return Result of the UpdateFunctionEventInvokeConfig operation returned by the service.
     * @throws ServiceException
     *         The AWS Lambda service encountered an internal error.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InvalidParameterValueException
     *         One of the parameters in the request is invalid.
     * @throws TooManyRequestsException
     *         The request throughput limit was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws LambdaException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample LambdaClient.UpdateFunctionEventInvokeConfig
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/UpdateFunctionEventInvokeConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFunctionEventInvokeConfigResponse updateFunctionEventInvokeConfig(
            UpdateFunctionEventInvokeConfigRequest updateFunctionEventInvokeConfigRequest) throws ServiceException,
            ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, AwsServiceException,
            SdkClientException, LambdaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionEventInvokeConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFunctionEventInvokeConfigResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);

        return clientHandler
                .execute(new ClientExecutionParams<UpdateFunctionEventInvokeConfigRequest, UpdateFunctionEventInvokeConfigResponse>()
                        .withOperationName("UpdateFunctionEventInvokeConfig").withResponseHandler(responseHandler)
                        .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionEventInvokeConfigRequest)
                        .withMarshaller(new UpdateFunctionEventInvokeConfigRequestMarshaller(protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(LambdaException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2AccessDeniedException")
                                .exceptionBuilderSupplier(Ec2AccessDeniedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotReadyException")
                                .exceptionBuilderSupplier(ResourceNotReadyException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSInvalidStateException")
                                .exceptionBuilderSupplier(KmsInvalidStateException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSNotFoundException")
                                .exceptionBuilderSupplier(KmsNotFoundException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyLengthExceededException")
                                .exceptionBuilderSupplier(PolicyLengthExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceException")
                                .exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetIPAddressLimitReachedException")
                                .exceptionBuilderSupplier(SubnetIpAddressLimitReachedException::builder).httpStatusCode(502)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidZipFileException")
                                .exceptionBuilderSupplier(InvalidZipFileException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestContentException")
                                .exceptionBuilderSupplier(InvalidRequestContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRuntimeException")
                                .exceptionBuilderSupplier(InvalidRuntimeException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ProvisionedConcurrencyConfigNotFoundException")
                                .exceptionBuilderSupplier(ProvisionedConcurrencyConfigNotFoundException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ENILimitReachedException")
                                .exceptionBuilderSupplier(EniLimitReachedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnetIDException")
                                .exceptionBuilderSupplier(InvalidSubnetIdException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceConflictException")
                                .exceptionBuilderSupplier(ResourceConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CodeStorageExceededException")
                                .exceptionBuilderSupplier(CodeStorageExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecurityGroupIDException")
                                .exceptionBuilderSupplier(InvalidSecurityGroupIdException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2ThrottledException")
                                .exceptionBuilderSupplier(Ec2ThrottledException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSAccessDeniedException")
                                .exceptionBuilderSupplier(KmsAccessDeniedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSDisabledException")
                                .exceptionBuilderSupplier(KmsDisabledException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailedException")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EC2UnexpectedException")
                                .exceptionBuilderSupplier(Ec2UnexpectedException::builder).httpStatusCode(502).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RequestTooLargeException")
                                .exceptionBuilderSupplier(RequestTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRequestsException")
                                .exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedMediaTypeException")
                                .exceptionBuilderSupplier(UnsupportedMediaTypeException::builder).httpStatusCode(415).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends LambdaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
