/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Limits that are related to concurrency and storage. All file and storage sizes are in bytes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLimit implements SdkPojo, Serializable, ToCopyableBuilder<AccountLimit.Builder, AccountLimit> {
    private static final SdkField<Long> TOTAL_CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AccountLimit::totalCodeSize)).setter(setter(Builder::totalCodeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCodeSize").build()).build();

    private static final SdkField<Long> CODE_SIZE_UNZIPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AccountLimit::codeSizeUnzipped)).setter(setter(Builder::codeSizeUnzipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSizeUnzipped").build()).build();

    private static final SdkField<Long> CODE_SIZE_ZIPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AccountLimit::codeSizeZipped)).setter(setter(Builder::codeSizeZipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSizeZipped").build()).build();

    private static final SdkField<Integer> CONCURRENT_EXECUTIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AccountLimit::concurrentExecutions)).setter(setter(Builder::concurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConcurrentExecutions").build())
            .build();

    private static final SdkField<Integer> UNRESERVED_CONCURRENT_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(AccountLimit::unreservedConcurrentExecutions))
            .setter(setter(Builder::unreservedConcurrentExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnreservedConcurrentExecutions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOTAL_CODE_SIZE_FIELD, CODE_SIZE_UNZIPPED_FIELD, CODE_SIZE_ZIPPED_FIELD, CONCURRENT_EXECUTIONS_FIELD,
                    UNRESERVED_CONCURRENT_EXECUTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalCodeSize;

    private final Long codeSizeUnzipped;

    private final Long codeSizeZipped;

    private final Integer concurrentExecutions;

    private final Integer unreservedConcurrentExecutions;

    private AccountLimit(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.codeSizeUnzipped = builder.codeSizeUnzipped;
        this.codeSizeZipped = builder.codeSizeZipped;
        this.concurrentExecutions = builder.concurrentExecutions;
        this.unreservedConcurrentExecutions = builder.unreservedConcurrentExecutions;
    }

    /**
     * <p>
     * The amount of storage space that you can use for all deployment packages and layer archives.
     * </p>
     * 
     * @return The amount of storage space that you can use for all deployment packages and layer archives.
     */
    public Long totalCodeSize() {
        return totalCodeSize;
    }

    /**
     * <p>
     * The maximum size of a function's deployment package and layers when they're extracted.
     * </p>
     * 
     * @return The maximum size of a function's deployment package and layers when they're extracted.
     */
    public Long codeSizeUnzipped() {
        return codeSizeUnzipped;
    }

    /**
     * <p>
     * The maximum size of a deployment package when it's uploaded directly to AWS Lambda. Use Amazon S3 for larger
     * files.
     * </p>
     * 
     * @return The maximum size of a deployment package when it's uploaded directly to AWS Lambda. Use Amazon S3 for
     *         larger files.
     */
    public Long codeSizeZipped() {
        return codeSizeZipped;
    }

    /**
     * <p>
     * The maximum number of simultaneous function executions.
     * </p>
     * 
     * @return The maximum number of simultaneous function executions.
     */
    public Integer concurrentExecutions() {
        return concurrentExecutions;
    }

    /**
     * <p>
     * The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
     * functions with <a>PutFunctionConcurrency</a>.
     * </p>
     * 
     * @return The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
     *         functions with <a>PutFunctionConcurrency</a>.
     */
    public Integer unreservedConcurrentExecutions() {
        return unreservedConcurrentExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCodeSize());
        hashCode = 31 * hashCode + Objects.hashCode(codeSizeUnzipped());
        hashCode = 31 * hashCode + Objects.hashCode(codeSizeZipped());
        hashCode = 31 * hashCode + Objects.hashCode(concurrentExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(unreservedConcurrentExecutions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLimit)) {
            return false;
        }
        AccountLimit other = (AccountLimit) obj;
        return Objects.equals(totalCodeSize(), other.totalCodeSize())
                && Objects.equals(codeSizeUnzipped(), other.codeSizeUnzipped())
                && Objects.equals(codeSizeZipped(), other.codeSizeZipped())
                && Objects.equals(concurrentExecutions(), other.concurrentExecutions())
                && Objects.equals(unreservedConcurrentExecutions(), other.unreservedConcurrentExecutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccountLimit").add("TotalCodeSize", totalCodeSize()).add("CodeSizeUnzipped", codeSizeUnzipped())
                .add("CodeSizeZipped", codeSizeZipped()).add("ConcurrentExecutions", concurrentExecutions())
                .add("UnreservedConcurrentExecutions", unreservedConcurrentExecutions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalCodeSize":
            return Optional.ofNullable(clazz.cast(totalCodeSize()));
        case "CodeSizeUnzipped":
            return Optional.ofNullable(clazz.cast(codeSizeUnzipped()));
        case "CodeSizeZipped":
            return Optional.ofNullable(clazz.cast(codeSizeZipped()));
        case "ConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(concurrentExecutions()));
        case "UnreservedConcurrentExecutions":
            return Optional.ofNullable(clazz.cast(unreservedConcurrentExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountLimit, T> g) {
        return obj -> g.apply((AccountLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountLimit> {
        /**
         * <p>
         * The amount of storage space that you can use for all deployment packages and layer archives.
         * </p>
         * 
         * @param totalCodeSize
         *        The amount of storage space that you can use for all deployment packages and layer archives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCodeSize(Long totalCodeSize);

        /**
         * <p>
         * The maximum size of a function's deployment package and layers when they're extracted.
         * </p>
         * 
         * @param codeSizeUnzipped
         *        The maximum size of a function's deployment package and layers when they're extracted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSizeUnzipped(Long codeSizeUnzipped);

        /**
         * <p>
         * The maximum size of a deployment package when it's uploaded directly to AWS Lambda. Use Amazon S3 for larger
         * files.
         * </p>
         * 
         * @param codeSizeZipped
         *        The maximum size of a deployment package when it's uploaded directly to AWS Lambda. Use Amazon S3 for
         *        larger files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSizeZipped(Long codeSizeZipped);

        /**
         * <p>
         * The maximum number of simultaneous function executions.
         * </p>
         * 
         * @param concurrentExecutions
         *        The maximum number of simultaneous function executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder concurrentExecutions(Integer concurrentExecutions);

        /**
         * <p>
         * The maximum number of simultaneous function executions, minus the capacity that's reserved for individual
         * functions with <a>PutFunctionConcurrency</a>.
         * </p>
         * 
         * @param unreservedConcurrentExecutions
         *        The maximum number of simultaneous function executions, minus the capacity that's reserved for
         *        individual functions with <a>PutFunctionConcurrency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unreservedConcurrentExecutions(Integer unreservedConcurrentExecutions);
    }

    static final class BuilderImpl implements Builder {
        private Long totalCodeSize;

        private Long codeSizeUnzipped;

        private Long codeSizeZipped;

        private Integer concurrentExecutions;

        private Integer unreservedConcurrentExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLimit model) {
            totalCodeSize(model.totalCodeSize);
            codeSizeUnzipped(model.codeSizeUnzipped);
            codeSizeZipped(model.codeSizeZipped);
            concurrentExecutions(model.concurrentExecutions);
            unreservedConcurrentExecutions(model.unreservedConcurrentExecutions);
        }

        public final Long getTotalCodeSize() {
            return totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        public final Long getCodeSizeUnzipped() {
            return codeSizeUnzipped;
        }

        @Override
        public final Builder codeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
            return this;
        }

        public final void setCodeSizeUnzipped(Long codeSizeUnzipped) {
            this.codeSizeUnzipped = codeSizeUnzipped;
        }

        public final Long getCodeSizeZipped() {
            return codeSizeZipped;
        }

        @Override
        public final Builder codeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
            return this;
        }

        public final void setCodeSizeZipped(Long codeSizeZipped) {
            this.codeSizeZipped = codeSizeZipped;
        }

        public final Integer getConcurrentExecutions() {
            return concurrentExecutions;
        }

        @Override
        public final Builder concurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
            return this;
        }

        public final void setConcurrentExecutions(Integer concurrentExecutions) {
            this.concurrentExecutions = concurrentExecutions;
        }

        public final Integer getUnreservedConcurrentExecutions() {
            return unreservedConcurrentExecutions;
        }

        @Override
        public final Builder unreservedConcurrentExecutions(Integer unreservedConcurrentExecutions) {
            this.unreservedConcurrentExecutions = unreservedConcurrentExecutions;
            return this;
        }

        public final void setUnreservedConcurrentExecutions(Integer unreservedConcurrentExecutions) {
            this.unreservedConcurrentExecutions = unreservedConcurrentExecutions;
        }

        @Override
        public AccountLimit build() {
            return new AccountLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
