/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPermissionResponse extends LambdaResponse implements
        ToCopyableBuilder<AddPermissionResponse.Builder, AddPermissionResponse> {
    private static final SdkField<String> STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddPermissionResponse::statement)).setter(setter(Builder::statement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_FIELD));

    private final String statement;

    private AddPermissionResponse(BuilderImpl builder) {
        super(builder);
        this.statement = builder.statement;
    }

    /**
     * <p>
     * The permission statement that's added to the function policy.
     * </p>
     * 
     * @return The permission statement that's added to the function policy.
     */
    public String statement() {
        return statement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statement());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionResponse)) {
            return false;
        }
        AddPermissionResponse other = (AddPermissionResponse) obj;
        return Objects.equals(statement(), other.statement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddPermissionResponse").add("Statement", statement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Statement":
            return Optional.ofNullable(clazz.cast(statement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionResponse, T> g) {
        return obj -> g.apply((AddPermissionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddPermissionResponse> {
        /**
         * <p>
         * The permission statement that's added to the function policy.
         * </p>
         * 
         * @param statement
         *        The permission statement that's added to the function policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statement(String statement);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String statement;

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionResponse model) {
            super(model);
            statement(model.statement);
        }

        public final String getStatement() {
            return statement;
        }

        @Override
        public final Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public final void setStatement(String statement) {
            this.statement = statement;
        }

        @Override
        public AddPermissionResponse build() {
            return new AddPermissionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
