/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEventSourceMappingsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListEventSourceMappingsResponse.Builder, ListEventSourceMappingsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListEventSourceMappingsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<EventSourceMappingConfiguration>> EVENT_SOURCE_MAPPINGS_FIELD = SdkField
            .<List<EventSourceMappingConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(ListEventSourceMappingsResponse::eventSourceMappings))
            .setter(setter(Builder::eventSourceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventSourceMappingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventSourceMappingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            EVENT_SOURCE_MAPPINGS_FIELD));

    private final String nextMarker;

    private final List<EventSourceMappingConfiguration> eventSourceMappings;

    private ListEventSourceMappingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.eventSourceMappings = builder.eventSourceMappings;
    }

    /**
     * <p>
     * A pagination token that's returned when the response doesn't contain all event source mappings.
     * </p>
     * 
     * @return A pagination token that's returned when the response doesn't contain all event source mappings.
     */
    public String nextMarker() {
        return nextMarker;
    }

    /**
     * Returns true if the EventSourceMappings property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEventSourceMappings() {
        return eventSourceMappings != null && !(eventSourceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of event source mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEventSourceMappings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of event source mappings.
     */
    public List<EventSourceMappingConfiguration> eventSourceMappings() {
        return eventSourceMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(eventSourceMappings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEventSourceMappingsResponse)) {
            return false;
        }
        ListEventSourceMappingsResponse other = (ListEventSourceMappingsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker())
                && Objects.equals(eventSourceMappings(), other.eventSourceMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListEventSourceMappingsResponse").add("NextMarker", nextMarker())
                .add("EventSourceMappings", eventSourceMappings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "EventSourceMappings":
            return Optional.ofNullable(clazz.cast(eventSourceMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEventSourceMappingsResponse, T> g) {
        return obj -> g.apply((ListEventSourceMappingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEventSourceMappingsResponse> {
        /**
         * <p>
         * A pagination token that's returned when the response doesn't contain all event source mappings.
         * </p>
         * 
         * @param nextMarker
         *        A pagination token that's returned when the response doesn't contain all event source mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * A list of event source mappings.
         * </p>
         * 
         * @param eventSourceMappings
         *        A list of event source mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings);

        /**
         * <p>
         * A list of event source mappings.
         * </p>
         * 
         * @param eventSourceMappings
         *        A list of event source mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSourceMappings(EventSourceMappingConfiguration... eventSourceMappings);

        /**
         * <p>
         * A list of event source mappings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EventSourceMappingConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<EventSourceMappingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EventSourceMappingConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #eventSourceMappings(List<EventSourceMappingConfiguration>)}.
         * 
         * @param eventSourceMappings
         *        a consumer that will call methods on {@link List<EventSourceMappingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventSourceMappings(List<EventSourceMappingConfiguration>)
         */
        Builder eventSourceMappings(Consumer<EventSourceMappingConfiguration.Builder>... eventSourceMappings);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<EventSourceMappingConfiguration> eventSourceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEventSourceMappingsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            eventSourceMappings(model.eventSourceMappings);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        public final Collection<EventSourceMappingConfiguration.Builder> getEventSourceMappings() {
            return eventSourceMappings != null ? eventSourceMappings.stream().map(EventSourceMappingConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder eventSourceMappings(Collection<EventSourceMappingConfiguration> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copy(eventSourceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(EventSourceMappingConfiguration... eventSourceMappings) {
            eventSourceMappings(Arrays.asList(eventSourceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventSourceMappings(Consumer<EventSourceMappingConfiguration.Builder>... eventSourceMappings) {
            eventSourceMappings(Stream.of(eventSourceMappings)
                    .map(c -> EventSourceMappingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEventSourceMappings(Collection<EventSourceMappingConfiguration.BuilderImpl> eventSourceMappings) {
            this.eventSourceMappings = EventSourceMappingsListCopier.copyFromBuilder(eventSourceMappings);
        }

        @Override
        public ListEventSourceMappingsResponse build() {
            return new ListEventSourceMappingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
