/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * (MQ) The Secrets Manager secret that stores your broker credentials. To store your secret, use the following format:
 * <code> { "username": "your username", "password": "your password" }</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceAccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceAccessConfiguration.Builder, SourceAccessConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SourceAccessConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("URI")
            .getter(getter(SourceAccessConfiguration::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URI").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String uri;

    private SourceAccessConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.uri = builder.uri;
    }

    /**
     * <p>
     * To reference the secret, use the following format: <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code>
     * </p>
     * <p>
     * The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use customer or
     * service managed keys. When using a customer managed KMS key, the Lambda execution role requires
     * <code>kms:Decrypt</code> permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return To reference the secret, use the following format:
     *         <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code> </p>
     *         <p>
     *         The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use
     *         customer or service managed keys. When using a customer managed KMS key, the Lambda execution role
     *         requires <code>kms:Decrypt</code> permissions.
     * @see SourceAccessType
     */
    public SourceAccessType type() {
        return SourceAccessType.fromValue(type);
    }

    /**
     * <p>
     * To reference the secret, use the following format: <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code>
     * </p>
     * <p>
     * The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use customer or
     * service managed keys. When using a customer managed KMS key, the Lambda execution role requires
     * <code>kms:Decrypt</code> permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return To reference the secret, use the following format:
     *         <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code> </p>
     *         <p>
     *         The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use
     *         customer or service managed keys. When using a customer managed KMS key, the Lambda execution role
     *         requires <code>kms:Decrypt</code> permissions.
     * @see SourceAccessType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * To reference the secret, use the following format: <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code>
     * </p>
     * <p>
     * The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use customer or
     * service managed keys. When using a customer managed KMS key, the Lambda execution role requires
     * <code>kms:Decrypt</code> permissions.
     * </p>
     * 
     * @return To reference the secret, use the following format:
     *         <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code> </p>
     *         <p>
     *         The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use
     *         customer or service managed keys. When using a customer managed KMS key, the Lambda execution role
     *         requires <code>kms:Decrypt</code> permissions.
     */
    public String uri() {
        return uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAccessConfiguration)) {
            return false;
        }
        SourceAccessConfiguration other = (SourceAccessConfiguration) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(uri(), other.uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SourceAccessConfiguration").add("Type", typeAsString()).add("URI", uri()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "URI":
            return Optional.ofNullable(clazz.cast(uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAccessConfiguration, T> g) {
        return obj -> g.apply((SourceAccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceAccessConfiguration> {
        /**
         * <p>
         * To reference the secret, use the following format:
         * <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code>
         * </p>
         * <p>
         * The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use customer
         * or service managed keys. When using a customer managed KMS key, the Lambda execution role requires
         * <code>kms:Decrypt</code> permissions.
         * </p>
         * 
         * @param type
         *        To reference the secret, use the following format:
         *        <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code> </p>
         *        <p>
         *        The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use
         *        customer or service managed keys. When using a customer managed KMS key, the Lambda execution role
         *        requires <code>kms:Decrypt</code> permissions.
         * @see SourceAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceAccessType
         */
        Builder type(String type);

        /**
         * <p>
         * To reference the secret, use the following format:
         * <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code>
         * </p>
         * <p>
         * The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use customer
         * or service managed keys. When using a customer managed KMS key, the Lambda execution role requires
         * <code>kms:Decrypt</code> permissions.
         * </p>
         * 
         * @param type
         *        To reference the secret, use the following format:
         *        <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code> </p>
         *        <p>
         *        The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use
         *        customer or service managed keys. When using a customer managed KMS key, the Lambda execution role
         *        requires <code>kms:Decrypt</code> permissions.
         * @see SourceAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceAccessType
         */
        Builder type(SourceAccessType type);

        /**
         * <p>
         * To reference the secret, use the following format:
         * <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code>
         * </p>
         * <p>
         * The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use customer
         * or service managed keys. When using a customer managed KMS key, the Lambda execution role requires
         * <code>kms:Decrypt</code> permissions.
         * </p>
         * 
         * @param uri
         *        To reference the secret, use the following format:
         *        <code>[ { "Type": "BASIC_AUTH", "URI": "secretARN" } ]</code> </p>
         *        <p>
         *        The value of <code>Type</code> is always <code>BASIC_AUTH</code>. To encrypt the secret, you can use
         *        customer or service managed keys. When using a customer managed KMS key, the Lambda execution role
         *        requires <code>kms:Decrypt</code> permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String uri;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAccessConfiguration model) {
            type(model.type);
            uri(model.uri);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceAccessType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getUri() {
            return uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public SourceAccessConfiguration build() {
            return new SourceAccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
