/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionConfigurationRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateFunctionConfigurationRequest.Builder, UpdateFunctionConfigurationRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateFunctionConfigurationRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(UpdateFunctionConfigurationRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Handler")
            .getter(getter(UpdateFunctionConfigurationRequest::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFunctionConfigurationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(UpdateFunctionConfigurationRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemorySize").getter(getter(UpdateFunctionConfigurationRequest::memorySize))
            .setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(UpdateFunctionConfigurationRequest::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.<Environment> builder(MarshallingType.SDK_POJO)
            .memberName("Environment").getter(getter(UpdateFunctionConfigurationRequest::environment))
            .setter(setter(Builder::environment)).constructor(Environment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Runtime")
            .getter(getter(UpdateFunctionConfigurationRequest::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(UpdateFunctionConfigurationRequest::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyArn").getter(getter(UpdateFunctionConfigurationRequest::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<TracingConfig> TRACING_CONFIG_FIELD = SdkField
            .<TracingConfig> builder(MarshallingType.SDK_POJO).memberName("TracingConfig")
            .getter(getter(UpdateFunctionConfigurationRequest::tracingConfig)).setter(setter(Builder::tracingConfig))
            .constructor(TracingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(UpdateFunctionConfigurationRequest::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<List<String>> LAYERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Layers")
            .getter(getter(UpdateFunctionConfigurationRequest::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField
            .<List<FileSystemConfig>> builder(MarshallingType.LIST)
            .memberName("FileSystemConfigs")
            .getter(getter(UpdateFunctionConfigurationRequest::fileSystemConfigs))
            .setter(setter(Builder::fileSystemConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.<ImageConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ImageConfig").getter(getter(UpdateFunctionConfigurationRequest::imageConfig))
            .setter(setter(Builder::imageConfig)).constructor(ImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            ROLE_FIELD, HANDLER_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD, VPC_CONFIG_FIELD, ENVIRONMENT_FIELD,
            RUNTIME_FIELD, DEAD_LETTER_CONFIG_FIELD, KMS_KEY_ARN_FIELD, TRACING_CONFIG_FIELD, REVISION_ID_FIELD, LAYERS_FIELD,
            FILE_SYSTEM_CONFIGS_FIELD, IMAGE_CONFIG_FIELD));

    private final String functionName;

    private final String role;

    private final String handler;

    private final String description;

    private final Integer timeout;

    private final Integer memorySize;

    private final VpcConfig vpcConfig;

    private final Environment environment;

    private final String runtime;

    private final DeadLetterConfig deadLetterConfig;

    private final String kmsKeyArn;

    private final TracingConfig tracingConfig;

    private final String revisionId;

    private final List<String> layers;

    private final List<FileSystemConfig> fileSystemConfigs;

    private final ImageConfig imageConfig;

    private UpdateFunctionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.role = builder.role;
        this.handler = builder.handler;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.vpcConfig = builder.vpcConfig;
        this.environment = builder.environment;
        this.runtime = builder.runtime;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.revisionId = builder.revisionId;
        this.layers = builder.layers;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.imageConfig = builder.imageConfig;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function's execution role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function's execution role.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The name of the method within your code that Lambda calls to execute your function. The format includes the file
     * name. It can also include namespaces and other qualifiers, depending on the runtime. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
     * </p>
     * 
     * @return The name of the method within your code that Lambda calls to execute your function. The format includes
     *         the file name. It can also include namespaces and other qualifiers, depending on the runtime. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
     */
    public final String handler() {
        return handler;
    }

    /**
     * <p>
     * A description of the function.
     * </p>
     * 
     * @return A description of the function.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The maximum
     * allowed value is 900 seconds.
     * </p>
     * 
     * @return The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The
     *         maximum allowed value is 900 seconds.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The amount of memory available to the function at runtime. Increasing the function's memory also increases its
     * CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
     * </p>
     * 
     * @return The amount of memory available to the function at runtime. Increasing the function's memory also
     *         increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
     */
    public final Integer memorySize() {
        return memorySize;
    }

    /**
     * <p>
     * For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC.
     * When you connect a function to a VPC, it can only access resources and the internet through that VPC. For more
     * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
     * </p>
     * 
     * @return For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the
     *         VPC. When you connect a function to a VPC, it can only access resources and the internet through that
     *         VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Environment variables that are accessible from function code during execution.
     * </p>
     * 
     * @return Environment variables that are accessible from function code during execution.
     */
    public final Environment environment() {
        return environment;
    }

    /**
     * <p>
     * The identifier of the function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The identifier of the function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * @see Runtime
     */
    public final Runtime runtime() {
        return Runtime.fromValue(runtime);
    }

    /**
     * <p>
     * The identifier of the function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The identifier of the function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
     * @see Runtime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when
     * they fail processing. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
     * </p>
     * 
     * @return A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous
     *         events when they fail processing. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's environment
     * variables. If it's not provided, AWS Lambda uses a default service key.
     * </p>
     * 
     * @return The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's
     *         environment variables. If it's not provided, AWS Lambda uses a default service key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS X-Ray.
     * </p>
     * 
     * @return Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS
     *         X-Ray.
     */
    public final TracingConfig tracingConfig() {
        return tracingConfig;
    }

    /**
     * <p>
     * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a
     * function that has changed since you last read it.
     * </p>
     * 
     * @return Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
     *         modifying a function that has changed since you last read it.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * Returns true if the Layers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to
     * add to the function's execution environment. Specify each layer by its ARN, including the version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLayers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
     *         layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
     *         version.
     */
    public final List<String> layers() {
        return layers;
    }

    /**
     * Returns true if the FileSystemConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFileSystemConfigs() {
        return fileSystemConfigs != null && !(fileSystemConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Connection settings for an Amazon EFS file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFileSystemConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Connection settings for an Amazon EFS file system.
     */
    public final List<FileSystemConfig> fileSystemConfigs() {
        return fileSystemConfigs;
    }

    /**
     * <p>
     * Configuration values that override the container image Dockerfile.
     * </p>
     * 
     * @return Configuration values that override the container image Dockerfile.
     */
    public final ImageConfig imageConfig() {
        return imageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemConfigs() ? fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionConfigurationRequest)) {
            return false;
        }
        UpdateFunctionConfigurationRequest other = (UpdateFunctionConfigurationRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(role(), other.role())
                && Objects.equals(handler(), other.handler()) && Objects.equals(description(), other.description())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(memorySize(), other.memorySize())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(environment(), other.environment())
                && Objects.equals(runtimeAsString(), other.runtimeAsString())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(tracingConfig(), other.tracingConfig()) && Objects.equals(revisionId(), other.revisionId())
                && hasLayers() == other.hasLayers() && Objects.equals(layers(), other.layers())
                && hasFileSystemConfigs() == other.hasFileSystemConfigs()
                && Objects.equals(fileSystemConfigs(), other.fileSystemConfigs())
                && Objects.equals(imageConfig(), other.imageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionConfigurationRequest").add("FunctionName", functionName()).add("Role", role())
                .add("Handler", handler()).add("Description", description()).add("Timeout", timeout())
                .add("MemorySize", memorySize()).add("VpcConfig", vpcConfig()).add("Environment", environment())
                .add("Runtime", runtimeAsString()).add("DeadLetterConfig", deadLetterConfig()).add("KMSKeyArn", kmsKeyArn())
                .add("TracingConfig", tracingConfig()).add("RevisionId", revisionId())
                .add("Layers", hasLayers() ? layers() : null)
                .add("FileSystemConfigs", hasFileSystemConfigs() ? fileSystemConfigs() : null).add("ImageConfig", imageConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MemorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "TracingConfig":
            return Optional.ofNullable(clazz.cast(tracingConfig()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "FileSystemConfigs":
            return Optional.ofNullable(clazz.cast(fileSystemConfigs()));
        case "ImageConfig":
            return Optional.ofNullable(clazz.cast(imageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateFunctionConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFunctionConfigurationRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function's execution role.
         * </p>
         * 
         * @param role
         *        The Amazon Resource Name (ARN) of the function's execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The name of the method within your code that Lambda calls to execute your function. The format includes the
         * file name. It can also include namespaces and other qualifiers, depending on the runtime. For more
         * information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming
         * Model</a>.
         * </p>
         * 
         * @param handler
         *        The name of the method within your code that Lambda calls to execute your function. The format
         *        includes the file name. It can also include namespaces and other qualifiers, depending on the runtime.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);

        /**
         * <p>
         * A description of the function.
         * </p>
         * 
         * @param description
         *        A description of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds. The
         * maximum allowed value is 900 seconds.
         * </p>
         * 
         * @param timeout
         *        The amount of time that Lambda allows a function to run before stopping it. The default is 3 seconds.
         *        The maximum allowed value is 900 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The amount of memory available to the function at runtime. Increasing the function's memory also increases
         * its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
         * </p>
         * 
         * @param memorySize
         *        The amount of memory available to the function at runtime. Increasing the function's memory also
         *        increases its CPU allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * <p>
         * For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC.
         * When you connect a function to a VPC, it can only access resources and the internet through that VPC. For
         * more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC
         * Settings</a>.
         * </p>
         * 
         * @param vpcConfig
         *        For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in
         *        the VPC. When you connect a function to a VPC, it can only access resources and the internet through
         *        that VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * For network connectivity to AWS resources in a VPC, specify a list of security groups and subnets in the VPC.
         * When you connect a function to a VPC, it can only access resources and the internet through that VPC. For
         * more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC
         * Settings</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Environment variables that are accessible from function code during execution.
         * </p>
         * 
         * @param environment
         *        Environment variables that are accessible from function code during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Environment environment);

        /**
         * <p>
         * Environment variables that are accessible from function code during execution.
         * </p>
         * This is a convenience that creates an instance of the {@link Environment.Builder} avoiding the need to create
         * one manually via {@link Environment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Environment.Builder#build()} is called immediately and its result
         * is passed to {@link #environment(Environment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link Environment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(Environment)
         */
        default Builder environment(Consumer<Environment.Builder> environment) {
            return environment(Environment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The identifier of the function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * </p>
         * 
         * @param runtime
         *        The identifier of the function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The identifier of the function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * </p>
         * 
         * @param runtime
         *        The identifier of the function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(Runtime runtime);

        /**
         * <p>
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
         * when they fail processing. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
         * </p>
         * 
         * @param deadLetterConfig
         *        A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous
         *        events when they fail processing. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
         * when they fail processing. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the need to
         * create one manually via {@link DeadLetterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's environment
         * variables. If it's not provided, AWS Lambda uses a default service key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the AWS Key Management Service (AWS KMS) key that's used to encrypt your function's
         *        environment variables. If it's not provided, AWS Lambda uses a default service key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS
         * X-Ray.
         * </p>
         * 
         * @param tracingConfig
         *        Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with
         *        AWS X-Ray.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfig(TracingConfig tracingConfig);

        /**
         * <p>
         * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with AWS
         * X-Ray.
         * </p>
         * This is a convenience that creates an instance of the {@link TracingConfig.Builder} avoiding the need to
         * create one manually via {@link TracingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TracingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #tracingConfig(TracingConfig)}.
         * 
         * @param tracingConfig
         *        a consumer that will call methods on {@link TracingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfig(TracingConfig)
         */
        default Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return tracingConfig(TracingConfig.builder().applyMutation(tracingConfig).build());
        }

        /**
         * <p>
         * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
         * modifying a function that has changed since you last read it.
         * </p>
         * 
         * @param revisionId
         *        Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
         *        modifying a function that has changed since you last read it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         * layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
         * version.
         * </p>
         * 
         * @param layers
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         *        layers</a> to add to the function's execution environment. Specify each layer by its ARN, including
         *        the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<String> layers);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         * layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
         * version.
         * </p>
         * 
         * @param layers
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         *        layers</a> to add to the function's execution environment. Specify each layer by its ARN, including
         *        the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(String... layers);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemConfigs
         *        Connection settings for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemConfigs
         *        Connection settings for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfigs(FileSystemConfig... fileSystemConfigs);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FileSystemConfig>.Builder} avoiding the
         * need to create one manually via {@link List<FileSystemConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #fileSystemConfigs(List<FileSystemConfig>)}.
         * 
         * @param fileSystemConfigs
         *        a consumer that will call methods on {@link List<FileSystemConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemConfigs(List<FileSystemConfig>)
         */
        Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder>... fileSystemConfigs);

        /**
         * <p>
         * Configuration values that override the container image Dockerfile.
         * </p>
         * 
         * @param imageConfig
         *        Configuration values that override the container image Dockerfile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfig(ImageConfig imageConfig);

        /**
         * <p>
         * Configuration values that override the container image Dockerfile.
         * </p>
         * This is a convenience that creates an instance of the {@link ImageConfig.Builder} avoiding the need to create
         * one manually via {@link ImageConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #imageConfig(ImageConfig)}.
         * 
         * @param imageConfig
         *        a consumer that will call methods on {@link ImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfig(ImageConfig)
         */
        default Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return imageConfig(ImageConfig.builder().applyMutation(imageConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String role;

        private String handler;

        private String description;

        private Integer timeout;

        private Integer memorySize;

        private VpcConfig vpcConfig;

        private Environment environment;

        private String runtime;

        private DeadLetterConfig deadLetterConfig;

        private String kmsKeyArn;

        private TracingConfig tracingConfig;

        private String revisionId;

        private List<String> layers = DefaultSdkAutoConstructList.getInstance();

        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();

        private ImageConfig imageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionConfigurationRequest model) {
            super(model);
            functionName(model.functionName);
            role(model.role);
            handler(model.handler);
            description(model.description);
            timeout(model.timeout);
            memorySize(model.memorySize);
            vpcConfig(model.vpcConfig);
            environment(model.environment);
            runtime(model.runtime);
            deadLetterConfig(model.deadLetterConfig);
            kmsKeyArn(model.kmsKeyArn);
            tracingConfig(model.tracingConfig);
            revisionId(model.revisionId);
            layers(model.layers);
            fileSystemConfigs(model.fileSystemConfigs);
            imageConfig(model.imageConfig);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getHandler() {
            return handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Environment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getRuntime() {
            return runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return tracingConfig != null ? tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final Collection<String> getLayers() {
            if (layers instanceof SdkAutoConstructList) {
                return null;
            }
            return layers;
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        public final Collection<FileSystemConfig.Builder> getFileSystemConfigs() {
            if (fileSystemConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return fileSystemConfigs != null ? fileSystemConfigs.stream().map(FileSystemConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig... fileSystemConfigs) {
            fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder>... fileSystemConfigs) {
            fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> FileSystemConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        public final ImageConfig.Builder getImageConfig() {
            return imageConfig != null ? imageConfig.toBuilder() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionConfigurationRequest build() {
            return new UpdateFunctionConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
