/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveLayerVersionPermissionRequest extends LambdaRequest implements
        ToCopyableBuilder<RemoveLayerVersionPermissionRequest.Builder, RemoveLayerVersionPermissionRequest> {
    private static final SdkField<String> LAYER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerName").getter(getter(RemoveLayerVersionPermissionRequest::layerName))
            .setter(setter(Builder::layerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("LayerName").build()).build();

    private static final SdkField<Long> VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VersionNumber").getter(getter(RemoveLayerVersionPermissionRequest::versionNumber))
            .setter(setter(Builder::versionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionNumber").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementId").getter(getter(RemoveLayerVersionPermissionRequest::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("StatementId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(RemoveLayerVersionPermissionRequest::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RevisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_NAME_FIELD,
            VERSION_NUMBER_FIELD, STATEMENT_ID_FIELD, REVISION_ID_FIELD));

    private final String layerName;

    private final Long versionNumber;

    private final String statementId;

    private final String revisionId;

    private RemoveLayerVersionPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.layerName = builder.layerName;
        this.versionNumber = builder.versionNumber;
        this.statementId = builder.statementId;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the layer.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the layer.
     */
    public final String layerName() {
        return layerName;
    }

    /**
     * <p>
     * The version number.
     * </p>
     * 
     * @return The version number.
     */
    public final Long versionNumber() {
        return versionNumber;
    }

    /**
     * <p>
     * The identifier that was specified when the statement was added.
     * </p>
     * 
     * @return The identifier that was specified when the statement was added.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * <p>
     * Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a policy
     * that has changed since you last read it.
     * </p>
     * 
     * @return Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
     *         policy that has changed since you last read it.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(layerName());
        hashCode = 31 * hashCode + Objects.hashCode(versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveLayerVersionPermissionRequest)) {
            return false;
        }
        RemoveLayerVersionPermissionRequest other = (RemoveLayerVersionPermissionRequest) obj;
        return Objects.equals(layerName(), other.layerName()) && Objects.equals(versionNumber(), other.versionNumber())
                && Objects.equals(statementId(), other.statementId()) && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveLayerVersionPermissionRequest").add("LayerName", layerName())
                .add("VersionNumber", versionNumber()).add("StatementId", statementId()).add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerName":
            return Optional.ofNullable(clazz.cast(layerName()));
        case "VersionNumber":
            return Optional.ofNullable(clazz.cast(versionNumber()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveLayerVersionPermissionRequest, T> g) {
        return obj -> g.apply((RemoveLayerVersionPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveLayerVersionPermissionRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the layer.
         * </p>
         * 
         * @param layerName
         *        The name or Amazon Resource Name (ARN) of the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerName(String layerName);

        /**
         * <p>
         * The version number.
         * </p>
         * 
         * @param versionNumber
         *        The version number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionNumber(Long versionNumber);

        /**
         * <p>
         * The identifier that was specified when the statement was added.
         * </p>
         * 
         * @param statementId
         *        The identifier that was specified when the statement was added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying a
         * policy that has changed since you last read it.
         * </p>
         * 
         * @param revisionId
         *        Only update the policy if the revision ID matches the ID specified. Use this option to avoid modifying
         *        a policy that has changed since you last read it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String layerName;

        private Long versionNumber;

        private String statementId;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveLayerVersionPermissionRequest model) {
            super(model);
            layerName(model.layerName);
            versionNumber(model.versionNumber);
            statementId(model.statementId);
            revisionId(model.revisionId);
        }

        public final String getLayerName() {
            return layerName;
        }

        @Override
        public final Builder layerName(String layerName) {
            this.layerName = layerName;
            return this;
        }

        public final void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public final Long getVersionNumber() {
            return versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveLayerVersionPermissionRequest build() {
            return new RemoveLayerVersionPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
