/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of functions and amount of storage in use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountUsage implements SdkPojo, Serializable, ToCopyableBuilder<AccountUsage.Builder, AccountUsage> {
    private static final SdkField<Long> TOTAL_CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalCodeSize").getter(getter(AccountUsage::totalCodeSize)).setter(setter(Builder::totalCodeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCodeSize").build()).build();

    private static final SdkField<Long> FUNCTION_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FunctionCount").getter(getter(AccountUsage::functionCount)).setter(setter(Builder::functionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_CODE_SIZE_FIELD,
            FUNCTION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalCodeSize;

    private final Long functionCount;

    private AccountUsage(BuilderImpl builder) {
        this.totalCodeSize = builder.totalCodeSize;
        this.functionCount = builder.functionCount;
    }

    /**
     * <p>
     * The amount of storage space, in bytes, that's being used by deployment packages and layer archives.
     * </p>
     * 
     * @return The amount of storage space, in bytes, that's being used by deployment packages and layer archives.
     */
    public final Long totalCodeSize() {
        return totalCodeSize;
    }

    /**
     * <p>
     * The number of Lambda functions.
     * </p>
     * 
     * @return The number of Lambda functions.
     */
    public final Long functionCount() {
        return functionCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCodeSize());
        hashCode = 31 * hashCode + Objects.hashCode(functionCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountUsage)) {
            return false;
        }
        AccountUsage other = (AccountUsage) obj;
        return Objects.equals(totalCodeSize(), other.totalCodeSize()) && Objects.equals(functionCount(), other.functionCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountUsage").add("TotalCodeSize", totalCodeSize()).add("FunctionCount", functionCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalCodeSize":
            return Optional.ofNullable(clazz.cast(totalCodeSize()));
        case "FunctionCount":
            return Optional.ofNullable(clazz.cast(functionCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountUsage, T> g) {
        return obj -> g.apply((AccountUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountUsage> {
        /**
         * <p>
         * The amount of storage space, in bytes, that's being used by deployment packages and layer archives.
         * </p>
         * 
         * @param totalCodeSize
         *        The amount of storage space, in bytes, that's being used by deployment packages and layer archives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCodeSize(Long totalCodeSize);

        /**
         * <p>
         * The number of Lambda functions.
         * </p>
         * 
         * @param functionCount
         *        The number of Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionCount(Long functionCount);
    }

    static final class BuilderImpl implements Builder {
        private Long totalCodeSize;

        private Long functionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountUsage model) {
            totalCodeSize(model.totalCodeSize);
            functionCount(model.functionCount);
        }

        public final Long getTotalCodeSize() {
            return totalCodeSize;
        }

        @Override
        public final Builder totalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
            return this;
        }

        public final void setTotalCodeSize(Long totalCodeSize) {
            this.totalCodeSize = totalCodeSize;
        }

        public final Long getFunctionCount() {
            return functionCount;
        }

        @Override
        public final Builder functionCount(Long functionCount) {
            this.functionCount = functionCount;
            return this;
        }

        public final void setFunctionCount(Long functionCount) {
            this.functionCount = functionCount;
        }

        @Override
        public AccountUsage build() {
            return new AccountUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
