/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a version of an <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">AWS
 * Lambda layer</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayerVersionContentOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<LayerVersionContentOutput.Builder, LayerVersionContentOutput> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(LayerVersionContentOutput::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSha256").getter(getter(LayerVersionContentOutput::codeSha256)).setter(setter(Builder::codeSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()).build();

    private static final SdkField<Long> CODE_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("CodeSize")
            .getter(getter(LayerVersionContentOutput::codeSize)).setter(setter(Builder::codeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSize").build()).build();

    private static final SdkField<String> SIGNING_PROFILE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningProfileVersionArn").getter(getter(LayerVersionContentOutput::signingProfileVersionArn))
            .setter(setter(Builder::signingProfileVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProfileVersionArn").build())
            .build();

    private static final SdkField<String> SIGNING_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SigningJobArn").getter(getter(LayerVersionContentOutput::signingJobArn))
            .setter(setter(Builder::signingJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningJobArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD,
            CODE_SHA256_FIELD, CODE_SIZE_FIELD, SIGNING_PROFILE_VERSION_ARN_FIELD, SIGNING_JOB_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String location;

    private final String codeSha256;

    private final Long codeSize;

    private final String signingProfileVersionArn;

    private final String signingJobArn;

    private LayerVersionContentOutput(BuilderImpl builder) {
        this.location = builder.location;
        this.codeSha256 = builder.codeSha256;
        this.codeSize = builder.codeSize;
        this.signingProfileVersionArn = builder.signingProfileVersionArn;
        this.signingJobArn = builder.signingJobArn;
    }

    /**
     * <p>
     * A link to the layer archive in Amazon S3 that is valid for 10 minutes.
     * </p>
     * 
     * @return A link to the layer archive in Amazon S3 that is valid for 10 minutes.
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * The SHA-256 hash of the layer archive.
     * </p>
     * 
     * @return The SHA-256 hash of the layer archive.
     */
    public final String codeSha256() {
        return codeSha256;
    }

    /**
     * <p>
     * The size of the layer archive in bytes.
     * </p>
     * 
     * @return The size of the layer archive in bytes.
     */
    public final Long codeSize() {
        return codeSize;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a signing profile version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a signing profile version.
     */
    public final String signingProfileVersionArn() {
        return signingProfileVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a signing job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a signing job.
     */
    public final String signingJobArn() {
        return signingJobArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(codeSize());
        hashCode = 31 * hashCode + Objects.hashCode(signingProfileVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(signingJobArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayerVersionContentOutput)) {
            return false;
        }
        LayerVersionContentOutput other = (LayerVersionContentOutput) obj;
        return Objects.equals(location(), other.location()) && Objects.equals(codeSha256(), other.codeSha256())
                && Objects.equals(codeSize(), other.codeSize())
                && Objects.equals(signingProfileVersionArn(), other.signingProfileVersionArn())
                && Objects.equals(signingJobArn(), other.signingJobArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayerVersionContentOutput").add("Location", location()).add("CodeSha256", codeSha256())
                .add("CodeSize", codeSize()).add("SigningProfileVersionArn", signingProfileVersionArn())
                .add("SigningJobArn", signingJobArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "CodeSha256":
            return Optional.ofNullable(clazz.cast(codeSha256()));
        case "CodeSize":
            return Optional.ofNullable(clazz.cast(codeSize()));
        case "SigningProfileVersionArn":
            return Optional.ofNullable(clazz.cast(signingProfileVersionArn()));
        case "SigningJobArn":
            return Optional.ofNullable(clazz.cast(signingJobArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LayerVersionContentOutput, T> g) {
        return obj -> g.apply((LayerVersionContentOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayerVersionContentOutput> {
        /**
         * <p>
         * A link to the layer archive in Amazon S3 that is valid for 10 minutes.
         * </p>
         * 
         * @param location
         *        A link to the layer archive in Amazon S3 that is valid for 10 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * The SHA-256 hash of the layer archive.
         * </p>
         * 
         * @param codeSha256
         *        The SHA-256 hash of the layer archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSha256(String codeSha256);

        /**
         * <p>
         * The size of the layer archive in bytes.
         * </p>
         * 
         * @param codeSize
         *        The size of the layer archive in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSize(Long codeSize);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a signing profile version.
         * </p>
         * 
         * @param signingProfileVersionArn
         *        The Amazon Resource Name (ARN) for a signing profile version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileVersionArn(String signingProfileVersionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a signing job.
         * </p>
         * 
         * @param signingJobArn
         *        The Amazon Resource Name (ARN) of a signing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingJobArn(String signingJobArn);
    }

    static final class BuilderImpl implements Builder {
        private String location;

        private String codeSha256;

        private Long codeSize;

        private String signingProfileVersionArn;

        private String signingJobArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LayerVersionContentOutput model) {
            location(model.location);
            codeSha256(model.codeSha256);
            codeSize(model.codeSize);
            signingProfileVersionArn(model.signingProfileVersionArn);
            signingJobArn(model.signingJobArn);
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getCodeSha256() {
            return codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final Long getCodeSize() {
            return codeSize;
        }

        @Override
        public final Builder codeSize(Long codeSize) {
            this.codeSize = codeSize;
            return this;
        }

        public final void setCodeSize(Long codeSize) {
            this.codeSize = codeSize;
        }

        public final String getSigningProfileVersionArn() {
            return signingProfileVersionArn;
        }

        @Override
        public final Builder signingProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
            return this;
        }

        public final void setSigningProfileVersionArn(String signingProfileVersionArn) {
            this.signingProfileVersionArn = signingProfileVersionArn;
        }

        public final String getSigningJobArn() {
            return signingJobArn;
        }

        @Override
        public final Builder signingJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
            return this;
        }

        public final void setSigningJobArn(String signingJobArn) {
            this.signingJobArn = signingJobArn;
        }

        @Override
        public LayerVersionContentOutput build() {
            return new LayerVersionContentOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
