/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeRequest extends LambdaRequest implements ToCopyableBuilder<InvokeRequest.Builder, InvokeRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(InvokeRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationType").getter(getter(InvokeRequest::invocationTypeAsString))
            .setter(setter(Builder::invocationType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Invocation-Type").build())
            .build();

    private static final SdkField<String> LOG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogType").getter(getter(InvokeRequest::logTypeAsString)).setter(setter(Builder::logType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Log-Type").build()).build();

    private static final SdkField<String> CLIENT_CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientContext").getter(getter(InvokeRequest::clientContext)).setter(setter(Builder::clientContext))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Context").build())
            .build();

    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Payload")
            .getter(getter(InvokeRequest::payload))
            .setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(InvokeRequest::qualifier)).setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            INVOCATION_TYPE_FIELD, LOG_TYPE_FIELD, CLIENT_CONTEXT_FIELD, PAYLOAD_FIELD, QUALIFIER_FIELD));

    private final String functionName;

    private final String invocationType;

    private final String logType;

    private final String clientContext;

    private final SdkBytes payload;

    private final String qualifier;

    private InvokeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.invocationType = builder.invocationType;
        this.logType = builder.logType;
        this.clientContext = builder.clientContext;
        this.payload = builder.payload;
        this.qualifier = builder.qualifier;
    }

    /**
     * <p>
     * The name of the Lambda function, version, or alias.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full
     * ARN. If you specify only the function name, it is limited to 64 characters in length.
     * </p>
     * 
     * @return The name of the Lambda function, version, or alias.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can append a version number or alias to any of the formats. The length constraint applies only to the
     *         full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * Choose from the following options.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the
     * function returns a response or times out. The API response includes the function response and additional data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured). The API response only includes a status code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the
     * function.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Choose from the following options.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open
     *         until the function returns a response or times out. The API response includes the function response and
     *         additional data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
     *         function's dead-letter queue (if it's configured). The API response only includes a status code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke
     *         the function.
     *         </p>
     *         </li>
     * @see InvocationType
     */
    public final InvocationType invocationType() {
        return InvocationType.fromValue(invocationType);
    }

    /**
     * <p>
     * Choose from the following options.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until the
     * function returns a response or times out. The API response includes the function response and additional data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the function's
     * dead-letter queue (if it's configured). The API response only includes a status code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the
     * function.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationType}
     * will return {@link InvocationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #invocationTypeAsString}.
     * </p>
     * 
     * @return Choose from the following options.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open
     *         until the function returns a response or times out. The API response includes the function response and
     *         additional data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
     *         function's dead-letter queue (if it's configured). The API response only includes a status code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke
     *         the function.
     *         </p>
     *         </li>
     * @see InvocationType
     */
    public final String invocationTypeAsString() {
        return invocationType;
    }

    /**
     * <p>
     * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions
     * only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
     *         functions only.
     * @see LogType
     */
    public final LogType logType() {
        return LogType.fromValue(logType);
    }

    /**
     * <p>
     * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked functions
     * only.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logType} will
     * return {@link LogType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logTypeAsString}.
     * </p>
     * 
     * @return Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
     *         functions only.
     * @see LogType
     */
    public final String logTypeAsString() {
        return logType;
    }

    /**
     * <p>
     * Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context object.
     * </p>
     * 
     * @return Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context
     *         object.
     */
    public final String clientContext() {
        return clientContext;
    }

    /**
     * <p>
     * The JSON that you want to provide to your Lambda function as input.
     * </p>
     * <p>
     * You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also specify a
     * file path. For example, <code>--payload file://payload.json</code>.
     * </p>
     * 
     * @return The JSON that you want to provide to your Lambda function as input.</p>
     *         <p>
     *         You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also
     *         specify a file path. For example, <code>--payload file://payload.json</code>.
     */
    public final SdkBytes payload() {
        return payload;
    }

    /**
     * <p>
     * Specify a version or alias to invoke a published version of the function.
     * </p>
     * 
     * @return Specify a version or alias to invoke a published version of the function.
     */
    public final String qualifier() {
        return qualifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientContext());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRequest)) {
            return false;
        }
        InvokeRequest other = (InvokeRequest) obj;
        return Objects.equals(functionName(), other.functionName())
                && Objects.equals(invocationTypeAsString(), other.invocationTypeAsString())
                && Objects.equals(logTypeAsString(), other.logTypeAsString())
                && Objects.equals(clientContext(), other.clientContext()) && Objects.equals(payload(), other.payload())
                && Objects.equals(qualifier(), other.qualifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeRequest").add("FunctionName", functionName())
                .add("InvocationType", invocationTypeAsString()).add("LogType", logTypeAsString())
                .add("ClientContext", clientContext())
                .add("Payload", payload() == null ? null : "*** Sensitive Data Redacted ***").add("Qualifier", qualifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "InvocationType":
            return Optional.ofNullable(clazz.cast(invocationTypeAsString()));
        case "LogType":
            return Optional.ofNullable(clazz.cast(logTypeAsString()));
        case "ClientContext":
            return Optional.ofNullable(clazz.cast(clientContext()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeRequest, T> g) {
        return obj -> g.apply((InvokeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeRequest> {
        /**
         * <p>
         * The name of the Lambda function, version, or alias.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can append a version number or alias to any of the formats. The length constraint applies only to the
         * full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function, version, or alias.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can append a version number or alias to any of the formats. The length constraint applies only to
         *        the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * Choose from the following options.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until
         * the function returns a response or times out. The API response includes the function response and additional
         * data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
         * function's dead-letter queue (if it's configured). The API response only includes a status code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the
         * function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invocationType
         *        Choose from the following options.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open
         *        until the function returns a response or times out. The API response includes the function response
         *        and additional data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
         *        function's dead-letter queue (if it's configured). The API response only includes a status code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to
         *        invoke the function.
         *        </p>
         *        </li>
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(String invocationType);

        /**
         * <p>
         * Choose from the following options.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open until
         * the function returns a response or times out. The API response includes the function response and additional
         * data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
         * function's dead-letter queue (if it's configured). The API response only includes a status code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to invoke the
         * function.
         * </p>
         * </li>
         * </ul>
         * 
         * @param invocationType
         *        Choose from the following options.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RequestResponse</code> (default) - Invoke the function synchronously. Keep the connection open
         *        until the function returns a response or times out. The API response includes the function response
         *        and additional data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Event</code> - Invoke the function asynchronously. Send events that fail multiple times to the
         *        function's dead-letter queue (if it's configured). The API response only includes a status code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DryRun</code> - Validate parameter values and verify that the user or role has permission to
         *        invoke the function.
         *        </p>
         *        </li>
         * @see InvocationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvocationType
         */
        Builder invocationType(InvocationType invocationType);

        /**
         * <p>
         * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
         * functions only.
         * </p>
         * 
         * @param logType
         *        Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously
         *        invoked functions only.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(String logType);

        /**
         * <p>
         * Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously invoked
         * functions only.
         * </p>
         * 
         * @param logType
         *        Set to <code>Tail</code> to include the execution log in the response. Applies to synchronously
         *        invoked functions only.
         * @see LogType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogType
         */
        Builder logType(LogType logType);

        /**
         * <p>
         * Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the context
         * object.
         * </p>
         * 
         * @param clientContext
         *        Up to 3583 bytes of base64-encoded data about the invoking client to pass to the function in the
         *        context object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientContext(String clientContext);

        /**
         * <p>
         * The JSON that you want to provide to your Lambda function as input.
         * </p>
         * <p>
         * You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can also
         * specify a file path. For example, <code>--payload file://payload.json</code>.
         * </p>
         * 
         * @param payload
         *        The JSON that you want to provide to your Lambda function as input.</p>
         *        <p>
         *        You can enter the JSON directly. For example, <code>--payload '{ "key": "value" }'</code>. You can
         *        also specify a file path. For example, <code>--payload file://payload.json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(SdkBytes payload);

        /**
         * <p>
         * Specify a version or alias to invoke a published version of the function.
         * </p>
         * 
         * @param qualifier
         *        Specify a version or alias to invoke a published version of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String invocationType;

        private String logType;

        private String clientContext;

        private SdkBytes payload;

        private String qualifier;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeRequest model) {
            super(model);
            functionName(model.functionName);
            invocationType(model.invocationType);
            logType(model.logType);
            clientContext(model.clientContext);
            payload(model.payload);
            qualifier(model.qualifier);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getInvocationType() {
            return invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        @Transient
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        @Transient
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final String getLogType() {
            return logType;
        }

        public final void setLogType(String logType) {
            this.logType = logType;
        }

        @Override
        @Transient
        public final Builder logType(String logType) {
            this.logType = logType;
            return this;
        }

        @Override
        @Transient
        public final Builder logType(LogType logType) {
            this.logType(logType == null ? null : logType.toString());
            return this;
        }

        public final String getClientContext() {
            return clientContext;
        }

        public final void setClientContext(String clientContext) {
            this.clientContext = clientContext;
        }

        @Override
        @Transient
        public final Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public final ByteBuffer getPayload() {
            return payload == null ? null : payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            payload(payload == null ? null : SdkBytes.fromByteBuffer(payload));
        }

        @Override
        @Transient
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        @Transient
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeRequest build() {
            return new InvokeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
