/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html">Code signing
 * configuration</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeSigningConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeSigningConfig.Builder, CodeSigningConfig> {
    private static final SdkField<String> CODE_SIGNING_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSigningConfigId").getter(getter(CodeSigningConfig::codeSigningConfigId))
            .setter(setter(Builder::codeSigningConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigId").build())
            .build();

    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSigningConfigArn").getter(getter(CodeSigningConfig::codeSigningConfigArn))
            .setter(setter(Builder::codeSigningConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CodeSigningConfig::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AllowedPublishers> ALLOWED_PUBLISHERS_FIELD = SdkField
            .<AllowedPublishers> builder(MarshallingType.SDK_POJO).memberName("AllowedPublishers")
            .getter(getter(CodeSigningConfig::allowedPublishers)).setter(setter(Builder::allowedPublishers))
            .constructor(AllowedPublishers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPublishers").build()).build();

    private static final SdkField<CodeSigningPolicies> CODE_SIGNING_POLICIES_FIELD = SdkField
            .<CodeSigningPolicies> builder(MarshallingType.SDK_POJO).memberName("CodeSigningPolicies")
            .getter(getter(CodeSigningConfig::codeSigningPolicies)).setter(setter(Builder::codeSigningPolicies))
            .constructor(CodeSigningPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningPolicies").build())
            .build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModified").getter(getter(CodeSigningConfig::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_ID_FIELD,
            CODE_SIGNING_CONFIG_ARN_FIELD, DESCRIPTION_FIELD, ALLOWED_PUBLISHERS_FIELD, CODE_SIGNING_POLICIES_FIELD,
            LAST_MODIFIED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String codeSigningConfigId;

    private final String codeSigningConfigArn;

    private final String description;

    private final AllowedPublishers allowedPublishers;

    private final CodeSigningPolicies codeSigningPolicies;

    private final String lastModified;

    private CodeSigningConfig(BuilderImpl builder) {
        this.codeSigningConfigId = builder.codeSigningConfigId;
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.description = builder.description;
        this.allowedPublishers = builder.allowedPublishers;
        this.codeSigningPolicies = builder.codeSigningPolicies;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * Unique identifer for the Code signing configuration.
     * </p>
     * 
     * @return Unique identifer for the Code signing configuration.
     */
    public final String codeSigningConfigId() {
        return codeSigningConfigId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Code signing configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Code signing configuration.
     */
    public final String codeSigningConfigArn() {
        return codeSigningConfigArn;
    }

    /**
     * <p>
     * Code signing configuration description.
     * </p>
     * 
     * @return Code signing configuration description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * List of allowed publishers.
     * </p>
     * 
     * @return List of allowed publishers.
     */
    public final AllowedPublishers allowedPublishers() {
        return allowedPublishers;
    }

    /**
     * <p>
     * The code signing policy controls the validation failure action for signature mismatch or expiry.
     * </p>
     * 
     * @return The code signing policy controls the validation failure action for signature mismatch or expiry.
     */
    public final CodeSigningPolicies codeSigningPolicies() {
        return codeSigningPolicies;
    }

    /**
     * <p>
     * The date and time that the Code signing configuration was last modified, in ISO-8601 format
     * (YYYY-MM-DDThh:mm:ss.sTZD).
     * </p>
     * 
     * @return The date and time that the Code signing configuration was last modified, in ISO-8601 format
     *         (YYYY-MM-DDThh:mm:ss.sTZD).
     */
    public final String lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(allowedPublishers());
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningConfig)) {
            return false;
        }
        CodeSigningConfig other = (CodeSigningConfig) obj;
        return Objects.equals(codeSigningConfigId(), other.codeSigningConfigId())
                && Objects.equals(codeSigningConfigArn(), other.codeSigningConfigArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(allowedPublishers(), other.allowedPublishers())
                && Objects.equals(codeSigningPolicies(), other.codeSigningPolicies())
                && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeSigningConfig").add("CodeSigningConfigId", codeSigningConfigId())
                .add("CodeSigningConfigArn", codeSigningConfigArn()).add("Description", description())
                .add("AllowedPublishers", allowedPublishers()).add("CodeSigningPolicies", codeSigningPolicies())
                .add("LastModified", lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CodeSigningConfigId":
            return Optional.ofNullable(clazz.cast(codeSigningConfigId()));
        case "CodeSigningConfigArn":
            return Optional.ofNullable(clazz.cast(codeSigningConfigArn()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AllowedPublishers":
            return Optional.ofNullable(clazz.cast(allowedPublishers()));
        case "CodeSigningPolicies":
            return Optional.ofNullable(clazz.cast(codeSigningPolicies()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeSigningConfig, T> g) {
        return obj -> g.apply((CodeSigningConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeSigningConfig> {
        /**
         * <p>
         * Unique identifer for the Code signing configuration.
         * </p>
         * 
         * @param codeSigningConfigId
         *        Unique identifer for the Code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigId(String codeSigningConfigId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Code signing configuration.
         * </p>
         * 
         * @param codeSigningConfigArn
         *        The Amazon Resource Name (ARN) of the Code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigArn(String codeSigningConfigArn);

        /**
         * <p>
         * Code signing configuration description.
         * </p>
         * 
         * @param description
         *        Code signing configuration description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * List of allowed publishers.
         * </p>
         * 
         * @param allowedPublishers
         *        List of allowed publishers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPublishers(AllowedPublishers allowedPublishers);

        /**
         * <p>
         * List of allowed publishers.
         * </p>
         * This is a convenience that creates an instance of the {@link AllowedPublishers.Builder} avoiding the need to
         * create one manually via {@link AllowedPublishers#builder()}.
         *
         * When the {@link Consumer} completes, {@link AllowedPublishers.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedPublishers(AllowedPublishers)}.
         * 
         * @param allowedPublishers
         *        a consumer that will call methods on {@link AllowedPublishers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedPublishers(AllowedPublishers)
         */
        default Builder allowedPublishers(Consumer<AllowedPublishers.Builder> allowedPublishers) {
            return allowedPublishers(AllowedPublishers.builder().applyMutation(allowedPublishers).build());
        }

        /**
         * <p>
         * The code signing policy controls the validation failure action for signature mismatch or expiry.
         * </p>
         * 
         * @param codeSigningPolicies
         *        The code signing policy controls the validation failure action for signature mismatch or expiry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies);

        /**
         * <p>
         * The code signing policy controls the validation failure action for signature mismatch or expiry.
         * </p>
         * This is a convenience that creates an instance of the {@link CodeSigningPolicies.Builder} avoiding the need
         * to create one manually via {@link CodeSigningPolicies#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSigningPolicies.Builder#build()} is called immediately and
         * its result is passed to {@link #codeSigningPolicies(CodeSigningPolicies)}.
         * 
         * @param codeSigningPolicies
         *        a consumer that will call methods on {@link CodeSigningPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSigningPolicies(CodeSigningPolicies)
         */
        default Builder codeSigningPolicies(Consumer<CodeSigningPolicies.Builder> codeSigningPolicies) {
            return codeSigningPolicies(CodeSigningPolicies.builder().applyMutation(codeSigningPolicies).build());
        }

        /**
         * <p>
         * The date and time that the Code signing configuration was last modified, in ISO-8601 format
         * (YYYY-MM-DDThh:mm:ss.sTZD).
         * </p>
         * 
         * @param lastModified
         *        The date and time that the Code signing configuration was last modified, in ISO-8601 format
         *        (YYYY-MM-DDThh:mm:ss.sTZD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);
    }

    static final class BuilderImpl implements Builder {
        private String codeSigningConfigId;

        private String codeSigningConfigArn;

        private String description;

        private AllowedPublishers allowedPublishers;

        private CodeSigningPolicies codeSigningPolicies;

        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningConfig model) {
            codeSigningConfigId(model.codeSigningConfigId);
            codeSigningConfigArn(model.codeSigningConfigArn);
            description(model.description);
            allowedPublishers(model.allowedPublishers);
            codeSigningPolicies(model.codeSigningPolicies);
            lastModified(model.lastModified);
        }

        public final String getCodeSigningConfigId() {
            return codeSigningConfigId;
        }

        public final void setCodeSigningConfigId(String codeSigningConfigId) {
            this.codeSigningConfigId = codeSigningConfigId;
        }

        @Override
        @Transient
        public final Builder codeSigningConfigId(String codeSigningConfigId) {
            this.codeSigningConfigId = codeSigningConfigId;
            return this;
        }

        public final String getCodeSigningConfigArn() {
            return codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        @Transient
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AllowedPublishers.Builder getAllowedPublishers() {
            return allowedPublishers != null ? allowedPublishers.toBuilder() : null;
        }

        public final void setAllowedPublishers(AllowedPublishers.BuilderImpl allowedPublishers) {
            this.allowedPublishers = allowedPublishers != null ? allowedPublishers.build() : null;
        }

        @Override
        @Transient
        public final Builder allowedPublishers(AllowedPublishers allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        public final CodeSigningPolicies.Builder getCodeSigningPolicies() {
            return codeSigningPolicies != null ? codeSigningPolicies.toBuilder() : null;
        }

        public final void setCodeSigningPolicies(CodeSigningPolicies.BuilderImpl codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies != null ? codeSigningPolicies.build() : null;
        }

        @Override
        @Transient
        public final Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        public final String getLastModified() {
            return lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        @Transient
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public CodeSigningConfig build() {
            return new CodeSigningConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
