/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionEventInvokeConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateFunctionEventInvokeConfigRequest.Builder, UpdateFunctionEventInvokeConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateFunctionEventInvokeConfigRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<String> QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Qualifier").getter(getter(UpdateFunctionEventInvokeConfigRequest::qualifier))
            .setter(setter(Builder::qualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()).build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(UpdateFunctionEventInvokeConfigRequest::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumEventAgeInSeconds")
            .getter(getter(UpdateFunctionEventInvokeConfigRequest::maximumEventAgeInSeconds))
            .setter(setter(Builder::maximumEventAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEventAgeInSeconds").build())
            .build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("DestinationConfig")
            .getter(getter(UpdateFunctionEventInvokeConfigRequest::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            QUALIFIER_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD, DESTINATION_CONFIG_FIELD));

    private final String functionName;

    private final String qualifier;

    private final Integer maximumRetryAttempts;

    private final Integer maximumEventAgeInSeconds;

    private final DestinationConfig destinationConfig;

    private UpdateFunctionEventInvokeConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
        this.destinationConfig = builder.destinationConfig;
    }

    /**
     * <p>
     * The name of the Lambda function, version, or alias.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full
     * ARN. If you specify only the function name, it is limited to 64 characters in length.
     * </p>
     * 
     * @return The name of the Lambda function, version, or alias.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can append a version number or alias to any of the formats. The length constraint applies only to the
     *         full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * A version number or alias name.
     * </p>
     * 
     * @return A version number or alias name.
     */
    public final String qualifier() {
        return qualifier;
    }

    /**
     * <p>
     * The maximum number of times to retry when the function returns an error.
     * </p>
     * 
     * @return The maximum number of times to retry when the function returns an error.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * The maximum age of a request that Lambda sends to a function for processing.
     * </p>
     * 
     * @return The maximum age of a request that Lambda sends to a function for processing.
     */
    public final Integer maximumEventAgeInSeconds() {
        return maximumEventAgeInSeconds;
    }

    /**
     * <p>
     * A destination for events after they have been sent to a function for processing.
     * </p>
     * <p class="title">
     * <b>Destinations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Queue</b> - The ARN of an SQS queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Topic</b> - The ARN of an SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A destination for events after they have been sent to a function for processing.</p>
     *         <p class="title">
     *         <b>Destinations</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Queue</b> - The ARN of an SQS queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Topic</b> - The ARN of an SNS topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
     *         </p>
     *         </li>
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(maximumEventAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionEventInvokeConfigRequest)) {
            return false;
        }
        UpdateFunctionEventInvokeConfigRequest other = (UpdateFunctionEventInvokeConfigRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(qualifier(), other.qualifier())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(maximumEventAgeInSeconds(), other.maximumEventAgeInSeconds())
                && Objects.equals(destinationConfig(), other.destinationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionEventInvokeConfigRequest").add("FunctionName", functionName())
                .add("Qualifier", qualifier()).add("MaximumRetryAttempts", maximumRetryAttempts())
                .add("MaximumEventAgeInSeconds", maximumEventAgeInSeconds()).add("DestinationConfig", destinationConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Qualifier":
            return Optional.ofNullable(clazz.cast(qualifier()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "MaximumEventAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumEventAgeInSeconds()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionEventInvokeConfigRequest, T> g) {
        return obj -> g.apply((UpdateFunctionEventInvokeConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFunctionEventInvokeConfigRequest> {
        /**
         * <p>
         * The name of the Lambda function, version, or alias.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can append a version number or alias to any of the formats. The length constraint applies only to the
         * full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function, version, or alias.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can append a version number or alias to any of the formats. The length constraint applies only to
         *        the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * A version number or alias name.
         * </p>
         * 
         * @param qualifier
         *        A version number or alias name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualifier(String qualifier);

        /**
         * <p>
         * The maximum number of times to retry when the function returns an error.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        The maximum number of times to retry when the function returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * The maximum age of a request that Lambda sends to a function for processing.
         * </p>
         * 
         * @param maximumEventAgeInSeconds
         *        The maximum age of a request that Lambda sends to a function for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds);

        /**
         * <p>
         * A destination for events after they have been sent to a function for processing.
         * </p>
         * <p class="title">
         * <b>Destinations</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Queue</b> - The ARN of an SQS queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Topic</b> - The ARN of an SNS topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationConfig
         *        A destination for events after they have been sent to a function for processing.</p>
         *        <p class="title">
         *        <b>Destinations</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Queue</b> - The ARN of an SQS queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Topic</b> - The ARN of an SNS topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * A destination for events after they have been sent to a function for processing.
         * </p>
         * <p class="title">
         * <b>Destinations</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Queue</b> - The ARN of an SQS queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Topic</b> - The ARN of an SNS topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link DestinationConfig.Builder} avoiding the need to
         * create one manually via {@link DestinationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String qualifier;

        private Integer maximumRetryAttempts;

        private Integer maximumEventAgeInSeconds;

        private DestinationConfig destinationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionEventInvokeConfigRequest model) {
            super(model);
            functionName(model.functionName);
            qualifier(model.qualifier);
            maximumRetryAttempts(model.maximumRetryAttempts);
            maximumEventAgeInSeconds(model.maximumEventAgeInSeconds);
            destinationConfig(model.destinationConfig);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        @Transient
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        @Transient
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getMaximumEventAgeInSeconds() {
            return maximumEventAgeInSeconds;
        }

        public final void setMaximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
        }

        @Override
        @Transient
        public final Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionEventInvokeConfigRequest build() {
            return new UpdateFunctionEventInvokeConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
