/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionCodeRequest extends LambdaRequest implements
        ToCopyableBuilder<UpdateFunctionCodeRequest.Builder, UpdateFunctionCodeRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(UpdateFunctionCodeRequest::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()).build();

    private static final SdkField<SdkBytes> ZIP_FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("ZipFile").getter(getter(UpdateFunctionCodeRequest::zipFile)).setter(setter(Builder::zipFile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipFile").build()).build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3Bucket").getter(getter(UpdateFunctionCodeRequest::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Key")
            .getter(getter(UpdateFunctionCodeRequest::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()).build();

    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ObjectVersion").getter(getter(UpdateFunctionCodeRequest::s3ObjectVersion))
            .setter(setter(Builder::s3ObjectVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectVersion").build()).build();

    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageUri").getter(getter(UpdateFunctionCodeRequest::imageUri)).setter(setter(Builder::imageUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()).build();

    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Publish").getter(getter(UpdateFunctionCodeRequest::publish)).setter(setter(Builder::publish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publish").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(UpdateFunctionCodeRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(UpdateFunctionCodeRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Architectures")
            .getter(getter(UpdateFunctionCodeRequest::architecturesAsStrings))
            .setter(setter(Builder::architecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            ZIP_FILE_FIELD, S3_BUCKET_FIELD, S3_KEY_FIELD, S3_OBJECT_VERSION_FIELD, IMAGE_URI_FIELD, PUBLISH_FIELD,
            DRY_RUN_FIELD, REVISION_ID_FIELD, ARCHITECTURES_FIELD));

    private final String functionName;

    private final SdkBytes zipFile;

    private final String s3Bucket;

    private final String s3Key;

    private final String s3ObjectVersion;

    private final String imageUri;

    private final Boolean publish;

    private final Boolean dryRun;

    private final String revisionId;

    private final List<String> architectures;

    private UpdateFunctionCodeRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.zipFile = builder.zipFile;
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.imageUri = builder.imageUri;
        this.publish = builder.publish;
        this.dryRun = builder.dryRun;
        this.revisionId = builder.revisionId;
        this.architectures = builder.architectures;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI
     * clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment
     * package.
     * </p>
     * 
     * @return The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services
     *         CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive
     *         deployment package.
     */
    public final SdkBytes zipFile() {
        return zipFile;
    }

    /**
     * <p>
     * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different
     * Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.
     * </p>
     * 
     * @return An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a
     *         different Amazon Web Services account. Use only with a function defined with a .zip file archive
     *         deployment package.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive deployment
     * package.
     * </p>
     * 
     * @return The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive
     *         deployment package.
     */
    public final String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * For versioned objects, the version of the deployment package object to use.
     * </p>
     * 
     * @return For versioned objects, the version of the deployment package object to use.
     */
    public final String s3ObjectVersion() {
        return s3ObjectVersion;
    }

    /**
     * <p>
     * URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file archive.
     * </p>
     * 
     * @return URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file
     *         archive.
     */
    public final String imageUri() {
        return imageUri;
    }

    /**
     * <p>
     * Set to true to publish a new version of the function after updating the code. This has the same effect as calling
     * <a>PublishVersion</a> separately.
     * </p>
     * 
     * @return Set to true to publish a new version of the function after updating the code. This has the same effect as
     *         calling <a>PublishVersion</a> separately.
     */
    public final Boolean publish() {
        return publish;
    }

    /**
     * <p>
     * Set to true to validate the request parameters and access permissions without modifying the function code.
     * </p>
     * 
     * @return Set to true to validate the request parameters and access permissions without modifying the function
     *         code.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid modifying a
     * function that has changed since you last read it.
     * </p>
     * 
     * @return Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
     *         modifying a function that has changed since you last read it.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The instruction set architecture that the function supports. Enter a string array with one of the valid values
     * (arm64 or x86_64). The default value is <code>x86_64</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The instruction set architecture that the function supports. Enter a string array with one of the valid
     *         values (arm64 or x86_64). The default value is <code>x86_64</code>.
     */
    public final List<Architecture> architectures() {
        return ArchitecturesListCopier.copyStringToEnum(architectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the Architectures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectures() {
        return architectures != null && !(architectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instruction set architecture that the function supports. Enter a string array with one of the valid values
     * (arm64 or x86_64). The default value is <code>x86_64</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The instruction set architecture that the function supports. Enter a string array with one of the valid
     *         values (arm64 or x86_64). The default value is <code>x86_64</code>.
     */
    public final List<String> architecturesAsStrings() {
        return architectures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(zipFile());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(publish());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectures() ? architecturesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionCodeRequest)) {
            return false;
        }
        UpdateFunctionCodeRequest other = (UpdateFunctionCodeRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(zipFile(), other.zipFile())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key())
                && Objects.equals(s3ObjectVersion(), other.s3ObjectVersion()) && Objects.equals(imageUri(), other.imageUri())
                && Objects.equals(publish(), other.publish()) && Objects.equals(dryRun(), other.dryRun())
                && Objects.equals(revisionId(), other.revisionId()) && hasArchitectures() == other.hasArchitectures()
                && Objects.equals(architecturesAsStrings(), other.architecturesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionCodeRequest").add("FunctionName", functionName())
                .add("ZipFile", zipFile() == null ? null : "*** Sensitive Data Redacted ***").add("S3Bucket", s3Bucket())
                .add("S3Key", s3Key()).add("S3ObjectVersion", s3ObjectVersion()).add("ImageUri", imageUri())
                .add("Publish", publish()).add("DryRun", dryRun()).add("RevisionId", revisionId())
                .add("Architectures", hasArchitectures() ? architecturesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "ZipFile":
            return Optional.ofNullable(clazz.cast(zipFile()));
        case "S3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "S3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "S3ObjectVersion":
            return Optional.ofNullable(clazz.cast(s3ObjectVersion()));
        case "ImageUri":
            return Optional.ofNullable(clazz.cast(imageUri()));
        case "Publish":
            return Optional.ofNullable(clazz.cast(publish()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "Architectures":
            return Optional.ofNullable(clazz.cast(architecturesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionCodeRequest, T> g) {
        return obj -> g.apply((UpdateFunctionCodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFunctionCodeRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services CLI
         * clients handle the encoding for you. Use only with a function defined with a .zip file archive deployment
         * package.
         * </p>
         * 
         * @param zipFile
         *        The base64-encoded contents of the deployment package. Amazon Web Services SDK and Amazon Web Services
         *        CLI clients handle the encoding for you. Use only with a function defined with a .zip file archive
         *        deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipFile(SdkBytes zipFile);

        /**
         * <p>
         * An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a different
         * Amazon Web Services account. Use only with a function defined with a .zip file archive deployment package.
         * </p>
         * 
         * @param s3Bucket
         *        An Amazon S3 bucket in the same Amazon Web Services Region as your function. The bucket can be in a
         *        different Amazon Web Services account. Use only with a function defined with a .zip file archive
         *        deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive
         * deployment package.
         * </p>
         * 
         * @param s3Key
         *        The Amazon S3 key of the deployment package. Use only with a function defined with a .zip file archive
         *        deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * For versioned objects, the version of the deployment package object to use.
         * </p>
         * 
         * @param s3ObjectVersion
         *        For versioned objects, the version of the deployment package object to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectVersion(String s3ObjectVersion);

        /**
         * <p>
         * URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip file
         * archive.
         * </p>
         * 
         * @param imageUri
         *        URI of a container image in the Amazon ECR registry. Do not use for a function defined with a .zip
         *        file archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageUri(String imageUri);

        /**
         * <p>
         * Set to true to publish a new version of the function after updating the code. This has the same effect as
         * calling <a>PublishVersion</a> separately.
         * </p>
         * 
         * @param publish
         *        Set to true to publish a new version of the function after updating the code. This has the same effect
         *        as calling <a>PublishVersion</a> separately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publish(Boolean publish);

        /**
         * <p>
         * Set to true to validate the request parameters and access permissions without modifying the function code.
         * </p>
         * 
         * @param dryRun
         *        Set to true to validate the request parameters and access permissions without modifying the function
         *        code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
         * modifying a function that has changed since you last read it.
         * </p>
         * 
         * @param revisionId
         *        Only update the function if the revision ID matches the ID that's specified. Use this option to avoid
         *        modifying a function that has changed since you last read it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturesWithStrings(Collection<String> architectures);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturesWithStrings(String... architectures);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Collection<Architecture> architectures);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Architecture... architectures);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private SdkBytes zipFile;

        private String s3Bucket;

        private String s3Key;

        private String s3ObjectVersion;

        private String imageUri;

        private Boolean publish;

        private Boolean dryRun;

        private String revisionId;

        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionCodeRequest model) {
            super(model);
            functionName(model.functionName);
            zipFile(model.zipFile);
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
            s3ObjectVersion(model.s3ObjectVersion);
            imageUri(model.imageUri);
            publish(model.publish);
            dryRun(model.dryRun);
            revisionId(model.revisionId);
            architecturesWithStrings(model.architectures);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        @Transient
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final ByteBuffer getZipFile() {
            return zipFile == null ? null : zipFile.asByteBuffer();
        }

        public final void setZipFile(ByteBuffer zipFile) {
            zipFile(zipFile == null ? null : SdkBytes.fromByteBuffer(zipFile));
        }

        @Override
        @Transient
        public final Builder zipFile(SdkBytes zipFile) {
            this.zipFile = zipFile;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        @Transient
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        @Transient
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3ObjectVersion() {
            return s3ObjectVersion;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        @Override
        @Transient
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final String getImageUri() {
            return imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        @Transient
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final Boolean getPublish() {
            return publish;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        @Override
        @Transient
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        @Transient
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        @Transient
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
        }

        @Override
        @Transient
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architecturesWithStrings(String... architectures) {
            architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        @Transient
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitecturesListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectures(Architecture... architectures) {
            architectures(Arrays.asList(architectures));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionCodeRequest build() {
            return new UpdateFunctionCodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
