/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of Lambda functions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFunctionsResponse extends LambdaResponse implements
        ToCopyableBuilder<ListFunctionsResponse.Builder, ListFunctionsResponse> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextMarker").getter(getter(ListFunctionsResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()).build();

    private static final SdkField<List<FunctionConfiguration>> FUNCTIONS_FIELD = SdkField
            .<List<FunctionConfiguration>> builder(MarshallingType.LIST)
            .memberName("Functions")
            .getter(getter(ListFunctionsResponse::functions))
            .setter(setter(Builder::functions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Functions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FunctionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(FunctionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            FUNCTIONS_FIELD));

    private final String nextMarker;

    private final List<FunctionConfiguration> functions;

    private ListFunctionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextMarker = builder.nextMarker;
        this.functions = builder.functions;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Functions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFunctions() {
        return functions != null && !(functions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Lambda functions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFunctions} method.
     * </p>
     * 
     * @return A list of Lambda functions.
     */
    public final List<FunctionConfiguration> functions() {
        return functions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(hasFunctions() ? functions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionsResponse)) {
            return false;
        }
        ListFunctionsResponse other = (ListFunctionsResponse) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && hasFunctions() == other.hasFunctions()
                && Objects.equals(functions(), other.functions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFunctionsResponse").add("NextMarker", nextMarker())
                .add("Functions", hasFunctions() ? functions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "Functions":
            return Optional.ofNullable(clazz.cast(functions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionsResponse, T> g) {
        return obj -> g.apply((ListFunctionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFunctionsResponse> {
        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextMarker
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * A list of Lambda functions.
         * </p>
         * 
         * @param functions
         *        A list of Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(Collection<FunctionConfiguration> functions);

        /**
         * <p>
         * A list of Lambda functions.
         * </p>
         * 
         * @param functions
         *        A list of Lambda functions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functions(FunctionConfiguration... functions);

        /**
         * <p>
         * A list of Lambda functions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FunctionConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<FunctionConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FunctionConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #functions(List<FunctionConfiguration>)}.
         * 
         * @param functions
         *        a consumer that will call methods on {@link List<FunctionConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functions(List<FunctionConfiguration>)
         */
        Builder functions(Consumer<FunctionConfiguration.Builder>... functions);
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private String nextMarker;

        private List<FunctionConfiguration> functions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionsResponse model) {
            super(model);
            nextMarker(model.nextMarker);
            functions(model.functions);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final List<FunctionConfiguration.Builder> getFunctions() {
            List<FunctionConfiguration.Builder> result = FunctionListCopier.copyToBuilder(this.functions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctions(Collection<FunctionConfiguration.BuilderImpl> functions) {
            this.functions = FunctionListCopier.copyFromBuilder(functions);
        }

        @Override
        public final Builder functions(Collection<FunctionConfiguration> functions) {
            this.functions = FunctionListCopier.copy(functions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(FunctionConfiguration... functions) {
            functions(Arrays.asList(functions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functions(Consumer<FunctionConfiguration.Builder>... functions) {
            functions(Stream.of(functions).map(c -> FunctionConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFunctionsResponse build() {
            return new ListFunctionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
