/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionEventInvokeConfigResponse extends LambdaResponse implements
        ToCopyableBuilder<UpdateFunctionEventInvokeConfigResponse.Builder, UpdateFunctionEventInvokeConfigResponse> {
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(UpdateFunctionEventInvokeConfigResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<String> FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionArn").getter(getter(UpdateFunctionEventInvokeConfigResponse::functionArn))
            .setter(setter(Builder::functionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionArn").build()).build();

    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumRetryAttempts").getter(getter(UpdateFunctionEventInvokeConfigResponse::maximumRetryAttempts))
            .setter(setter(Builder::maximumRetryAttempts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumEventAgeInSeconds")
            .getter(getter(UpdateFunctionEventInvokeConfigResponse::maximumEventAgeInSeconds))
            .setter(setter(Builder::maximumEventAgeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumEventAgeInSeconds").build())
            .build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).memberName("DestinationConfig")
            .getter(getter(UpdateFunctionEventInvokeConfigResponse::destinationConfig))
            .setter(setter(Builder::destinationConfig)).constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_FIELD,
            FUNCTION_ARN_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, MAXIMUM_EVENT_AGE_IN_SECONDS_FIELD, DESTINATION_CONFIG_FIELD));

    private final Instant lastModified;

    private final String functionArn;

    private final Integer maximumRetryAttempts;

    private final Integer maximumEventAgeInSeconds;

    private final DestinationConfig destinationConfig;

    private UpdateFunctionEventInvokeConfigResponse(BuilderImpl builder) {
        super(builder);
        this.lastModified = builder.lastModified;
        this.functionArn = builder.functionArn;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.maximumEventAgeInSeconds = builder.maximumEventAgeInSeconds;
        this.destinationConfig = builder.destinationConfig;
    }

    /**
     * <p>
     * The date and time that the configuration was last updated.
     * </p>
     * 
     * @return The date and time that the configuration was last updated.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function.
     */
    public final String functionArn() {
        return functionArn;
    }

    /**
     * <p>
     * The maximum number of times to retry when the function returns an error.
     * </p>
     * 
     * @return The maximum number of times to retry when the function returns an error.
     */
    public final Integer maximumRetryAttempts() {
        return maximumRetryAttempts;
    }

    /**
     * <p>
     * The maximum age of a request that Lambda sends to a function for processing.
     * </p>
     * 
     * @return The maximum age of a request that Lambda sends to a function for processing.
     */
    public final Integer maximumEventAgeInSeconds() {
        return maximumEventAgeInSeconds;
    }

    /**
     * <p>
     * A destination for events after they have been sent to a function for processing.
     * </p>
     * <p class="title">
     * <b>Destinations</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Queue</b> - The ARN of an SQS queue.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Topic</b> - The ARN of an SNS topic.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A destination for events after they have been sent to a function for processing.</p>
     *         <p class="title">
     *         <b>Destinations</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Queue</b> - The ARN of an SQS queue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Topic</b> - The ARN of an SNS topic.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
     *         </p>
     *         </li>
     */
    public final DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(functionArn());
        hashCode = 31 * hashCode + Objects.hashCode(maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(maximumEventAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionEventInvokeConfigResponse)) {
            return false;
        }
        UpdateFunctionEventInvokeConfigResponse other = (UpdateFunctionEventInvokeConfigResponse) obj;
        return Objects.equals(lastModified(), other.lastModified()) && Objects.equals(functionArn(), other.functionArn())
                && Objects.equals(maximumRetryAttempts(), other.maximumRetryAttempts())
                && Objects.equals(maximumEventAgeInSeconds(), other.maximumEventAgeInSeconds())
                && Objects.equals(destinationConfig(), other.destinationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionEventInvokeConfigResponse").add("LastModified", lastModified())
                .add("FunctionArn", functionArn()).add("MaximumRetryAttempts", maximumRetryAttempts())
                .add("MaximumEventAgeInSeconds", maximumEventAgeInSeconds()).add("DestinationConfig", destinationConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "FunctionArn":
            return Optional.ofNullable(clazz.cast(functionArn()));
        case "MaximumRetryAttempts":
            return Optional.ofNullable(clazz.cast(maximumRetryAttempts()));
        case "MaximumEventAgeInSeconds":
            return Optional.ofNullable(clazz.cast(maximumEventAgeInSeconds()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionEventInvokeConfigResponse, T> g) {
        return obj -> g.apply((UpdateFunctionEventInvokeConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFunctionEventInvokeConfigResponse> {
        /**
         * <p>
         * The date and time that the configuration was last updated.
         * </p>
         * 
         * @param lastModified
         *        The date and time that the configuration was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function.
         * </p>
         * 
         * @param functionArn
         *        The Amazon Resource Name (ARN) of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionArn(String functionArn);

        /**
         * <p>
         * The maximum number of times to retry when the function returns an error.
         * </p>
         * 
         * @param maximumRetryAttempts
         *        The maximum number of times to retry when the function returns an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumRetryAttempts(Integer maximumRetryAttempts);

        /**
         * <p>
         * The maximum age of a request that Lambda sends to a function for processing.
         * </p>
         * 
         * @param maximumEventAgeInSeconds
         *        The maximum age of a request that Lambda sends to a function for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds);

        /**
         * <p>
         * A destination for events after they have been sent to a function for processing.
         * </p>
         * <p class="title">
         * <b>Destinations</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Queue</b> - The ARN of an SQS queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Topic</b> - The ARN of an SNS topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
         * </p>
         * </li>
         * </ul>
         * 
         * @param destinationConfig
         *        A destination for events after they have been sent to a function for processing.</p>
         *        <p class="title">
         *        <b>Destinations</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Queue</b> - The ARN of an SQS queue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Topic</b> - The ARN of an SNS topic.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * A destination for events after they have been sent to a function for processing.
         * </p>
         * <p class="title">
         * <b>Destinations</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function</b> - The Amazon Resource Name (ARN) of a Lambda function.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Queue</b> - The ARN of an SQS queue.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Topic</b> - The ARN of an SNS topic.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Event Bus</b> - The ARN of an Amazon EventBridge event bus.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link DestinationConfig.Builder} avoiding the
         * need to create one manually via {@link DestinationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }
    }

    static final class BuilderImpl extends LambdaResponse.BuilderImpl implements Builder {
        private Instant lastModified;

        private String functionArn;

        private Integer maximumRetryAttempts;

        private Integer maximumEventAgeInSeconds;

        private DestinationConfig destinationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionEventInvokeConfigResponse model) {
            super(model);
            lastModified(model.lastModified);
            functionArn(model.functionArn);
            maximumRetryAttempts(model.maximumRetryAttempts);
            maximumEventAgeInSeconds(model.maximumEventAgeInSeconds);
            destinationConfig(model.destinationConfig);
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final String getFunctionArn() {
            return functionArn;
        }

        public final void setFunctionArn(String functionArn) {
            this.functionArn = functionArn;
        }

        @Override
        public final Builder functionArn(String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final Integer getMaximumEventAgeInSeconds() {
            return maximumEventAgeInSeconds;
        }

        public final void setMaximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
        }

        @Override
        public final Builder maximumEventAgeInSeconds(Integer maximumEventAgeInSeconds) {
            this.maximumEventAgeInSeconds = maximumEventAgeInSeconds;
            return this;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        @Override
        public UpdateFunctionEventInvokeConfigResponse build() {
            return new UpdateFunctionEventInvokeConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
