/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCodeSigningConfigRequest extends LambdaRequest implements
        ToCopyableBuilder<CreateCodeSigningConfigRequest.Builder, CreateCodeSigningConfigRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCodeSigningConfigRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<AllowedPublishers> ALLOWED_PUBLISHERS_FIELD = SdkField
            .<AllowedPublishers> builder(MarshallingType.SDK_POJO).memberName("AllowedPublishers")
            .getter(getter(CreateCodeSigningConfigRequest::allowedPublishers)).setter(setter(Builder::allowedPublishers))
            .constructor(AllowedPublishers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPublishers").build()).build();

    private static final SdkField<CodeSigningPolicies> CODE_SIGNING_POLICIES_FIELD = SdkField
            .<CodeSigningPolicies> builder(MarshallingType.SDK_POJO).memberName("CodeSigningPolicies")
            .getter(getter(CreateCodeSigningConfigRequest::codeSigningPolicies)).setter(setter(Builder::codeSigningPolicies))
            .constructor(CodeSigningPolicies::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningPolicies").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            ALLOWED_PUBLISHERS_FIELD, CODE_SIGNING_POLICIES_FIELD));

    private final String description;

    private final AllowedPublishers allowedPublishers;

    private final CodeSigningPolicies codeSigningPolicies;

    private CreateCodeSigningConfigRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.allowedPublishers = builder.allowedPublishers;
        this.codeSigningPolicies = builder.codeSigningPolicies;
    }

    /**
     * <p>
     * Descriptive name for this code signing configuration.
     * </p>
     * 
     * @return Descriptive name for this code signing configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Signing profiles for this code signing configuration.
     * </p>
     * 
     * @return Signing profiles for this code signing configuration.
     */
    public final AllowedPublishers allowedPublishers() {
        return allowedPublishers;
    }

    /**
     * <p>
     * The code signing policies define the actions to take if the validation checks fail.
     * </p>
     * 
     * @return The code signing policies define the actions to take if the validation checks fail.
     */
    public final CodeSigningPolicies codeSigningPolicies() {
        return codeSigningPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(allowedPublishers());
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningPolicies());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCodeSigningConfigRequest)) {
            return false;
        }
        CreateCodeSigningConfigRequest other = (CreateCodeSigningConfigRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(allowedPublishers(), other.allowedPublishers())
                && Objects.equals(codeSigningPolicies(), other.codeSigningPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCodeSigningConfigRequest").add("Description", description())
                .add("AllowedPublishers", allowedPublishers()).add("CodeSigningPolicies", codeSigningPolicies()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AllowedPublishers":
            return Optional.ofNullable(clazz.cast(allowedPublishers()));
        case "CodeSigningPolicies":
            return Optional.ofNullable(clazz.cast(codeSigningPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCodeSigningConfigRequest, T> g) {
        return obj -> g.apply((CreateCodeSigningConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCodeSigningConfigRequest> {
        /**
         * <p>
         * Descriptive name for this code signing configuration.
         * </p>
         * 
         * @param description
         *        Descriptive name for this code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Signing profiles for this code signing configuration.
         * </p>
         * 
         * @param allowedPublishers
         *        Signing profiles for this code signing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPublishers(AllowedPublishers allowedPublishers);

        /**
         * <p>
         * Signing profiles for this code signing configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowedPublishers.Builder} avoiding the
         * need to create one manually via {@link AllowedPublishers#builder()}.
         *
         * When the {@link Consumer} completes, {@link AllowedPublishers.Builder#build()} is called immediately and its
         * result is passed to {@link #allowedPublishers(AllowedPublishers)}.
         * 
         * @param allowedPublishers
         *        a consumer that will call methods on {@link AllowedPublishers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allowedPublishers(AllowedPublishers)
         */
        default Builder allowedPublishers(Consumer<AllowedPublishers.Builder> allowedPublishers) {
            return allowedPublishers(AllowedPublishers.builder().applyMutation(allowedPublishers).build());
        }

        /**
         * <p>
         * The code signing policies define the actions to take if the validation checks fail.
         * </p>
         * 
         * @param codeSigningPolicies
         *        The code signing policies define the actions to take if the validation checks fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies);

        /**
         * <p>
         * The code signing policies define the actions to take if the validation checks fail.
         * </p>
         * This is a convenience method that creates an instance of the {@link CodeSigningPolicies.Builder} avoiding the
         * need to create one manually via {@link CodeSigningPolicies#builder()}.
         *
         * When the {@link Consumer} completes, {@link CodeSigningPolicies.Builder#build()} is called immediately and
         * its result is passed to {@link #codeSigningPolicies(CodeSigningPolicies)}.
         * 
         * @param codeSigningPolicies
         *        a consumer that will call methods on {@link CodeSigningPolicies.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeSigningPolicies(CodeSigningPolicies)
         */
        default Builder codeSigningPolicies(Consumer<CodeSigningPolicies.Builder> codeSigningPolicies) {
            return codeSigningPolicies(CodeSigningPolicies.builder().applyMutation(codeSigningPolicies).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String description;

        private AllowedPublishers allowedPublishers;

        private CodeSigningPolicies codeSigningPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCodeSigningConfigRequest model) {
            super(model);
            description(model.description);
            allowedPublishers(model.allowedPublishers);
            codeSigningPolicies(model.codeSigningPolicies);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AllowedPublishers.Builder getAllowedPublishers() {
            return allowedPublishers != null ? allowedPublishers.toBuilder() : null;
        }

        public final void setAllowedPublishers(AllowedPublishers.BuilderImpl allowedPublishers) {
            this.allowedPublishers = allowedPublishers != null ? allowedPublishers.build() : null;
        }

        @Override
        public final Builder allowedPublishers(AllowedPublishers allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        public final CodeSigningPolicies.Builder getCodeSigningPolicies() {
            return codeSigningPolicies != null ? codeSigningPolicies.toBuilder() : null;
        }

        public final void setCodeSigningPolicies(CodeSigningPolicies.BuilderImpl codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies != null ? codeSigningPolicies.build() : null;
        }

        @Override
        public final Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCodeSigningConfigRequest build() {
            return new CreateCodeSigningConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
