/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFunctionRequest extends LambdaRequest implements
        ToCopyableBuilder<CreateFunctionRequest.Builder, CreateFunctionRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(CreateFunctionRequest::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Runtime")
            .getter(getter(CreateFunctionRequest::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateFunctionRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Handler")
            .getter(getter(CreateFunctionRequest::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final SdkField<FunctionCode> CODE_FIELD = SdkField.<FunctionCode> builder(MarshallingType.SDK_POJO)
            .memberName("Code").getter(getter(CreateFunctionRequest::code)).setter(setter(Builder::code))
            .constructor(FunctionCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFunctionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(CreateFunctionRequest::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemorySize").getter(getter(CreateFunctionRequest::memorySize)).setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()).build();

    private static final SdkField<Boolean> PUBLISH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Publish").getter(getter(CreateFunctionRequest::publish)).setter(setter(Builder::publish))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Publish").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateFunctionRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(CreateFunctionRequest::packageTypeAsString))
            .setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<DeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(CreateFunctionRequest::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(DeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<Environment> ENVIRONMENT_FIELD = SdkField.<Environment> builder(MarshallingType.SDK_POJO)
            .memberName("Environment").getter(getter(CreateFunctionRequest::environment)).setter(setter(Builder::environment))
            .constructor(Environment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyArn").getter(getter(CreateFunctionRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyArn").build()).build();

    private static final SdkField<TracingConfig> TRACING_CONFIG_FIELD = SdkField
            .<TracingConfig> builder(MarshallingType.SDK_POJO).memberName("TracingConfig")
            .getter(getter(CreateFunctionRequest::tracingConfig)).setter(setter(Builder::tracingConfig))
            .constructor(TracingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateFunctionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> LAYERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Layers")
            .getter(getter(CreateFunctionRequest::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FileSystemConfig>> FILE_SYSTEM_CONFIGS_FIELD = SdkField
            .<List<FileSystemConfig>> builder(MarshallingType.LIST)
            .memberName("FileSystemConfigs")
            .getter(getter(CreateFunctionRequest::fileSystemConfigs))
            .setter(setter(Builder::fileSystemConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileSystemConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileSystemConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ImageConfig> IMAGE_CONFIG_FIELD = SdkField.<ImageConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ImageConfig").getter(getter(CreateFunctionRequest::imageConfig)).setter(setter(Builder::imageConfig))
            .constructor(ImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfig").build()).build();

    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSigningConfigArn").getter(getter(CreateFunctionRequest::codeSigningConfigArn))
            .setter(setter(Builder::codeSigningConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build())
            .build();

    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Architectures")
            .getter(getter(CreateFunctionRequest::architecturesAsStrings))
            .setter(setter(Builder::architecturesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architectures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EphemeralStorage> EPHEMERAL_STORAGE_FIELD = SdkField
            .<EphemeralStorage> builder(MarshallingType.SDK_POJO).memberName("EphemeralStorage")
            .getter(getter(CreateFunctionRequest::ephemeralStorage)).setter(setter(Builder::ephemeralStorage))
            .constructor(EphemeralStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EphemeralStorage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            RUNTIME_FIELD, ROLE_FIELD, HANDLER_FIELD, CODE_FIELD, DESCRIPTION_FIELD, TIMEOUT_FIELD, MEMORY_SIZE_FIELD,
            PUBLISH_FIELD, VPC_CONFIG_FIELD, PACKAGE_TYPE_FIELD, DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, KMS_KEY_ARN_FIELD,
            TRACING_CONFIG_FIELD, TAGS_FIELD, LAYERS_FIELD, FILE_SYSTEM_CONFIGS_FIELD, IMAGE_CONFIG_FIELD,
            CODE_SIGNING_CONFIG_ARN_FIELD, ARCHITECTURES_FIELD, EPHEMERAL_STORAGE_FIELD));

    private final String functionName;

    private final String runtime;

    private final String role;

    private final String handler;

    private final FunctionCode code;

    private final String description;

    private final Integer timeout;

    private final Integer memorySize;

    private final Boolean publish;

    private final VpcConfig vpcConfig;

    private final String packageType;

    private final DeadLetterConfig deadLetterConfig;

    private final Environment environment;

    private final String kmsKeyArn;

    private final TracingConfig tracingConfig;

    private final Map<String, String> tags;

    private final List<String> layers;

    private final List<FileSystemConfig> fileSystemConfigs;

    private final ImageConfig imageConfig;

    private final String codeSigningConfigArn;

    private final List<String> architectures;

    private final EphemeralStorage ephemeralStorage;

    private CreateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.runtime = builder.runtime;
        this.role = builder.role;
        this.handler = builder.handler;
        this.code = builder.code;
        this.description = builder.description;
        this.timeout = builder.timeout;
        this.memorySize = builder.memorySize;
        this.publish = builder.publish;
        this.vpcConfig = builder.vpcConfig;
        this.packageType = builder.packageType;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tracingConfig = builder.tracingConfig;
        this.tags = builder.tags;
        this.layers = builder.layers;
        this.fileSystemConfigs = builder.fileSystemConfigs;
        this.imageConfig = builder.imageConfig;
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.architectures = builder.architectures;
        this.ephemeralStorage = builder.ephemeralStorage;
    }

    /**
     * <p>
     * The name of the Lambda function.
     * </p>
     * <p class="title">
     * <b>Name formats</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Function name</b> - <code>my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64
     * characters in length.
     * </p>
     * 
     * @return The name of the Lambda function.</p>
     *         <p class="title">
     *         <b>Name formats</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Function name</b> - <code>my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The length constraint applies only to the full ARN. If you specify only the function name, it is limited
     *         to 64 characters in length.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The identifier of the function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the
     * deployment package is a .zip file archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The identifier of the function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required
     *         if the deployment package is a .zip file archive.
     * @see Runtime
     */
    public final Runtime runtime() {
        return Runtime.fromValue(runtime);
    }

    /**
     * <p>
     * The identifier of the function's <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if the
     * deployment package is a .zip file archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link Runtime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runtimeAsString}.
     * </p>
     * 
     * @return The identifier of the function's <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required
     *         if the deployment package is a .zip file archive.
     * @see Runtime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the function's execution role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the function's execution role.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The name of the method within your code that Lambda calls to execute your function. Handler is required if the
     * deployment package is a .zip file archive. The format includes the file name. It can also include namespaces and
     * other qualifiers, depending on the runtime. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
     * </p>
     * 
     * @return The name of the method within your code that Lambda calls to execute your function. Handler is required
     *         if the deployment package is a .zip file archive. The format includes the file name. It can also include
     *         namespaces and other qualifiers, depending on the runtime. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
     */
    public final String handler() {
        return handler;
    }

    /**
     * <p>
     * The code for the function.
     * </p>
     * 
     * @return The code for the function.
     */
    public final FunctionCode code() {
        return code;
    }

    /**
     * <p>
     * A description of the function.
     * </p>
     * 
     * @return A description of the function.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3
     * seconds. The maximum allowed value is 900 seconds. For additional information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.
     * </p>
     * 
     * @return The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3
     *         seconds. The maximum allowed value is 900 seconds. For additional information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution
     *         environment</a>.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory available
     * to the function</a> at runtime. Increasing the function memory also increases its CPU allocation. The default
     * value is 128 MB. The value can be any multiple of 1 MB.
     * </p>
     * 
     * @return The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory
     *         available to the function</a> at runtime. Increasing the function memory also increases its CPU
     *         allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
     */
    public final Integer memorySize() {
        return memorySize;
    }

    /**
     * <p>
     * Set to true to publish the first version of the function during creation.
     * </p>
     * 
     * @return Set to true to publish the first version of the function during creation.
     */
    public final Boolean publish() {
        return publish;
    }

    /**
     * <p>
     * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and subnets
     * in the VPC. When you connect a function to a VPC, it can only access resources and the internet through that VPC.
     * For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC
     * Settings</a>.
     * </p>
     * 
     * @return For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and
     *         subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet
     *         through that VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP
     * archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
     *         for ZIP archive.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for ZIP
     * archive.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
     *         for ZIP archive.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events when
     * they fail processing. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
     * </p>
     * 
     * @return A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous
     *         events when they fail processing. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
     */
    public final DeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * Environment variables that are accessible from function code during execution.
     * </p>
     * 
     * @return Environment variables that are accessible from function code during execution.
     */
    public final Environment environment() {
        return environment;
    }

    /**
     * <p>
     * The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's
     * environment variables. If it's not provided, Lambda uses a default service key.
     * </p>
     * 
     * @return The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your
     *         function's environment variables. If it's not provided, Lambda uses a default service key.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.
     * </p>
     * 
     * @return Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.
     */
    public final TracingConfig tracingConfig() {
        return tracingConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the function.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
     *         function.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Layers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function layers</a> to
     * add to the function's execution environment. Specify each layer by its ARN, including the version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayers} method.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
     *         layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
     *         version.
     */
    public final List<String> layers() {
        return layers;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileSystemConfigs property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileSystemConfigs() {
        return fileSystemConfigs != null && !(fileSystemConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Connection settings for an Amazon EFS file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileSystemConfigs} method.
     * </p>
     * 
     * @return Connection settings for an Amazon EFS file system.
     */
    public final List<FileSystemConfig> fileSystemConfigs() {
        return fileSystemConfigs;
    }

    /**
     * <p>
     * Container image <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings"
     * >configuration values</a> that override the values in the container image Dockerfile.
     * </p>
     * 
     * @return Container image <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings"
     *         >configuration values</a> that override the values in the container image Dockerfile.
     */
    public final ImageConfig imageConfig() {
        return imageConfig;
    }

    /**
     * <p>
     * To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing
     * configuration includes a set of signing profiles, which define the trusted publishers for this function.
     * </p>
     * 
     * @return To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing
     *         configuration includes a set of signing profiles, which define the trusted publishers for this function.
     */
    public final String codeSigningConfigArn() {
        return codeSigningConfigArn;
    }

    /**
     * <p>
     * The instruction set architecture that the function supports. Enter a string array with one of the valid values
     * (arm64 or x86_64). The default value is <code>x86_64</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The instruction set architecture that the function supports. Enter a string array with one of the valid
     *         values (arm64 or x86_64). The default value is <code>x86_64</code>.
     */
    public final List<Architecture> architectures() {
        return ArchitecturesListCopier.copyStringToEnum(architectures);
    }

    /**
     * For responses, this returns true if the service returned a value for the Architectures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasArchitectures() {
        return architectures != null && !(architectures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instruction set architecture that the function supports. Enter a string array with one of the valid values
     * (arm64 or x86_64). The default value is <code>x86_64</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArchitectures} method.
     * </p>
     * 
     * @return The instruction set architecture that the function supports. Enter a string array with one of the valid
     *         values (arm64 or x86_64). The default value is <code>x86_64</code>.
     */
    public final List<String> architecturesAsStrings() {
        return architectures;
    }

    /**
     * <p>
     * The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number between
     * 512 and 10240 MB.
     * </p>
     * 
     * @return The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number
     *         between 512 and 10240 MB.
     */
    public final EphemeralStorage ephemeralStorage() {
        return ephemeralStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(publish());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFileSystemConfigs() ? fileSystemConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(imageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasArchitectures() ? architecturesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ephemeralStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionRequest)) {
            return false;
        }
        CreateFunctionRequest other = (CreateFunctionRequest) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(runtimeAsString(), other.runtimeAsString())
                && Objects.equals(role(), other.role()) && Objects.equals(handler(), other.handler())
                && Objects.equals(code(), other.code()) && Objects.equals(description(), other.description())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(memorySize(), other.memorySize())
                && Objects.equals(publish(), other.publish()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig())
                && Objects.equals(environment(), other.environment()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(tracingConfig(), other.tracingConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasLayers() == other.hasLayers()
                && Objects.equals(layers(), other.layers()) && hasFileSystemConfigs() == other.hasFileSystemConfigs()
                && Objects.equals(fileSystemConfigs(), other.fileSystemConfigs())
                && Objects.equals(imageConfig(), other.imageConfig())
                && Objects.equals(codeSigningConfigArn(), other.codeSigningConfigArn())
                && hasArchitectures() == other.hasArchitectures()
                && Objects.equals(architecturesAsStrings(), other.architecturesAsStrings())
                && Objects.equals(ephemeralStorage(), other.ephemeralStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFunctionRequest").add("FunctionName", functionName()).add("Runtime", runtimeAsString())
                .add("Role", role()).add("Handler", handler()).add("Code", code()).add("Description", description())
                .add("Timeout", timeout()).add("MemorySize", memorySize()).add("Publish", publish())
                .add("VpcConfig", vpcConfig()).add("PackageType", packageTypeAsString())
                .add("DeadLetterConfig", deadLetterConfig()).add("Environment", environment()).add("KMSKeyArn", kmsKeyArn())
                .add("TracingConfig", tracingConfig()).add("Tags", hasTags() ? tags() : null)
                .add("Layers", hasLayers() ? layers() : null)
                .add("FileSystemConfigs", hasFileSystemConfigs() ? fileSystemConfigs() : null).add("ImageConfig", imageConfig())
                .add("CodeSigningConfigArn", codeSigningConfigArn())
                .add("Architectures", hasArchitectures() ? architecturesAsStrings() : null)
                .add("EphemeralStorage", ephemeralStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "MemorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "Publish":
            return Optional.ofNullable(clazz.cast(publish()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "KMSKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "TracingConfig":
            return Optional.ofNullable(clazz.cast(tracingConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "FileSystemConfigs":
            return Optional.ofNullable(clazz.cast(fileSystemConfigs()));
        case "ImageConfig":
            return Optional.ofNullable(clazz.cast(imageConfig()));
        case "CodeSigningConfigArn":
            return Optional.ofNullable(clazz.cast(codeSigningConfigArn()));
        case "Architectures":
            return Optional.ofNullable(clazz.cast(architecturesAsStrings()));
        case "EphemeralStorage":
            return Optional.ofNullable(clazz.cast(ephemeralStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionRequest, T> g) {
        return obj -> g.apply((CreateFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LambdaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFunctionRequest> {
        /**
         * <p>
         * The name of the Lambda function.
         * </p>
         * <p class="title">
         * <b>Name formats</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Function name</b> - <code>my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to
         * 64 characters in length.
         * </p>
         * 
         * @param functionName
         *        The name of the Lambda function.</p>
         *        <p class="title">
         *        <b>Name formats</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Function name</b> - <code>my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Function ARN</b> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>Partial ARN</b> - <code>123456789012:function:my-function</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The length constraint applies only to the full ARN. If you specify only the function name, it is
         *        limited to 64 characters in length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The identifier of the function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if
         * the deployment package is a .zip file archive.
         * </p>
         * 
         * @param runtime
         *        The identifier of the function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is
         *        required if the deployment package is a .zip file archive.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The identifier of the function's <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is required if
         * the deployment package is a .zip file archive.
         * </p>
         * 
         * @param runtime
         *        The identifier of the function's <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html">runtime</a>. Runtime is
         *        required if the deployment package is a .zip file archive.
         * @see Runtime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Runtime
         */
        Builder runtime(Runtime runtime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the function's execution role.
         * </p>
         * 
         * @param role
         *        The Amazon Resource Name (ARN) of the function's execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The name of the method within your code that Lambda calls to execute your function. Handler is required if
         * the deployment package is a .zip file archive. The format includes the file name. It can also include
         * namespaces and other qualifiers, depending on the runtime. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
         * </p>
         * 
         * @param handler
         *        The name of the method within your code that Lambda calls to execute your function. Handler is
         *        required if the deployment package is a .zip file archive. The format includes the file name. It can
         *        also include namespaces and other qualifiers, depending on the runtime. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/programming-model-v2.html">Programming Model</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);

        /**
         * <p>
         * The code for the function.
         * </p>
         * 
         * @param code
         *        The code for the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(FunctionCode code);

        /**
         * <p>
         * The code for the function.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionCode.Builder} avoiding the need
         * to create one manually via {@link FunctionCode#builder()}.
         *
         * When the {@link Consumer} completes, {@link FunctionCode.Builder#build()} is called immediately and its
         * result is passed to {@link #code(FunctionCode)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link FunctionCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(FunctionCode)
         */
        default Builder code(Consumer<FunctionCode.Builder> code) {
            return code(FunctionCode.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * A description of the function.
         * </p>
         * 
         * @param description
         *        A description of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default is 3
         * seconds. The maximum allowed value is 900 seconds. For additional information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution environment</a>.
         * </p>
         * 
         * @param timeout
         *        The amount of time (in seconds) that Lambda allows a function to run before stopping it. The default
         *        is 3 seconds. The maximum allowed value is 900 seconds. For additional information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/runtimes-context.html">Lambda execution
         *        environment</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory
         * available to the function</a> at runtime. Increasing the function memory also increases its CPU allocation.
         * The default value is 128 MB. The value can be any multiple of 1 MB.
         * </p>
         * 
         * @param memorySize
         *        The amount of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-memory.html">memory
         *        available to the function</a> at runtime. Increasing the function memory also increases its CPU
         *        allocation. The default value is 128 MB. The value can be any multiple of 1 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * <p>
         * Set to true to publish the first version of the function during creation.
         * </p>
         * 
         * @param publish
         *        Set to true to publish the first version of the function during creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publish(Boolean publish);

        /**
         * <p>
         * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and
         * subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet
         * through that VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
         * </p>
         * 
         * @param vpcConfig
         *        For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups
         *        and subnets in the VPC. When you connect a function to a VPC, it can only access resources and the
         *        internet through that VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * For network connectivity to Amazon Web Services resources in a VPC, specify a list of security groups and
         * subnets in the VPC. When you connect a function to a VPC, it can only access resources and the internet
         * through that VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-vpc.html">VPC Settings</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for
         * ZIP archive.
         * </p>
         * 
         * @param packageType
         *        The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
         *        for ZIP archive.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code> for
         * ZIP archive.
         * </p>
         * 
         * @param packageType
         *        The type of deployment package. Set to <code>Image</code> for container image and set <code>Zip</code>
         *        for ZIP archive.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
         * when they fail processing. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
         * </p>
         * 
         * @param deadLetterConfig
         *        A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous
         *        events when they fail processing. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(DeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * A dead letter queue configuration that specifies the queue or topic where Lambda sends asynchronous events
         * when they fail processing. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-async.html#dlq">Dead Letter Queues</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeadLetterConfig.Builder} avoiding the
         * need to create one manually via {@link DeadLetterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeadLetterConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deadLetterConfig(DeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link DeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(DeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(DeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * Environment variables that are accessible from function code during execution.
         * </p>
         * 
         * @param environment
         *        Environment variables that are accessible from function code during execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Environment environment);

        /**
         * <p>
         * Environment variables that are accessible from function code during execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Environment.Builder} avoiding the need to
         * create one manually via {@link Environment#builder()}.
         *
         * When the {@link Consumer} completes, {@link Environment.Builder#build()} is called immediately and its result
         * is passed to {@link #environment(Environment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link Environment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(Environment)
         */
        default Builder environment(Consumer<Environment.Builder> environment) {
            return environment(Environment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your function's
         * environment variables. If it's not provided, Lambda uses a default service key.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the Amazon Web Services Key Management Service (KMS) key that's used to encrypt your
         *        function's environment variables. If it's not provided, Lambda uses a default service key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.
         * </p>
         * 
         * @param tracingConfig
         *        Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfig(TracingConfig tracingConfig);

        /**
         * <p>
         * Set <code>Mode</code> to <code>Active</code> to sample and trace a subset of incoming requests with <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">X-Ray</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link TracingConfig.Builder} avoiding the need
         * to create one manually via {@link TracingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TracingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #tracingConfig(TracingConfig)}.
         * 
         * @param tracingConfig
         *        a consumer that will call methods on {@link TracingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfig(TracingConfig)
         */
        default Builder tracingConfig(Consumer<TracingConfig.Builder> tracingConfig) {
            return tracingConfig(TracingConfig.builder().applyMutation(tracingConfig).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
         * function.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/tagging.html">tags</a> to apply to the
         *        function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         * layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
         * version.
         * </p>
         * 
         * @param layers
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         *        layers</a> to add to the function's execution environment. Specify each layer by its ARN, including
         *        the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<String> layers);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         * layers</a> to add to the function's execution environment. Specify each layer by its ARN, including the
         * version.
         * </p>
         * 
         * @param layers
         *        A list of <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html">function
         *        layers</a> to add to the function's execution environment. Specify each layer by its ARN, including
         *        the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(String... layers);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemConfigs
         *        Connection settings for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * 
         * @param fileSystemConfigs
         *        Connection settings for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemConfigs(FileSystemConfig... fileSystemConfigs);

        /**
         * <p>
         * Connection settings for an Amazon EFS file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FileSystemConfig>.Builder} avoiding
         * the need to create one manually via {@link List<FileSystemConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileSystemConfig>.Builder#build()} is called immediately and
         * its result is passed to {@link #fileSystemConfigs(List<FileSystemConfig>)}.
         * 
         * @param fileSystemConfigs
         *        a consumer that will call methods on {@link List<FileSystemConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemConfigs(List<FileSystemConfig>)
         */
        Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder>... fileSystemConfigs);

        /**
         * <p>
         * Container image <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings"
         * >configuration values</a> that override the values in the container image Dockerfile.
         * </p>
         * 
         * @param imageConfig
         *        Container image <a href=
         *        "https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings"
         *        >configuration values</a> that override the values in the container image Dockerfile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageConfig(ImageConfig imageConfig);

        /**
         * <p>
         * Container image <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-images.html#configuration-images-settings"
         * >configuration values</a> that override the values in the container image Dockerfile.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageConfig.Builder} avoiding the need to
         * create one manually via {@link ImageConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ImageConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #imageConfig(ImageConfig)}.
         * 
         * @param imageConfig
         *        a consumer that will call methods on {@link ImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageConfig(ImageConfig)
         */
        default Builder imageConfig(Consumer<ImageConfig.Builder> imageConfig) {
            return imageConfig(ImageConfig.builder().applyMutation(imageConfig).build());
        }

        /**
         * <p>
         * To enable code signing for this function, specify the ARN of a code-signing configuration. A code-signing
         * configuration includes a set of signing profiles, which define the trusted publishers for this function.
         * </p>
         * 
         * @param codeSigningConfigArn
         *        To enable code signing for this function, specify the ARN of a code-signing configuration. A
         *        code-signing configuration includes a set of signing profiles, which define the trusted publishers for
         *        this function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSigningConfigArn(String codeSigningConfigArn);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturesWithStrings(Collection<String> architectures);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architecturesWithStrings(String... architectures);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Collection<Architecture> architectures);

        /**
         * <p>
         * The instruction set architecture that the function supports. Enter a string array with one of the valid
         * values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * </p>
         * 
         * @param architectures
         *        The instruction set architecture that the function supports. Enter a string array with one of the
         *        valid values (arm64 or x86_64). The default value is <code>x86_64</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder architectures(Architecture... architectures);

        /**
         * <p>
         * The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number
         * between 512 and 10240 MB.
         * </p>
         * 
         * @param ephemeralStorage
         *        The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number
         *        between 512 and 10240 MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemeralStorage(EphemeralStorage ephemeralStorage);

        /**
         * <p>
         * The size of the function’s /tmp directory in MB. The default value is 512, but can be any whole number
         * between 512 and 10240 MB.
         * </p>
         * This is a convenience method that creates an instance of the {@link EphemeralStorage.Builder} avoiding the
         * need to create one manually via {@link EphemeralStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link EphemeralStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #ephemeralStorage(EphemeralStorage)}.
         * 
         * @param ephemeralStorage
         *        a consumer that will call methods on {@link EphemeralStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ephemeralStorage(EphemeralStorage)
         */
        default Builder ephemeralStorage(Consumer<EphemeralStorage.Builder> ephemeralStorage) {
            return ephemeralStorage(EphemeralStorage.builder().applyMutation(ephemeralStorage).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LambdaRequest.BuilderImpl implements Builder {
        private String functionName;

        private String runtime;

        private String role;

        private String handler;

        private FunctionCode code;

        private String description;

        private Integer timeout;

        private Integer memorySize;

        private Boolean publish;

        private VpcConfig vpcConfig;

        private String packageType;

        private DeadLetterConfig deadLetterConfig;

        private Environment environment;

        private String kmsKeyArn;

        private TracingConfig tracingConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<String> layers = DefaultSdkAutoConstructList.getInstance();

        private List<FileSystemConfig> fileSystemConfigs = DefaultSdkAutoConstructList.getInstance();

        private ImageConfig imageConfig;

        private String codeSigningConfigArn;

        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();

        private EphemeralStorage ephemeralStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionRequest model) {
            super(model);
            functionName(model.functionName);
            runtime(model.runtime);
            role(model.role);
            handler(model.handler);
            code(model.code);
            description(model.description);
            timeout(model.timeout);
            memorySize(model.memorySize);
            publish(model.publish);
            vpcConfig(model.vpcConfig);
            packageType(model.packageType);
            deadLetterConfig(model.deadLetterConfig);
            environment(model.environment);
            kmsKeyArn(model.kmsKeyArn);
            tracingConfig(model.tracingConfig);
            tags(model.tags);
            layers(model.layers);
            fileSystemConfigs(model.fileSystemConfigs);
            imageConfig(model.imageConfig);
            codeSigningConfigArn(model.codeSigningConfigArn);
            architecturesWithStrings(model.architectures);
            ephemeralStorage(model.ephemeralStorage);
        }

        public final String getFunctionName() {
            return functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(Runtime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getHandler() {
            return handler;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final FunctionCode.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        public final void setCode(FunctionCode.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        @Override
        public final Builder code(FunctionCode code) {
            this.code = code;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final Boolean getPublish() {
            return publish;
        }

        public final void setPublish(Boolean publish) {
            this.publish = publish;
        }

        @Override
        public final Builder publish(Boolean publish) {
            this.publish = publish;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final Environment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(Environment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final TracingConfig.Builder getTracingConfig() {
            return tracingConfig != null ? tracingConfig.toBuilder() : null;
        }

        public final void setTracingConfig(TracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        @Override
        public final Builder tracingConfig(TracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Collection<String> getLayers() {
            if (layers instanceof SdkAutoConstructList) {
                return null;
            }
            return layers;
        }

        public final void setLayers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
        }

        @Override
        public final Builder layers(Collection<String> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(String... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final List<FileSystemConfig.Builder> getFileSystemConfigs() {
            List<FileSystemConfig.Builder> result = FileSystemConfigListCopier.copyToBuilder(this.fileSystemConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemConfigs(Collection<FileSystemConfig.BuilderImpl> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copyFromBuilder(fileSystemConfigs);
        }

        @Override
        public final Builder fileSystemConfigs(Collection<FileSystemConfig> fileSystemConfigs) {
            this.fileSystemConfigs = FileSystemConfigListCopier.copy(fileSystemConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(FileSystemConfig... fileSystemConfigs) {
            fileSystemConfigs(Arrays.asList(fileSystemConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemConfigs(Consumer<FileSystemConfig.Builder>... fileSystemConfigs) {
            fileSystemConfigs(Stream.of(fileSystemConfigs).map(c -> FileSystemConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ImageConfig.Builder getImageConfig() {
            return imageConfig != null ? imageConfig.toBuilder() : null;
        }

        public final void setImageConfig(ImageConfig.BuilderImpl imageConfig) {
            this.imageConfig = imageConfig != null ? imageConfig.build() : null;
        }

        @Override
        public final Builder imageConfig(ImageConfig imageConfig) {
            this.imageConfig = imageConfig;
            return this;
        }

        public final String getCodeSigningConfigArn() {
            return codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final Collection<String> getArchitectures() {
            if (architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return architectures;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
        }

        @Override
        public final Builder architecturesWithStrings(Collection<String> architectures) {
            this.architectures = ArchitecturesListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architecturesWithStrings(String... architectures) {
            architecturesWithStrings(Arrays.asList(architectures));
            return this;
        }

        @Override
        public final Builder architectures(Collection<Architecture> architectures) {
            this.architectures = ArchitecturesListCopier.copyEnumToString(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(Architecture... architectures) {
            architectures(Arrays.asList(architectures));
            return this;
        }

        public final EphemeralStorage.Builder getEphemeralStorage() {
            return ephemeralStorage != null ? ephemeralStorage.toBuilder() : null;
        }

        public final void setEphemeralStorage(EphemeralStorage.BuilderImpl ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage != null ? ephemeralStorage.build() : null;
        }

        @Override
        public final Builder ephemeralStorage(EphemeralStorage ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionRequest build() {
            return new CreateFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
